/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.tools3d;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.io.IOException;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;

public class Orientation
extends DataTreeMemoryClass {
    public Quat4d viewDir;
    public Quat4d up;
    public double[] position;

    private static void interpolate(Quat4d quat4d, Quat4d quat4d2, Quat4d quat4d3, double d) {
        quat4d.set((Tuple4d)quat4d2);
        quat4d.normalize();
        Quat4d quat4d4 = new Quat4d(quat4d3);
        quat4d4.normalize();
        double d2 = quat4d.x * quat4d4.x + quat4d.y * quat4d4.y + quat4d.z * quat4d4.z + quat4d.w * quat4d4.w;
        if (1.0 <= Math.abs(d2)) {
            return;
        }
        double d3 = Math.sin(d2 = Math.acos(d2));
        if (Double.compare(d3, 0.0) == 0) {
            return;
        }
        double d4 = Math.sin((1.0 - d) * d2) / d3;
        d2 = Math.sin(d * d2) / d3;
        quat4d.x = (float)(d4 * quat4d.x + d2 * quat4d4.x);
        quat4d.y = (float)(d4 * quat4d.y + d2 * quat4d4.y);
        quat4d.z = (float)(d4 * quat4d.z + d2 * quat4d4.z);
        quat4d.w = (float)(d4 * quat4d.w + d2 * quat4d4.w);
    }

    public Orientation() {
        super("Orientation");
        this.viewDir = new Quat4d(0.0, 0.0, -1.0, 0.0);
        this.up = new Quat4d(0.0, 1.0, 0.0, 0.0);
        this.position = new double[]{0.0, 0.0, 0.0};
    }

    public Orientation(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super("Orientation");
        this.position = new double[]{d, d2, d3};
        this.viewDir = new Quat4d(d4, d5, d6, 0.0);
        this.up = new Quat4d(d7, d8, d9, 0.0);
        this.viewDir.normalize();
        this.up.normalize();
    }

    public Orientation(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public void copyTo(Orientation orientation) {
        this.normalize();
        orientation.position[0] = this.position[0];
        orientation.position[1] = this.position[1];
        orientation.position[2] = this.position[2];
        orientation.viewDir.set((Tuple4d)this.viewDir);
        orientation.up.set((Tuple4d)this.up);
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public void interPolate(Orientation orientation, Orientation orientation2, double d) {
        Orientation.interpolate(this.viewDir, orientation.viewDir, orientation2.viewDir, d);
        Orientation.interpolate(this.up, orientation.up, orientation2.up, d);
        this.position[0] = orientation.position[0] * (1.0 - d) + orientation2.position[0] * d;
        this.position[1] = orientation.position[1] * (1.0 - d) + orientation2.position[1] * d;
        this.position[2] = orientation.position[2] * (1.0 - d) + orientation2.position[2] * d;
    }

    public void moveAhead(double d) {
        this.position[0] = this.position[0] + d * this.viewDir.x;
        this.position[1] = this.position[1] + d * this.viewDir.y;
        this.position[2] = this.position[2] + d * this.viewDir.z;
    }

    public void moveUp(double d) {
        this.position[0] = this.position[0] + d * this.up.x;
        this.position[1] = this.position[1] + d * this.up.y;
        this.position[2] = this.position[2] + d * this.up.z;
    }

    public void normalize() {
        this.viewDir.normalize();
        this.up.normalize();
    }

    public void positionObject(GL2 gL2) {
        Vector3d vector3d = new Vector3d(this.viewDir.x, this.viewDir.y, this.viewDir.z);
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d(this.up.x, this.up.y, this.up.z);
        vector3d2.cross(vector3d, vector3d3);
        vector3d3.cross(vector3d2, vector3d);
        double[] dArray = new double[16];
        dArray[11] = 0.0;
        dArray[7] = 0.0;
        dArray[3] = 0.0;
        dArray[15] = 1.0;
        dArray[0] = vector3d2.x;
        dArray[1] = vector3d2.y;
        dArray[2] = vector3d2.z;
        dArray[4] = vector3d3.x;
        dArray[5] = vector3d3.y;
        dArray[6] = vector3d3.z;
        dArray[8] = -vector3d.x;
        dArray[9] = -vector3d.y;
        dArray[10] = -vector3d.z;
        dArray[12] = this.position[0];
        dArray[13] = this.position[1];
        dArray[14] = this.position[2];
        gL2.glMultMatrixd(dArray, 0);
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyDouble("dX", this.viewDir.x);
        randomOutputStream.writePropertyDouble("dY", this.viewDir.y);
        randomOutputStream.writePropertyDouble("dZ", this.viewDir.z);
        randomOutputStream.writePropertyDouble("uX", this.up.x);
        randomOutputStream.writePropertyDouble("uY", this.up.y);
        randomOutputStream.writePropertyDouble("uZ", this.up.z);
        randomOutputStream.writePropertyDouble("x", this.position[0]);
        randomOutputStream.writePropertyDouble("y", this.position[1]);
        randomOutputStream.writePropertyDouble("z", this.position[2]);
    }

    public void view(GLU gLU) {
        gLU.gluLookAt(this.position[0], this.position[1], this.position[2], this.position[0] + this.viewDir.x, this.position[1] + this.viewDir.y, this.position[2] + this.viewDir.z, this.up.x, this.up.y, this.up.z);
    }

    public void viewNoMove(GLU gLU) {
        gLU.gluLookAt(0.0, 0.0, 0.0, this.viewDir.x, this.viewDir.y, this.viewDir.z, this.up.x, this.up.y, this.up.z);
    }

    @Override
    protected void ClearDataLocal() throws IOException {
    }

    @Override
    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        this.viewDir = new Quat4d(randomInputStream.ReadBlockDouble(), randomInputStream.ReadBlockDouble(), randomInputStream.ReadBlockDouble(), 0.0);
        this.up = new Quat4d(randomInputStream.ReadBlockDouble(), randomInputStream.ReadBlockDouble(), randomInputStream.ReadBlockDouble(), 0.0);
        this.position = new double[]{randomInputStream.ReadBlockDouble(), randomInputStream.ReadBlockDouble(), randomInputStream.ReadBlockDouble()};
        this.viewDir.normalize();
        this.up.normalize();
    }

    protected void LoadProperty(MapProperty mapProperty) throws IOException {
        this.viewDir = new Quat4d(mapProperty.getPropertyDouble("dX"), mapProperty.getPropertyDouble("dY"), mapProperty.getPropertyDouble("dZ"), 0.0);
        this.up = new Quat4d(mapProperty.getPropertyDouble("uX"), mapProperty.getPropertyDouble("uY"), mapProperty.getPropertyDouble("uZ"), 0.0);
        this.position = new double[]{mapProperty.getPropertyDouble("x"), mapProperty.getPropertyDouble("y"), mapProperty.getPropertyDouble("z")};
        this.viewDir.normalize();
        this.up.normalize();
    }

    @Override
    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.WriteBlockDouble(this.viewDir.x);
        randomOutputStream.WriteBlockDouble(this.viewDir.y);
        randomOutputStream.WriteBlockDouble(this.viewDir.z);
        randomOutputStream.WriteBlockDouble(this.up.x);
        randomOutputStream.WriteBlockDouble(this.up.y);
        randomOutputStream.WriteBlockDouble(this.up.z);
        randomOutputStream.WriteBlockDouble(this.position[0]);
        randomOutputStream.WriteBlockDouble(this.position[1]);
        randomOutputStream.WriteBlockDouble(this.position[2]);
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }
}

