/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.tools3d;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.gl2.GLUT;
import javax.vecmath.Vector3f;

public class Utility {
    private static double[] modelViewCopy = new double[16];

    public static final void billboard(GL2 gL2) {
        gL2.glGetDoublev(2982, modelViewCopy, 0);
        Utility.modelViewCopy[0] = 1.0;
        Utility.modelViewCopy[2] = 0.0;
        Utility.modelViewCopy[1] = 0.0;
        Utility.modelViewCopy[4] = 0.0;
        Utility.modelViewCopy[5] = 1.0;
        Utility.modelViewCopy[6] = 0.0;
        Utility.modelViewCopy[9] = 0.0;
        Utility.modelViewCopy[8] = 0.0;
        Utility.modelViewCopy[10] = 1.0;
        gL2.glLoadMatrixd(modelViewCopy, 0);
    }

    public static final void billboard(GL2 gL2, float f, float f2, float f3, float f4, float f5, float f6) {
        double d = f - f4;
        double d2 = f3 - f6;
        double d3 = 1.0 / Math.sqrt(d * d + d2 * d2);
        gL2.glRotated(Math.acos(d2 *= d3) * 180.0 / Math.PI, 0.0, d *= d3, 0.0);
        Vector3f vector3f = new Vector3f(f - f4, f2 - f5, f3 - f6);
        vector3f.normalize();
        double d4 = d * (double)vector3f.x + d2 * (double)vector3f.z;
        if (vector3f.y < 0.0f) {
            gL2.glRotated(Math.acos(d4) * 180.0 / Math.PI, 1.0, 0.0, 0.0);
        } else {
            gL2.glRotated(Math.acos(d4) * 180.0 / Math.PI, -1.0, 0.0, 0.0);
        }
    }

    public static final void renderBitmapString(GL2 gL2, GLUT gLUT, float f, float f2, float f3, String string, int n, float[] fArray) {
        gL2.glColor4fv(fArray, 0);
        gL2.glRasterPos3f(f, f2, f3);
        int n2 = 7;
        if (n < 11) {
            n2 = 6;
        } else if (n > 15) {
            n2 = 8;
        }
        gLUT.glutBitmapString(n2, string);
    }

    public static final void renderStrokeString(GL2 gL2, GLUT gLUT, float f, float f2, float f3, boolean bl, String string, int n, float[] fArray) {
        Utility.renderStrokeString(gL2, gLUT, f, f2, f3, bl, string, n, fArray, true);
    }

    public static final void renderStrokeString(GL2 gL2, GLUT gLUT, float f, float f2, float f3, boolean bl, String string, int n, float[] fArray, boolean bl2) {
        if (fArray != null) {
            gL2.glColor4fv(fArray, 0);
        }
        gL2.glPushMatrix();
        gL2.glTranslatef(f, f2, f3);
        if (bl2) {
            Utility.billboard(gL2);
        }
        double d = (double)n * 2.0E-5;
        gL2.glScaled(d, d, d);
        if (!bl) {
            gL2.glTranslatef(-gLUT.glutStrokeLengthf(0, string), 0.0f, 0.0f);
        }
        gLUT.glutStrokeString(0, string);
        gL2.glPopMatrix();
    }

    public static final void renderStrokeString(GL2 gL2, GLUT gLUT, float f, float f2, float f3, String string, int n, float[] fArray) {
        Utility.renderStrokeString(gL2, gLUT, f, f2, f3, true, string, n, fArray, true);
    }

    private Utility() {
    }
}

