/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.update;

import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.RESTInvoker;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegKeyParserException;
import se.prediktera.map.register.RegisterKeyManager;

public class UpdateHelper {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String formatLabel(String string) {
        if (string == null) {
            return "";
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) {
                stringBuilder.append(c);
                if (c != ' ') continue;
                bl = true;
                continue;
            }
            if (i == 0) {
                stringBuilder.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (!bl) {
                    stringBuilder.append(" ");
                }
            } else {
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void getDownloadFile(Product product, UpdateCheckCallback updateCheckCallback) {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(1000L);
                DownloadFile downloadFile = UpdateHelper.getDownloadFile(UpdateHelper.getPlatform(), product);
                if (downloadFile != null) {
                    updateCheckCallback.update(downloadFile);
                } else {
                    updateCheckCallback.updateFailed(null);
                }
            }
            catch (Exception exception) {
                updateCheckCallback.updateFailed(exception);
            }
        });
        thread.start();
    }

    public static DownloadFile getDownloadFile(Platform platform, Product product) throws IOException {
        for (DownloadFile downloadFile : UpdateHelper.parseDownloadFiles(UpdateHelper.connectToDownloadUrl())) {
            if (!downloadFile.getPlatform().equals((Object)platform) || !downloadFile.getProduct().equals((Object)product)) continue;
            return downloadFile;
        }
        return null;
    }

    private static Url connectToDownloadUrl() throws IOException {
        return new Url(IniManager.getWebSite("download/update.php"), true, false);
    }

    public static boolean logUserAndUpdateLicense(Platform platform, Product product, UpdateVersion updateVersion) {
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        try {
            String string = RESTInvoker.getInstance().logUser(regInfo, platform, product, updateVersion);
            if (!string.isEmpty()) {
                if (string.startsWith("Error")) {
                    Logg.warn(string, new Object[0]);
                    return false;
                }
                RegInfo regInfo2 = new RegInfo(string);
                if (RegisterKeyManager.verifyRegInfo(regInfo2)) {
                    regInfo2.save(IniManager.getEvinceSettingsFile("license.key"));
                    RegisterKeyManager.regInfo = regInfo2;
                    Logg.info("Updating license.key file with new values from server", new Object[0]);
                    return true;
                }
            }
        }
        catch (RegKeyParserException regKeyParserException) {
            Logg.error("Cannot verify license", regKeyParserException);
        }
        catch (ErrorHandler.MessageException messageException) {
            Logg.error("Error getting license: " + messageException.getMessage(), new Object[0]);
        }
        catch (Exception exception) {
            Logg.error("Unknown error getting license", exception);
        }
        return false;
    }

    public static String readChangeLog(Product product) {
        String string;
        block8: {
            InputStream inputStream = new Url(IniManager.getWebSite("download/" + product.getChangeLog()), true, false).getInputStream();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return "N/A";
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static List<DownloadFile> parseDownloadFiles(Url url) {
        ArrayList<DownloadFile> arrayList;
        try (InputStream inputStream = url.getInputStream();){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            arrayList = new ArrayList<DownloadFile>();
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node = nodeList2.item(j);
                    if (node.getNodeType() != 1) continue;
                    Node node2 = node.getAttributes().getNamedItem("size");
                    Node node3 = node.getAttributes().getNamedItem("modified");
                    String string = node.getTextContent();
                    if (string.endsWith(".html")) continue;
                    arrayList.add(new DownloadFile(string, node2.getNodeValue(), node3.getNodeValue()));
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return arrayList;
    }

    public static File download(ProgressManager progressManager, DownloadFile downloadFile, File file) {
        try {
            Url url = new Url(IniManager.getWebSite("download/" + downloadFile.getFilename()));
            file.mkdirs();
            File file2 = new File(file, downloadFile.getFilename());
            progressManager.setInfoText("Downloading " + downloadFile.getFilename());
            int n = (int)downloadFile.getSize();
            if (UpdateHelper.download(progressManager, url, file2, n)) {
                return file2;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static boolean download(ProgressManager progressManager, Url url, File file, int n) throws IOException {
        InputStream inputStream = url.getInputStream();
        progressManager.setMaximumAndReset(n);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n2;
            byte[] byArray = new byte[4096];
            while (-1 != (n2 = inputStream.read(byArray))) {
                if (progressManager.isAborted()) {
                    fileOutputStream.close();
                    boolean bl = false;
                    return bl;
                }
                fileOutputStream.write(byArray, 0, n2);
                progressManager.incStep(n2);
            }
        }
        progressManager.setProgressValueDirectly(n);
        return true;
    }

    public static void runExe(File file) {
        try {
            if (file.exists()) {
                ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/C start " + file.getName());
                processBuilder.directory(file.getParentFile());
                processBuilder.start();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String formatSize(long l) {
        String[] stringArray = new String[]{"", "kB", "MB", "GB", "TB"};
        double d = l;
        for (String string : stringArray) {
            if (d < 1024.0) {
                return NiceDataFormat.toString(d, 4) + " " + string;
            }
            d /= 1024.0;
        }
        return NiceDataFormat.toString(d, 4) + " " + stringArray[stringArray.length - 1];
    }

    public static Platform getPlatform() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Platform.Windows;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return Platform.MacOSX;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return Platform.Linux;
        }
        Logg.warn("Failed to determine OS (" + System.getProperty("os.name") + ")", new Object[0]);
        return Platform.Unknown;
    }

    public static File getDownloadFolder() {
        return new File(System.getProperty("user.home"), "Downloads");
    }

    public static String getRestartText(Product product) {
        return "Press Ok to close down " + String.valueOf((Object)product) + " and start installation";
    }

    public static String getMacOSXText(Product product) {
        return "Please close down " + String.valueOf((Object)product) + ", unpack and move installation file manually from Download folder to Application folder and restart " + String.valueOf((Object)product);
    }

    public static enum Product {
        Evince,
        Breeze,
        BreezeRuntimeClient,
        BreezeRuntimeDemo,
        Unknown,
        BreezeRuntime;

        private static Product runningProduct;
        private static Runnable exitCallback;

        public String getReleaseNotesPage() {
            if (this == Evince) {
                return "https://help.prediktera.com/evince/release-notes";
            }
            return "https://help.prediktera.com/breeze/product-information";
        }

        public String getChangeLog() {
            return "Prediktera_" + String.valueOf((Object)this) + "_Changelog.html";
        }

        public String getType() {
            return String.valueOf(this.getTypeInt());
        }

        public int getTypeInt() {
            return this.ordinal() + 1;
        }

        public boolean usePing() {
            return this == Breeze;
        }

        public static void setRunningProduct(Product product) {
            runningProduct = product;
        }

        public static Product getRunningProduct() {
            if (runningProduct != null) {
                return runningProduct;
            }
            return Evince;
        }

        public static boolean isRunningProductEvince() {
            return Product.getRunningProduct().getMainProduct().equals((Object)Evince);
        }

        public static boolean isRunningProductBreezeSuite() {
            return Product.getRunningProduct().getMainProduct().equals((Object)Breeze);
        }

        public static boolean isRunningProductBreeze() {
            return Product.getRunningProduct().equals((Object)Breeze);
        }

        public static boolean isRunningProductBreezeClient() {
            return Product.getRunningProduct().equals((Object)BreezeRuntimeClient);
        }

        public Product getMainProduct() {
            return switch (this.ordinal()) {
                case 1, 2, 3 -> Breeze;
                case 5 -> BreezeRuntime;
                default -> Evince;
            };
        }

        public static void setExitCallback(Runnable runnable) {
            exitCallback = runnable;
        }

        public void exit() {
            exitCallback.run();
        }

        public synchronized void setFrameIcons(Window window) {
            String[] stringArray;
            ArrayList<Image> arrayList = new ArrayList<Image>();
            for (String string : stringArray = new String[]{"16", "32", "64", "128", "256"}) {
                arrayList.add(new ImageIcon(Objects.requireNonNull(Evince.class.getResource("/images/icons/" + this.getMainProduct().name() + "_" + string + ".png"))).getImage());
            }
            window.setIconImages(arrayList);
        }

        public String toString() {
            return UpdateHelper.formatLabel(this.name());
        }

        public static String getFullname() {
            return "Prediktera " + String.valueOf((Object)Product.getRunningProduct());
        }

        static {
            exitCallback = () -> System.exit(0);
        }
    }

    public static interface UpdateCheckCallback {
        public void update(DownloadFile var1);

        public void updateFailed(Exception var1);
    }

    public static class DownloadFile {
        private final String filename;
        private Product product;
        private Platform platform;
        private UpdateVersion version;
        private final long size;
        private final long lastModified;

        public DownloadFile(String string, String string2, String string3) {
            this.filename = string;
            String[] stringArray = string.split("_");
            if (stringArray.length >= 4) {
                this.product = Product.valueOf(stringArray[1]);
                try {
                    this.platform = Platform.valueOf(stringArray[2]);
                }
                catch (Exception exception) {
                    this.platform = Platform.Unknown;
                }
                this.version = new UpdateVersion(this.removeExtension(stringArray[3]));
            }
            this.size = Long.parseLong(string2);
            this.lastModified = Long.parseLong(string3);
        }

        private String removeExtension(String string) {
            if (string.endsWith(".zip") || string.endsWith(".exe")) {
                return string.substring(0, string.length() - ".zip".length());
            }
            if (string.endsWith(".tar.gz")) {
                return string.substring(0, string.length() - ".tar.gz".length());
            }
            return string;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getSize() {
            return this.size;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public Product getProduct() {
            return this.product;
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public UpdateVersion getVersion() {
            return this.version;
        }

        public String toString() {
            return "Product=" + String.valueOf((Object)this.product) + ", platform=" + String.valueOf((Object)this.platform) + ", version=" + String.valueOf(this.version) + ", size=" + this.size + ", modified=" + String.valueOf(new Date(this.lastModified));
        }
    }

    public static enum Platform {
        Windows,
        MacOSX,
        Linux,
        LinuxArm,
        Unknown;


        public String getType() {
            return String.valueOf(this.getTypeInt());
        }

        public int getTypeInt() {
            return this.ordinal() + 1;
        }
    }

    public static class UpdateVersion
    implements Comparable<UpdateVersion> {
        public int major;
        public int minor;
        public int maintenance;
        public int build;
        private boolean beta;
        private int betaVersion = 1;

        public UpdateVersion(String string) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length >= 2) {
                this.major = NiceDataFormat.toNumberInt(stringArray[0]);
                this.minor = NiceDataFormat.toNumberInt(stringArray[1]);
                if (stringArray.length >= 3) {
                    this.maintenance = Integer.parseInt(stringArray[2]);
                }
                if (stringArray.length >= 4) {
                    this.beta = stringArray[3].toLowerCase().startsWith("beta");
                    if (this.beta) {
                        String[] stringArray2 = stringArray[3].split("-");
                        if (stringArray2.length == 2) {
                            this.betaVersion = NiceDataFormat.toNumberInt(stringArray2[1]);
                        }
                    } else if (NiceDataFormat.isNumber(stringArray[3])) {
                        this.build = NiceDataFormat.toNumberInt(stringArray[3]);
                    } else if (NiceDataFormat.isNumber(stringArray[3].split(" ")[0])) {
                        this.build = NiceDataFormat.toNumberInt(stringArray[3].split(" ")[0]);
                    }
                }
            }
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.maintenance + this.formatTrail();
        }

        public String format(boolean bl) {
            return this.major + "." + this.minor + "." + this.maintenance + (bl ? "" : this.formatTrail());
        }

        public String formatMajorMinor() {
            return this.major + "." + this.minor;
        }

        private String formatTrail() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.beta) {
                stringBuilder.append(".Beta");
                if (this.betaVersion > 1) {
                    stringBuilder.append("-");
                    stringBuilder.append(this.betaVersion);
                }
            } else if (this.build > 0) {
                stringBuilder.append(".Build-").append(this.build);
            }
            return stringBuilder.toString();
        }

        public boolean newer(UpdateVersion updateVersion) {
            return this.compareTo(updateVersion) > 0;
        }

        @Override
        public int compareTo(UpdateVersion updateVersion) {
            int n = this.compareTo3M(updateVersion);
            if (n != 0) {
                return n;
            }
            if (updateVersion.beta != this.beta) {
                return updateVersion.beta ? -1 : 1;
            }
            if (updateVersion.betaVersion != this.betaVersion) {
                return Integer.compare(updateVersion.betaVersion, this.betaVersion);
            }
            if (updateVersion.build != this.build) {
                return Integer.compare(updateVersion.build, this.build);
            }
            return 0;
        }

        public int compareTo3M(UpdateVersion updateVersion) {
            if (updateVersion.major != this.major) {
                return Integer.compare(updateVersion.major, this.major);
            }
            if (updateVersion.minor != this.minor) {
                return Integer.compare(updateVersion.minor, this.minor);
            }
            if (updateVersion.maintenance != this.maintenance) {
                return Integer.compare(updateVersion.maintenance, this.maintenance);
            }
            return 0;
        }

        public int compareTo4M(UpdateVersion updateVersion) {
            int n = this.compareTo3M(updateVersion);
            if (n != 0) {
                return n;
            }
            if (updateVersion.build != this.build) {
                return Integer.compare(updateVersion.build, this.build);
            }
            return 0;
        }
    }
}

