/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.update;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.LinkLabel;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class UpdatePanel
extends JPanel {
    private UpdateHelper.DownloadFile downloadFile;
    private UpdateCallback callback;
    private ProgressManager pManager;
    private JPanel buttonsPanel;
    private LinkLabel changeLogLabelLink;
    private JButton downloadButton;
    private JTextPane downloadTextArea;
    private JTextArea informationTextArea;
    private JPanel progressPanel;

    public UpdatePanel(UpdateHelper.DownloadFile downloadFile, UpdateCallback updateCallback, Color color) {
        RegInfo.Item item = RegisterKeyManager.getRegInfo().getItem(ExtClassLoader.LicenseLibrary.SUPPORT);
        boolean bl = true;
        if (item != null) {
            bl = new Date(item.expired).compareTo(new Date()) > 0;
        }
        this.downloadFile = downloadFile;
        this.callback = updateCallback;
        this.initComponents(bl);
        this.informationTextArea.setEditable(false);
        UpdateHelper.Product product = downloadFile.getProduct();
        this.informationTextArea.setFont(new Font("Tahoma", 0, product.equals((Object)UpdateHelper.Product.Evince) ? 12 : 16));
        this.informationTextArea.setText("There is an update available for " + String.valueOf((Object)product) + "!\n" + (bl ? "\nWe strongly recommend you to update to this newer version.\n\nClick on the \"Download\" button to start downloading the file." : "\nTo receive this update please contact Prediktera to extend your\nsupport agreement."));
        this.informationTextArea.setForeground(color);
        this.changeLogLabelLink.setLinkLocation(product.getReleaseNotesPage());
        this.changeLogLabelLink.setForeground(color);
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.changeLogLabelLink.setFont(new Font("Tahoma", 0, product.equals((Object)UpdateHelper.Product.Evince) ? 12 : 14).deriveFont(hashMap));
        if (!bl) {
            return;
        }
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.downloadTextArea.setEditorKit(hTMLEditorKit);
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        styleSheet.addRule("body {color:" + PerfectSpread.getColorToString(color) + "; font-family: Arial; margin: 4px; }");
        this.updateDownloadInformation(downloadFile);
        this.progressPanel.setOpaque(false);
        this.progressPanel.setPreferredSize(new Dimension(100, 20));
    }

    private void updateDownloadInformation(UpdateHelper.DownloadFile downloadFile) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table><tr><td>Filename</td><td>");
        stringBuilder.append(downloadFile.getFilename());
        stringBuilder.append("</td></tr><tr><td>Version</td><td>");
        stringBuilder.append(downloadFile.getVersion());
        stringBuilder.append("</td></tr><tr><td>Date</td><td>");
        stringBuilder.append(simpleDateFormat.format(new Date(downloadFile.getLastModified())));
        stringBuilder.append("</td></tr><tr><td>Size</td><td>");
        stringBuilder.append(UpdateHelper.formatSize(downloadFile.getSize()));
        stringBuilder.append("</td></tr></table>");
        this.downloadTextArea.setEditable(false);
        this.downloadTextArea.setContentType("text/html");
        this.downloadTextArea.setText(stringBuilder.toString());
    }

    private void initComponents(boolean bl) {
        this.informationTextArea = new JTextArea();
        this.downloadTextArea = new JTextPane();
        this.progressPanel = new JPanel();
        this.changeLogLabelLink = new LinkLabel();
        this.buttonsPanel = new JPanel();
        this.downloadButton = new JButton();
        JButton jButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.informationTextArea.setColumns(20);
        this.informationTextArea.setFont(new Font("Tahoma", 0, 13));
        this.informationTextArea.setRows(3);
        this.informationTextArea.setText("Update is available");
        this.informationTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 12, 0, 12);
        this.add((Component)this.informationTextArea, gridBagConstraints);
        this.downloadTextArea.setFont(new Font("Tahoma", 0, 13));
        this.downloadTextArea.setText("Download information");
        this.downloadTextArea.setOpaque(false);
        this.downloadTextArea.setVisible(bl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.downloadTextArea, gridBagConstraints);
        this.progressPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.changeLogLabelLink.setText("Show change log in Browser");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.changeLogLabelLink, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.downloadButton.setText("Download");
        this.downloadButton.setPreferredSize(new Dimension(85, 27));
        this.downloadButton.addActionListener(this::downloadButtonActionPerformed);
        this.downloadButton.setVisible(bl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.buttonsPanel.add((Component)this.downloadButton, gridBagConstraints);
        jButton.setText(bl ? "Cancel" : "Ok");
        jButton.setPreferredSize(new Dimension(85, 27));
        jButton.addActionListener(this::cancelButtonActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.buttonsPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        if (this.pManager != null) {
            this.pManager.abort();
        }
        this.callback.cancel();
    }

    public void hideButtons() {
        this.buttonsPanel.setVisible(false);
    }

    private void downloadButtonActionPerformed(ActionEvent actionEvent) {
        this.downloadButton.setEnabled(false);
        this.pManager = this.startDownload();
    }

    public ProgressManager startDownload() {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                File file = UpdateHelper.download(1.getProgressManager(), UpdatePanel.this.downloadFile, UpdateHelper.getDownloadFolder());
                if (this.isAborted()) {
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                } else {
                    UpdatePanel.this.callback.downloadComplete(file);
                }
                return null;
            }

            @Override
            public void Show() {
            }
        };
        progressManagerImpl.setAbortable(true);
        progressManagerImpl.hideAnimationPanel();
        JProgressBar jProgressBar = progressManagerImpl.getContentPane().getProgressBar();
        jProgressBar.setStringPainted(true);
        this.progressPanel.add((Component)jProgressBar, "Center");
        this.revalidate();
        this.repaint();
        progressManagerImpl.invokeLater();
        return progressManagerImpl;
    }

    public static void main(String[] stringArray) throws Exception {
        final UpdateHelper.DownloadFile downloadFile = UpdateHelper.getDownloadFile(UpdateHelper.getPlatform(), UpdateHelper.Product.Evince);
        int n = InitClass.getEvinceVersion().compareTo(downloadFile.getVersion());
        System.out.println(n);
        final JFrame jFrame = new JFrame("Update");
        jFrame.setDefaultCloseOperation(3);
        Evince.setLookAndFeel();
        Evince.setFrameIcons(jFrame);
        jFrame.getContentPane().add((Component)new UpdatePanel(downloadFile, new UpdateCallback(){

            @Override
            public void downloadComplete(File file) {
                int n = JOptionPane.showConfirmDialog(jFrame, UpdateHelper.getRestartText(downloadFile.getProduct()), "Download complete", 2, 3, null);
                if (n == 0) {
                    SwingUtilities.invokeLater(() -> {
                        UpdateHelper.runExe(file);
                        System.exit(0);
                    });
                }
            }

            @Override
            public void cancel() {
                System.exit(0);
            }
        }, Color.black), "Center");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static interface UpdateCallback {
        public void downloadComplete(File var1);

        public void cancel();
    }
}

