/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.main.script.AbstractScriptInfo;

public abstract class AbstractInit
extends CleanUpClass {
    public static final byte ROW_PRIMARY_TYPE = 1;
    public static final byte COLUMN_PRIMARY_TYPE = 2;
    protected DataTreeInterface dataTreeInterface;
    public DataTreeInterface filterRoot;
    public byte interactionFlag = 1;
    public byte propagationFlag = 1;
    public Vector wizard;
    public int layer = 0;
    public AbstractScriptInfo scriptInfo = null;
    public boolean relatedToAll = false;

    public AbstractInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super("AbstractInit");
        this.dataTreeInterface = mapProperty.resolveNodeFromName(randomInputStream, "pidT");
        this.filterRoot = mapProperty.resolveNodeFromName(randomInputStream, "pifR");
        if (mapProperty.hasProperty("layer")) {
            this.layer = mapProperty.getLVInt();
        }
    }

    public AbstractInit(String string, DataTreeInterface dataTreeInterface) {
        super(string);
        this.dataTreeInterface = dataTreeInterface;
        if (dataTreeInterface != null) {
            this.filterRoot = dataTreeInterface.getTreeParent();
        }
    }

    public abstract AbstractInit cloneCurrent();

    public void copyInitTo(AbstractInit abstractInit) {
        abstractInit.dataTreeInterface = this.dataTreeInterface;
        abstractInit.interactionFlag = this.interactionFlag;
        abstractInit.filterRoot = this.filterRoot;
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractInit) {
            AbstractInit abstractInit = (AbstractInit)object;
            if (abstractInit.dataTreeInterface != null) {
                return abstractInit.dataTreeInterface.equals(this.dataTreeInterface);
            }
            return super.equals(object);
        }
        return false;
    }

    public DataTreeInterface getAncestor() {
        return DataTreeManager.getAncestor(this.dataTreeInterface);
    }

    public DataTreeInterface getDataTreeInterface() {
        return this.dataTreeInterface;
    }

    public int getInteractiveTag() {
        return 0;
    }

    public JPanel getWizardAt(int n) {
        if (this.wizard != null && n >= 0 && n < this.getWizardSize()) {
            return (JPanel)this.wizard.elementAt(n);
        }
        return null;
    }

    public JPanel getWizardByClass(Class clazz) {
        int n = this.getWizardSize();
        for (int i = 0; i < n; ++i) {
            JPanel jPanel = this.getWizardAt(i);
            if (jPanel.getClass() != clazz) continue;
            return jPanel;
        }
        return null;
    }

    public int getWizardSize() {
        if (this.wizard != null) {
            return this.wizard.size();
        }
        return 0;
    }

    public boolean isRelatedTo(AbstractInit abstractInit) {
        if (abstractInit == null || this.dataTreeInterface == null || this.relatedToAll || abstractInit.relatedToAll) {
            return true;
        }
        if (this.dataTreeInterface instanceof DataTreeClass) {
            return ((DataTreeClass)this.dataTreeInterface).isRelatedTo(abstractInit.dataTreeInterface);
        }
        return false;
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyNode("pidT", this.dataTreeInterface);
        randomOutputStream.writePropertyNode("pifR", this.filterRoot);
        randomOutputStream.writePropertyInt("layer", this.layer);
    }

    public void setDataTreeInterface(DataTreeInterface dataTreeInterface) {
        this.dataTreeInterface = dataTreeInterface;
        if (dataTreeInterface != null) {
            this.filterRoot = dataTreeInterface.getTreeParent();
        }
    }

    @Override
    protected void cleanUpChild() {
        this.dataTreeInterface = null;
        this.filterRoot = null;
        if (this.wizard != null) {
            for (int i = 0; i < this.wizard.size(); ++i) {
                if (!(this.wizard.elementAt(i) instanceof CleanUpPanel)) continue;
                ((CleanUpPanel)this.wizard.elementAt(i)).cleanUp();
            }
            this.wizard.removeAllElements();
            this.wizard = null;
        }
        this.scriptInfo = null;
    }
}

