/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.help.CSH;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.common.wizard.WizardInterface;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Project_GUI;

public abstract class AbstractWizard
extends CleanUpPanel {
    protected WizardInterface wizardWindow;
    protected WizardInfoInterface curWizard;
    protected WizardPageClass currentPage;
    private CustomCardLayout customCardLayout = new CustomCardLayout();
    private final JPanel cardPanel = new JPanel(this.customCardLayout);
    protected Image banner = null;

    public AbstractWizard() {
        this("AbstractWizard");
    }

    public AbstractWizard(String string) {
        super(string);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cardPanel, "Center");
        CSH.setHelpIDString((Component)this, (String)this.getHelpID());
    }

    public void addExtern(List<AbstractWizardInfo> list, DataTreeInterface dataTreeInterface) {
    }

    public void addNextListener(JTextField jTextField) {
        if (this.wizardWindow != null) {
            this.wizardWindow.addNextListener(jTextField);
        }
    }

    public void arrowKeyPressed(boolean bl) {
        if (this.currentPage != null) {
            this.currentPage.arrowKeyPressed(bl);
        }
    }

    public boolean backPressed() {
        return this.currentPage == null || this.currentPage.backPressed();
    }

    public void beginWizard() {
    }

    public boolean cancelPressed() {
        return this.currentPage == null || this.currentPage.cancelPressed();
    }

    public boolean canFinish() {
        return this.currentPage == null || this.currentPage.canNext();
    }

    public WizardInfoInterface createWizardInfo() {
        return this.curWizard;
    }

    public void doFinished() {
        if (this.wizardWindow != null) {
            this.wizardWindow.doFinished();
        }
    }

    public abstract int executeWizard();

    public boolean finished() {
        return this.canFinish();
    }

    public boolean finishedPressed() {
        return this.currentPage == null || this.currentPage.finishedPressed();
    }

    public Image getBanner() {
        if (this.banner == null) {
            this.banner = new ImageIcon(this.getClass().getResource("images/banner.gif")).getImage();
        }
        return this.banner;
    }

    public int getCurPage() {
        return this.customCardLayout.getCurPage();
    }

    public WizardPageClass getCurrentPage() {
        return this.currentPage;
    }

    public abstract String getDescription();

    public abstract ImageIcon getIcon();

    protected void addPage(Component component, String string) {
        this.cardPanel.add(component, string);
    }

    public Component getPageAt(int n) {
        return this.cardPanel.getComponent(n);
    }

    public WizardPageClass getWizardPageAt(int n) {
        return (WizardPageClass)this.getPageAt(n);
    }

    public int getPageCount() {
        return this.cardPanel.getComponentCount();
    }

    public void removePagesKeepOne() {
        this.removePagesKeep(1);
    }

    public void removePagesKeep(int n) {
        while (this.getPageCount() > n) {
            this.cardPanel.remove(n);
        }
    }

    public int getPaintType() {
        return -1;
    }

    public Project_GUI getProjectGUI() {
        return null;
    }

    public int getSelectWizardPageNr() {
        return 0;
    }

    public WizardDialog getWizardDialog() {
        if (this.wizardWindow instanceof WizardDialog) {
            return (WizardDialog)this.wizardWindow;
        }
        return null;
    }

    public WizardInterface getWizardWindow() {
        return this.wizardWindow;
    }

    public void handleDoubleClick(boolean bl) {
        if (!(this.wizardWindow == null || bl && this.wizardWindow.doFinished())) {
            this.wizardWindow.doNext();
        }
    }

    public boolean handleFocus() {
        return this.currentPage == null || this.currentPage.handleFocus();
    }

    public void handlePreviousClick() {
        if (this.wizardWindow != null) {
            this.wizardWindow.doPrevious();
        }
    }

    public boolean isFirstPage() {
        return this.customCardLayout.isFirst();
    }

    public boolean isLastPage() {
        return this.customCardLayout.isLast();
    }

    public boolean isMultipleSelection() {
        return false;
    }

    public boolean nextPage() {
        return this.customCardLayout.nextPage();
    }

    public boolean nextPressed() {
        return this.currentPage == null || this.currentPage.nextPressed();
    }

    public void pageChanged(int n) {
        this.currentPage = null;
        if (0 <= n && n < this.getPageCount() && this.getPageAt(n) instanceof WizardPageClass) {
            this.currentPage = this.getWizardPageAt(n);
            if (this.currentPage.getWizard() == null) {
                this.currentPage.setWizard(this);
            }
        }
        this.pageChangedLocal(this.currentPage, n);
        if (this.currentPage != null) {
            this.currentPage.pageShown();
        }
        if (n == 0 && this.wizardWindow != null) {
            this.wizardWindow.updateButtons();
        }
        this.updateTitle();
    }

    public boolean prevPage() {
        return this.customCardLayout.prevPage();
    }

    public void setPage(int n) {
        int n2 = this.getCurPage();
        if (n2 < n) {
            for (int i = n2; i < n && this.nextPressed(); ++i) {
                this.nextPage();
            }
        } else {
            for (int i = n2; i > n; --i) {
                this.prevPage();
            }
        }
        if (this.wizardWindow != null) {
            this.wizardWindow.updateButtons();
        }
    }

    public boolean showStepsOnFirstPage() {
        return true;
    }

    public void updateButtons() {
        if (this.wizardWindow != null) {
            this.wizardWindow.updateButtons();
        }
    }

    public void updateButtons(boolean bl) {
        if (this.wizardWindow != null) {
            this.wizardWindow.updateButtons(bl);
        }
    }

    public void updateTitle() {
        if (this.wizardWindow != null) {
            this.wizardWindow.updateTitle();
        }
    }

    protected boolean canBack() {
        return this.currentPage == null || this.currentPage.canBack();
    }

    protected boolean canNext() {
        return (this.currentPage == null || this.currentPage.canNext()) && !this.isLastPage();
    }

    @Override
    protected void cleanUpChild() {
        if (this.wizardWindow != null) {
            this.wizardWindow.cleanUp();
        }
    }

    protected String getHelpID() {
        return "Default";
    }

    protected abstract void pageChangedLocal(WizardPageClass var1, int var2);

    class CustomCardLayout
    extends CardLayout {
        private int curindex = 0;

        CustomCardLayout() {
        }

        public int getCurPage() {
            return this.curindex;
        }

        public boolean isFirst() {
            return this.curindex == 0;
        }

        public boolean isLast() {
            return this.curindex == AbstractWizard.this.getPageCount() - 1;
        }

        public boolean nextPage() {
            this.next(AbstractWizard.this.cardPanel);
            AbstractWizard.this.pageChanged(++this.curindex);
            return !this.isLast();
        }

        public boolean prevPage() {
            this.previous(AbstractWizard.this.cardPanel);
            AbstractWizard.this.pageChanged(--this.curindex);
            return !this.isFirst();
        }
    }
}

