/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.wizard.AbstractBannerPanel;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Main_GUI;

public abstract class AbstractWizardPanel
extends CleanUpPanel {
    public static final int MODAL_ABORT = 0;
    public static final int MODAL_OK = 1;
    private final WizardButton next = new WizardButton("Next >");
    private final WizardButton previous = new WizardButton("< Back");
    private final WizardButton finish = new WizardButton("Finish");
    private final WizardButton cancel = new WizardButton("Cancel");
    private AbstractBannerPanel bannerPanel = null;
    private AbstractWizard cardPanel;
    protected int modalResult = 0;
    private final boolean finishbutton;
    private final boolean shownexttime;
    private final JCheckBox checkbox = new JCheckBox("Show this next time Evince starts");
    private final String title;
    private final NextListener nextListener = new NextListener();

    public AbstractWizardPanel(String string, AbstractWizard abstractWizard, AbstractBannerPanel abstractBannerPanel, boolean bl, boolean bl2, boolean bl3) {
        super(new BorderLayout());
        CSH.setHelpIDString((Component)this, (String)abstractWizard.getHelpID());
        this.title = string;
        this.cardPanel = abstractWizard;
        this.bannerPanel = abstractBannerPanel;
        this.finishbutton = bl;
        this.shownexttime = bl3;
        this.jbInit(bl2);
        this.next.requestFocusInWindow();
    }

    public void addNextListener(JTextField jTextField) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener : keyListenerArray = jTextField.getKeyListeners()) {
            if (!keyListener.equals(this.nextListener)) continue;
            return;
        }
        jTextField.addKeyListener(this.nextListener);
    }

    public void arrowKeyPressed(boolean bl) {
        this.cardPanel.arrowKeyPressed(bl);
    }

    public boolean doFinished() {
        if (this.finish.isEnabled()) {
            this.finishAction();
            return true;
        }
        return false;
    }

    public boolean doNext() {
        if (this.next.isEnabled()) {
            this.nextAction();
            return true;
        }
        return false;
    }

    public boolean doPrevious() {
        if (this.previous.isEnabled()) {
            return this.cardPanel.prevPage();
        }
        return false;
    }

    public int executeWizard() {
        return this.executeWizard(0, true);
    }

    public int executeWizard(int n, boolean bl) {
        if (this.cardPanel.getPageCount() > 0) {
            if (n >= 0) {
                this.cardPanel.pageChanged(0);
            }
            n = Math.abs(n);
            this.cardPanel.beginWizard();
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                bl2 = this.doNext();
            }
            if (bl) {
                this.wizardShow();
                return this.modalResult;
            }
            if (bl2) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setShowNextTime(boolean bl) {
        this.checkbox.setSelected(bl);
    }

    public abstract void setTitle(String var1);

    public boolean showNextTime() {
        return this.checkbox.isSelected();
    }

    public int showWizard() {
        this.wizardShow();
        return this.modalResult;
    }

    public void updateButtons() {
        this.updateButtons(true);
    }

    public void updateButtons(boolean bl) {
        this.previous.setEnabled(!this.cardPanel.isFirstPage());
        this.finish.setEnabled(this.cardPanel.canFinish());
        this.next.setEnabled(this.cardPanel.canNext());
        if (bl) {
            if (this.cardPanel.isLastPage()) {
                if (this.cardPanel.canFinish()) {
                    this.finish.requestFocus();
                } else {
                    this.previous.requestFocus();
                }
            } else {
                this.next.requestFocus();
            }
        }
    }

    public void updateTitle() {
        if (this.cardPanel == null) {
            this.setTitle(this.title);
        } else {
            StringBuilder stringBuilder = new StringBuilder(40);
            stringBuilder.append(this.title);
            boolean bl = this.cardPanel.showStepsOnFirstPage();
            if (this.cardPanel.getCurPage() > 0 || bl) {
                int n = this.cardPanel.getCurPage() + 1;
                int n2 = this.cardPanel.getPageCount();
                if (!bl) {
                    --n;
                    --n2;
                }
                stringBuilder.append(" - Step ").append(n);
                stringBuilder.append(" of ").append(n2);
                if (this.cardPanel.isMultipleSelection()) {
                    stringBuilder.append(" ( Multiple choices )");
                } else {
                    WizardInfoInterface wizardInfoInterface = this.cardPanel.createWizardInfo();
                    if (wizardInfoInterface != null) {
                        stringBuilder.append(" ( ").append(wizardInfoInterface).append(" )");
                    }
                }
            }
            WizardPageClass wizardPageClass = this.cardPanel.getCurrentPage();
            if (this.bannerPanel != null && wizardPageClass != null) {
                this.bannerPanel.setInfoText(this.cardPanel.getCurPage() + 1 + ". " + String.valueOf(wizardPageClass));
            }
            this.setTitle(stringBuilder.toString());
        }
    }

    public abstract void wizardFinished();

    public abstract void wizardShow();

    @Override
    protected void cleanUpChild() {
        if (this.cardPanel != null) {
            this.cardPanel.cleanUp();
            this.cardPanel = null;
        }
    }

    protected void nextAction() {
        if (this.cardPanel.nextPressed()) {
            if (this.cardPanel.isLastPage()) {
                this.modalResult = this.cardPanel.finished() ? 1 : 0;
                this.wizardFinished();
            } else {
                this.cardPanel.nextPage();
                this.updateButtons(!this.cardPanel.handleFocus());
            }
        }
    }

    protected void showCancelButton(boolean bl) {
        this.cancel.setVisible(bl);
    }

    private void finishAction() {
        if (this.cardPanel.finishedPressed()) {
            this.modalResult = this.cardPanel.finished() ? 1 : 0;
            this.wizardFinished();
        }
    }

    private void jbInit(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        jPanel2.setLayout(boxLayout);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        int n = 45;
        if (Evince.touchscreen) {
            n *= 2;
        }
        jPanel.setPreferredSize(new Dimension(10, n));
        this.checkbox.setSelected(true);
        this.next.setName("next");
        this.next.setMnemonic('N');
        this.next.setMargin(new Insets(2, 2, 2, 2));
        this.next.addActionListener(actionEvent -> this.nextAction());
        this.next.setEnabled(!this.cardPanel.isLastPage());
        this.previous.setName("previous");
        this.previous.setEnabled(false);
        this.previous.setMnemonic('B');
        this.previous.setMargin(new Insets(2, 2, 2, 2));
        this.previous.addActionListener(actionEvent -> {
            if (this.cardPanel.backPressed()) {
                this.cardPanel.prevPage();
                this.updateButtons();
            }
        });
        this.cancel.setName("cancel");
        this.cancel.setMnemonic('C');
        this.cancel.setMargin(new Insets(2, 2, 2, 2));
        this.cancel.addActionListener(actionEvent -> {
            if (this.cardPanel.cancelPressed()) {
                this.modalResult = 0;
                this.wizardFinished();
            }
        });
        this.finish.setName("finish");
        this.finish.setEnabled(this.cardPanel.canFinish());
        this.finish.setMnemonic('F');
        this.finish.setMargin(new Insets(2, 2, 2, 2));
        this.finish.addActionListener(actionEvent -> this.finishAction());
        this.add((Component)jPanel, "South");
        jPanel.setBorder(new EmptyBorder(4, 12, 4, 12));
        jPanel.add((Component)new JSeparator(), "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this.cardPanel, "Center");
        if (this.shownexttime) {
            jPanel.add((Component)this.checkbox, "West");
        }
        if (bl) {
            JButton jButton = new JButton();
            jButton.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/help.png")));
            jButton.setPreferredSize(new Dimension(27, 27));
            jButton.setMnemonic('?');
            jButton.setMargin(new Insets(2, 2, 2, 2));
            jButton.addActionListener(actionEvent -> Main_GUI.showHelp(actionEvent));
            jPanel2.add(jButton);
        }
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.previous);
        jPanel2.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel2.add(this.next);
        if (this.finishbutton) {
            jPanel2.add(Box.createRigidArea(new Dimension(4, 0)));
            jPanel2.add(this.finish);
        }
        jPanel2.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel2.add(this.cancel);
        jPanel2.setBorder(new EmptyBorder(4, 2, 0, 2));
        this.add((Component)jPanel3, "Center");
        if (this.bannerPanel != null) {
            this.add((Component)this.bannerPanel, "North");
        }
    }

    class WizardButton
    extends JButton {
        public WizardButton(String string) {
            super(string);
            this.setName(string);
            int n = 75;
            int n2 = 27;
            if (Evince.touchscreen) {
                n = (int)((double)n * 1.2);
                n2 *= 2;
            }
            this.setPreferredSize(new Dimension(n, n2));
            this.setMaximumSize(new Dimension(n, n2));
            this.setMinimumSize(new Dimension(n, n2));
        }
    }

    class NextListener
    extends KeyAdapter {
        NextListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                AbstractWizardPanel.this.finishAction();
            }
        }
    }
}

