/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.FilePreview;
import se.prediktera.map.common.wizard.MergeException;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.database.DatabaseImportInfo;
import se.prediktera.map.dataimport.database.DatabaseSelectionPanel;
import se.prediktera.map.dataimport.multi.MultiImageImportPanel;
import se.prediktera.map.dataimport.multi.MultiImportInfo;
import se.prediktera.map.dataimport.raw.RawImportInfo;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class FileChooserPage
extends WizardPageClass {
    private static final byte EVEN = 1;
    private static final byte RANDOM = 2;
    private jopensaveDialog chooser;
    private MultiImageImportPanel multi;
    private DatabaseSelectionPanel dbChooser;
    private AbstractImportInfo importInfo = null;
    private final JTabbedPane tabs = new JTabbedPane();

    public FileChooserPage(AbstractWizard abstractWizard, boolean bl) {
        super((LayoutManager)new BorderLayout(), abstractWizard);
        this.setName("FileChooserPage");
        this.dbChooser = new DatabaseSelectionPanel(abstractWizard);
        this.multi = new MultiImageImportPanel(abstractWizard);
        this.chooser = ImportHelper.createFileDialog("Select Datafile(s) to import into Case", abstractWizard);
        this.add((Component)this.tabs, "Center");
        this.tabs.addTab("Import file(s)", this.chooser);
        if (bl) {
            this.tabs.addTab("Merge different files", this.multi);
        }
        this.tabs.addTab("Import from database", this.dbChooser);
        this.tabs.addChangeListener(changeEvent -> {
            if (this.wizard != null) {
                this.wizard.updateButtons(false);
            }
        });
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", propertyChangeEvent -> this.wizard.updateButtons(false));
        this.chooser.setFileSelectionMode(2);
        this.chooser.setPreview(new FilePreview(), true);
        JPopupMenu jPopupMenu = this.chooser.getPopupMenu();
        if (jPopupMenu != null) {
            JMenu jMenu = new JMenu("Select");
            JMenuItem jMenuItem = new JMenuItem("Evenly spread");
            jMenuItem.addActionListener(actionEvent -> this.selectFilesFromMenu((byte)1));
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Randomly");
            jMenuItem2.addActionListener(actionEvent -> this.selectFilesFromMenu((byte)2));
            jMenu.add(jMenuItem2);
            jPopupMenu.insert(jMenu, 0);
            JMenuItem jMenuItem3 = new JMenuItem("Merge selected files");
            jMenuItem3.addActionListener(actionEvent -> this.addSelectionToMultiImport());
            jPopupMenu.insert(jMenuItem3, 0);
            jPopupMenu.insert(new JPopupMenu.Separator(), 2);
        }
        this.wizard.updateButtons(false);
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean canNext() {
        if (this.tabs.getSelectedComponent() == this.dbChooser) {
            return this.dbChooser.canNext();
        }
        if (this.tabs.getSelectedComponent() == this.multi) {
            return this.multi.canNext();
        }
        return this.chooser.getSelectedFile() != null;
    }

    public AbstractImportInfo getImportInfo() {
        return this.importInfo;
    }

    @Override
    public boolean nextPressed() {
        try {
            if (this.tabs.getSelectedComponent() == this.dbChooser) {
                return this.nextPressedDatabase();
            }
            if (this.tabs.getSelectedComponent() == this.multi) {
                return this.nextPressedMulti();
            }
            return this.nextPressedFile();
        }
        catch (MergeException mergeException) {
            int n = JOptionPane.showConfirmDialog(this, "Merge selected files?", "Merge files", 0, 3);
            if (n == 0) {
                this.addSelectionToMultiImport();
            }
            return false;
        }
        catch (Exception exception) {
            JOptionPane.showConfirmDialog(this, exception.getMessage(), "Import error", -1, 0);
            ErrorHandler.logAndReportException(exception);
            return false;
        }
    }

    public void setSelectedFile(File file) {
        this.chooser.setCurrentDirectory(file.getParentFile());
        this.chooser.setSelectedFiles(new File[]{file});
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.chooser = null;
        this.importInfo = null;
        if (this.multi != null) {
            this.multi.cleanUp();
            this.multi = null;
        }
        if (this.dbChooser != null) {
            this.dbChooser.cleanUp();
            this.dbChooser = null;
        }
    }

    private void addSelectionToMultiImport() {
        File[] fileArray = this.chooser.getSelectedFiles();
        if (fileArray.length > 0) {
            this.setAndAddMultiFiles(fileArray);
        }
    }

    public void setAndAddMultiFiles(File[] fileArray) {
        this.tabs.setSelectedIndex(1);
        this.multi.addFilesFromChooser(this.wizard, fileArray);
    }

    private boolean nextPressedDatabase() throws Exception {
        Connection connection = this.dbChooser.getDatabaseConnection();
        if (connection == null) {
            return false;
        }
        this.importInfo = new DatabaseImportInfo(connection, this.dbChooser.getDatabaseConnectionString(), this.dbChooser.getDatabaseUser());
        ((ImportWizard)this.wizard).setImportPanel(this.importInfo, null);
        return true;
    }

    private boolean nextPressedFile() throws Exception {
        File[] fileArray = this.chooser.getSelectedFiles();
        ExtensionFilter extensionFilter = this.chooser.getMatchingFilter();
        this.importInfo = extensionFilter == null ? new RawImportInfo() : (AbstractImportInfo)extensionFilter.object;
        IniManager.setWorkDir((byte)1, this.chooser.getCurrentDirectory());
        IniManager.setWorkDir((byte)0, this.chooser.getCurrentDirectory());
        ((ImportWizard)this.wizard).setImportPanel(this.importInfo, fileArray);
        return true;
    }

    private boolean nextPressedMulti() throws Exception {
        CellIdentifierModel cellIdentifierModel = this.multi.createMultiModel();
        this.importInfo = new MultiImportInfo(cellIdentifierModel);
        ((ImportWizard)this.wizard).setMultiImportPanel(this.importInfo, cellIdentifierModel);
        return true;
    }

    private void selectFilesFromMenu(byte by) {
        String string = JOptionPane.showInputDialog(this, (Object)"Enter number of files to select");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                File file = this.chooser.getCurrentDirectory();
                File[] fileArray = file.listFiles();
                n = Math.min(n, fileArray.length);
                ArrayList<File> arrayList = new ArrayList<File>(n);
                if (by == 1) {
                    double d = (double)fileArray.length / (double)n;
                    for (var9_11 = 0; var9_11 < n; ++var9_11) {
                        var10_12 = (int)((double)var9_11 * d);
                        if (var10_12 >= fileArray.length) continue;
                        arrayList.add(fileArray[var10_12]);
                    }
                } else {
                    ArrayList arrayList2 = new ArrayList(fileArray.length);
                    Collections.addAll(arrayList2, fileArray);
                    Random random = new Random();
                    for (var9_11 = 0; var9_11 < n; ++var9_11) {
                        var10_12 = random.nextInt(arrayList2.size());
                        arrayList.add((File)arrayList2.remove(var10_12));
                    }
                }
                File[] fileArray2 = new File[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    fileArray2[i] = (File)arrayList.get(i);
                }
                this.chooser.setSelectedFiles(fileArray2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showConfirmDialog(this, "Not a valid number", "Invalid input", -1, 2);
            }
        }
    }
}

