/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.opensave.PreviewInterface;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.main.script.LoadHelper;

public class FilePreview
extends CleanUpPanel
implements PreviewInterface {
    private final JEditorPane textAreaNotes = new JEditorPane();
    private final ExamplePanel previewPanel = new ExamplePanel();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Image image = null;
    private Thread thread;

    public FilePreview() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.textAreaNotes.setFont(new Font("Dialog", 0, 11));
        this.textAreaNotes.setOpaque(false);
        this.textAreaNotes.setEditable(false);
        this.textAreaNotes.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(EvinceBorderFactory.createEvinceBorder("Description"));
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setPreferredSize(new Dimension(200, 250));
        jScrollPane.setMinimumSize(new Dimension(200, 250));
        jScrollPane.getViewport().add((Component)this.textAreaNotes, null);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.previewPanel);
        jSplitPane.setBottomComponent(jScrollPane);
        this.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void configure(File file) {
        this.image = null;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (file != null) {
            String string = jopensaveDialog.getFileName(file);
            this.textAreaNotes.setText(this.formatDescription("<html><body><b>" + this.formatDescription(string) + "</b><br>"));
            String string2 = file.isFile() ? jopensaveDialog.getFileExtension(file).toLowerCase() : null;
            AbstractImportInfo abstractImportInfo = LoadHelper.getImportInfo(this.formatDescription(string2), file);
            this.thread = new Thread(() -> {
                String string2 = abstractImportInfo.getPreviewDescription(file);
                Object object = "";
                object = this.formatDescription(string2) != null ? (String)object + this.formatDescription(string2) : "<html><body><b>" + this.formatDescription(string) + "</b><br>";
                object = (String)object + "<br><font size=\"3\">";
                object = (String)object + "<b>Modified:</b> " + this.sdf.format(new Date(file.lastModified())) + "<br>";
                File file2 = abstractImportInfo.getPreviewDataFile(file);
                if (file2 != null && file2.isFile()) {
                    object = (String)object + "<b>Size:</b> " + UpdateHelper.formatSize(file2.length()) + "<br>";
                }
                object = (String)object + "</font></body></html>";
                this.textAreaNotes.setText(this.formatDescription((String)object));
                this.textAreaNotes.setCaretPosition(0);
                this.image = this.loadImage(abstractImportInfo.getPreviewFile(file));
                this.previewPanel.repaint();
            });
            this.thread.start();
        } else {
            this.textAreaNotes.setText("");
        }
        this.previewPanel.repaint();
    }

    private String formatDescription(String string) {
        if (string != null && string.length() > 10000) {
            return string.substring(0, 10000) + "...";
        }
        return string;
    }

    @Override
    protected void cleanUpChild() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage loadImage(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            ImageResource.makeTransparent(bufferedImage, Color.white, null);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    ErrorHandler.logAndReportException(iOException);
                }
            }
        }
        return null;
    }

    private class ExamplePanel
    extends JPanel {
        public ExamplePanel() {
            this.setBorder(EvinceBorderFactory.createEvinceBorder("Preview"));
            this.setPreferredSize(new Dimension(200, 200));
            this.setMinimumSize(new Dimension(200, 200));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            double d = this.getWidth();
            double d2 = this.getHeight();
            if (FilePreview.this.image == null) {
                graphics.setColor(Color.darkGray);
                String string = FilePreview.this.thread != null ? "Loading image" : "Not available";
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString(string, (int)(d / 2.0 - (double)(fontMetrics.stringWidth(string) / 2)), (int)(d2 / 2.0 + (double)(fontMetrics.getHeight() / 2)));
            } else {
                int n = FilePreview.this.image.getHeight(null);
                int n2 = FilePreview.this.image.getWidth(null);
                double d3 = d / (double)n2;
                double d4 = d2 / (double)n;
                double d5 = Math.min(d3, d4) * 0.8;
                graphics.drawImage(FilePreview.this.image, (int)(d * 0.1), (int)(d2 * 0.1), (int)((double)n2 * d5), (int)((double)n * d5), null);
            }
        }
    }
}

