/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.ViewportWithBackground;
import se.prediktera.map.common.swing.tree.WideMouseListener;
import se.prediktera.map.common.swing.tree.WideNodeRenderer;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.components.tree.AbstractComponentNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptManager;

public class SelectWizardPage
extends WizardPageClass {
    private static final Font typeFont = (Font)UIManager.get("List.font");
    private final JTree wizardTree = new JTree();
    private DefaultTreeModel treeModel = null;
    private ExamplePanel examplePanel = null;
    private final Vector<AbstractWizardInfo> wizardVector = new Vector();
    private final ArrayList<AbstractWizardInfo> curWizardList = new ArrayList();
    private final JScrollPane textScrollPane = new JScrollPane();
    private final JTextPane textInfo = new JTextPane();
    private DataTreeInterface currentData = null;
    private final JScrollPane wizardTreeScrollPane = new JScrollPane();

    private static DefaultMutableTreeNode getChildByName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode2.toString().equals(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public SelectWizardPage(AbstractWizard abstractWizard, DataTreeInterface dataTreeInterface, boolean bl) {
        super((LayoutManager)new BorderLayout(), abstractWizard);
        if (bl) {
            this.examplePanel = new ExamplePanel();
        }
        try {
            this.jbInit();
            this.newData(dataTreeInterface);
            this.wizardTree.setOpaque(false);
            this.wizardTree.setFont(typeFont);
            this.wizardTree.setFocusable(false);
            this.wizardTree.setCellRenderer(new WideNodeRenderer());
            this.wizardTree.setShowsRootHandles(false);
            this.wizardTree.setRootVisible(false);
            this.wizardTree.getSelectionModel().setSelectionMode(1);
            this.wizardTree.addMouseListener(new WideMouseListener());
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public void allowMultiSelection(boolean bl) {
        if (bl) {
            this.wizardTree.getSelectionModel().setSelectionMode(4);
        } else {
            this.wizardTree.getSelectionModel().setSelectionMode(1);
        }
    }

    @Override
    public void arrowKeyPressed(boolean bl) {
        TreePath treePath = this.wizardTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            defaultMutableTreeNode = bl ? defaultMutableTreeNode.getPreviousLeaf() : defaultMutableTreeNode.getNextLeaf();
            if (defaultMutableTreeNode != null) {
                this.wizardTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    public ArrayList<AbstractWizardInfo> getAllWizardInfo() {
        return this.curWizardList;
    }

    public ArrayList getSelectedWizards() {
        TreePath[] treePathArray = this.wizardTree.getSelectionPaths();
        ArrayList<AbstractWizardInfo> arrayList = new ArrayList<AbstractWizardInfo>();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                this.addWizardRecursive((DefaultMutableTreeNode)treePath.getLastPathComponent(), arrayList);
            }
        }
        return arrayList;
    }

    public AbstractWizardInfo getWizardInfo() {
        if (this.curWizardList.size() > 0) {
            return this.curWizardList.get(0);
        }
        return null;
    }

    public final boolean newData(DataTreeInterface dataTreeInterface) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (dataTreeInterface != null && this.currentData == dataTreeInterface) {
            return this.getWizardInfo() != null;
        }
        this.currentData = dataTreeInterface;
        this.wizardVector.clear();
        this.wizard.addExtern(this.wizardVector, dataTreeInterface);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(defaultMutableTreeNode2);
        this.wizardTree.setModel(this.treeModel);
        String string = ScriptManager.getLastScriptName(this.wizard.getProjectGUI(), dataTreeInterface, this.wizard.getDescription());
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        ImageIcon imageIcon = AbstractPaint.createIcon(this.wizard.getPaintType());
        for (AbstractWizardInfo abstractWizardInfo : this.wizardVector) {
            String string2;
            defaultMutableTreeNode = new AbstractComponentNode((Object)abstractWizardInfo, this.wizard.getPaintType());
            ((AbstractComponentNode)defaultMutableTreeNode).setIcon(imageIcon);
            String string3 = EvinceScriptCommands.removeSpace(abstractWizardInfo.toString());
            if (defaultMutableTreeNode3 == null || string3.equals(string)) {
                defaultMutableTreeNode3 = defaultMutableTreeNode;
            }
            if ((string2 = abstractWizardInfo.getPath()) == null) {
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                continue;
            }
            DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                DefaultMutableTreeNode defaultMutableTreeNode5 = SelectWizardPage.getChildByName(defaultMutableTreeNode4, string4);
                if (defaultMutableTreeNode5 == null) {
                    defaultMutableTreeNode5 = new AbstractComponentNode((Object)string4, this.wizard.getPaintType());
                    defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                }
                defaultMutableTreeNode4 = defaultMutableTreeNode5;
            }
            defaultMutableTreeNode4.add(defaultMutableTreeNode);
        }
        boolean bl = false;
        if (defaultMutableTreeNode3 != null) {
            for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                this.wizardTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
            this.wizardTree.setSelectionPath(new TreePath(defaultMutableTreeNode3.getPath()));
            bl = true;
        }
        this.wizardTreeScrollPane.getHorizontalScrollBar().setValue(0);
        return bl;
    }

    public void setCurWizard(Object[] objectArray) {
        this.curWizardList.clear();
        for (Object object : objectArray) {
            this.curWizardList.add((AbstractWizardInfo)object);
        }
        if (this.examplePanel != null) {
            this.examplePanel.repaint();
        }
        if (objectArray.length == 1) {
            this.setSelectedNode((DefaultMutableTreeNode)this.treeModel.getRoot(), objectArray[0]);
        }
        if (this.curWizardList.size() == 1) {
            this.textInfo.setText(this.curWizardList.get(0).getWizardInfo());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Multiple choices: (");
            stringBuilder.append(this.curWizardList.size());
            stringBuilder.append(" selected)\n");
            for (AbstractWizardInfo abstractWizardInfo : this.curWizardList) {
                stringBuilder.append("\n");
                stringBuilder.append(abstractWizardInfo.toString());
            }
            this.textInfo.setText(stringBuilder.toString());
        }
        this.textInfo.setCaretPosition(0);
        this.wizard.pageChanged(this.wizard.getSelectWizardPageNr());
        this.textScrollPane.getVerticalScrollBar().setValue(0);
    }

    public AbstractWizardInfo setCurWizardFromName(AbstractWizardInfo abstractWizardInfo) {
        return this.setCurWizardFromName(abstractWizardInfo.toString());
    }

    public AbstractWizardInfo setCurWizardFromName(String string) {
        for (int i = 0; i < this.wizardVector.size(); ++i) {
            AbstractWizardInfo abstractWizardInfo = this.wizardVector.elementAt(i);
            if (!abstractWizardInfo.toString().equals(string)) continue;
            this.setCurWizard(new Object[]{abstractWizardInfo});
            return abstractWizardInfo;
        }
        return null;
    }

    protected String getPageHeading() {
        return "Select " + this.wizard.getDescription() + " Type:";
    }

    private void addWizardRecursive(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<AbstractWizardInfo> arrayList) {
        Object object;
        if (defaultMutableTreeNode instanceof AbstractComponentNode && (object = defaultMutableTreeNode.getUserObject()) instanceof AbstractWizardInfo && !arrayList.contains(object)) {
            arrayList.add((AbstractWizardInfo)object);
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.addWizardRecursive((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), arrayList);
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Dimension dimension = new Dimension(200, 300);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension.width, dimension.height, new Color(200, 200, 200, 200));
        this.wizardTreeScrollPane.setViewport(new ViewportWithBackground(gradientPaint, dimension));
        this.wizardTreeScrollPane.setMaximumSize(this.wizardTreeScrollPane.getPreferredSize());
        this.wizardTreeScrollPane.setMinimumSize(this.wizardTreeScrollPane.getPreferredSize());
        this.wizardTree.addTreeSelectionListener(treeSelectionEvent -> this.setCurWizard(this.getSelectedWizards().toArray()));
        this.wizardTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                AbstractComponentNode abstractComponentNode;
                if (mouseEvent.getClickCount() > 1 && (abstractComponentNode = (AbstractComponentNode)(treePath = SelectWizardPage.this.wizardTree.getSelectionPath()).getLastPathComponent()) != null && abstractComponentNode.getUserObject() instanceof AbstractWizardInfo) {
                    SelectWizardPage.this.wizard.handleDoubleClick(true);
                }
            }
        });
        JLabel jLabel = new JLabel(this.getPageHeading());
        jLabel.setFont(typeFont);
        this.textScrollPane.setHorizontalScrollBarPolicy(31);
        this.textScrollPane.setVerticalScrollBarPolicy(20);
        this.textInfo.setEditable(false);
        this.textInfo.setText("No " + this.wizard.getDescription() + " available!");
        this.textInfo.setBackground(this.getBackground());
        this.textScrollPane.setPreferredSize(new Dimension(260, 90));
        jLabel.setFont(new Font("Dialog", 1, 12));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.wizardTreeScrollPane.getInsets();
        jPanel.add((Component)this.wizardTreeScrollPane, new GridBagConstraints(0, 1, 1, 4, 0.0, 1.0, 10, 1, new Insets(6, 12, 11, 0), 0, 0));
        this.textScrollPane.setBorder(EvinceBorderFactory.createEvinceBorder("Description"));
        Insets insets = this.textScrollPane.getBorder().getBorderInsets(jPanel);
        jPanel.add((Component)this.textScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6 - insets.bottom - 1, 12, 0, 12), 0, 0));
        this.textScrollPane.setOpaque(false);
        this.textScrollPane.setViewportView(this.textInfo);
        if (this.examplePanel != null) {
            this.examplePanel.setPreferredSize(new Dimension(200, 200));
            this.examplePanel.setMinimumSize(new Dimension(200, 200));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.examplePanel, "Center");
            jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Example"));
            insets = jPanel2.getBorder().getBorderInsets(jPanel2);
            jPanel.add((Component)jPanel2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 15, 1, new Insets(6, 12, 12 - insets.bottom + 2, 12), 0, 0));
        }
        this.wizardTreeScrollPane.getViewport().add((Component)this.wizardTree, null);
        this.add((Component)jPanel, "Center");
    }

    private boolean setSelectedNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        if (defaultMutableTreeNode.getUserObject() != null && defaultMutableTreeNode.getUserObject().equals(object)) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.wizardTree.setSelectionPath(treePath);
            this.wizardTree.scrollPathToVisible(treePath);
            return true;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            if (!this.setSelectedNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), object)) continue;
            return true;
        }
        return false;
    }

    private class ExamplePanel
    extends JPanel {
        public ExamplePanel() {
            this.setBorder(null);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            double d = this.getWidth();
            double d2 = this.getHeight();
            AbstractWizardInfo abstractWizardInfo = SelectWizardPage.this.getWizardInfo();
            if (abstractWizardInfo != null && abstractWizardInfo.getWizardImage() != null) {
                ImageIcon imageIcon = abstractWizardInfo.getWizardImage();
                int n = imageIcon.getIconHeight();
                int n2 = imageIcon.getIconWidth();
                imageIcon.paintIcon(this, graphics, (int)((d - (double)n2) / 2.0), (int)((d2 - (double)n) / 2.0));
            }
        }
    }
}

