/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.DataBrowser;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindowWizard;

public class WizardBrowserPage
extends WizardPageClass {
    private DataBrowser dataBrowser;
    private JComboBox comboBoxFilter = new JComboBox();
    private final TreeSelectionListener treeListener = new MyTreeSelectionListener();
    private final ItemListener itemListener = new ItemSelected();

    public WizardBrowserPage(AbstractWizard abstractWizard, Project_GUI project_GUI, DataTreeInterface dataTreeInterface) {
        this(abstractWizard, project_GUI, dataTreeInterface, true);
    }

    public WizardBrowserPage(AbstractWizard abstractWizard, Project_GUI project_GUI, DataTreeInterface dataTreeInterface, boolean bl) {
        super((LayoutManager)new GridBagLayout(), abstractWizard);
        Serializable serializable;
        AbstractDataNode abstractDataNode = project_GUI.getRootNode();
        if (dataTreeInterface == null) {
            dataTreeInterface = project_GUI.getSelectedTreeNode();
        }
        this.dataBrowser = new DataBrowser(abstractDataNode, false);
        this.dataBrowser.UpdateDataTree(dataTreeInterface);
        this.dataBrowser.setTagFilter(1);
        this.dataBrowser.setFilterCase(true);
        this.dataBrowser.addTreeSelectionListener(this.treeListener);
        JLabel jLabel = new JLabel("Select data");
        jLabel.setFont(new Font("Dialog", 1, 12));
        this.comboBoxFilter.setEnabled(bl);
        this.comboBoxFilter.addItemListener(this.itemListener);
        this.comboBoxFilter.addItem(new ComboItem("All", 15, 0));
        this.comboBoxFilter.addItem(new ComboItem("Observations", 1, 0));
        this.comboBoxFilter.addItem(new ComboItem("Variables", 2, 1));
        this.comboBoxFilter.addItem(new ComboItem("Statistics", 4, 1));
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            serializable = (AbstractDataMatrix)dataTreeInterface;
            if ((((AbstractDataMatrix)serializable).getMatrixTag() & 1) != 0) {
                this.comboBoxFilter.setSelectedIndex(1);
            } else if ((((AbstractDataMatrix)serializable).getMatrixTag() & 2) != 0) {
                this.comboBoxFilter.setSelectedIndex(2);
            } else if ((((AbstractDataMatrix)serializable).getMatrixTag() & 4) != 0) {
                this.comboBoxFilter.setSelectedIndex(3);
            }
        }
        this.dataBrowser.setCreated();
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 5, 0), 0, 0));
        this.add((Component)new JLabel("Show:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.comboBoxFilter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 10, 0, 10), 0, 0));
        serializable = new JScrollPane();
        this.add((Component)serializable, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 10, 10, 10), 0, 0));
        ((JScrollPane)serializable).getViewport().add((Component)this.dataBrowser, null);
    }

    public DataBrowser getBrowser() {
        return this.dataBrowser;
    }

    public DataTreeInterface getSelected() {
        Object object = this.dataBrowser.getSelectedNode().getUserObject();
        if (object instanceof DataTreeInterface) {
            return (DataTreeInterface)object;
        }
        return null;
    }

    public void setFilter(byte by) {
        this.dataBrowser.setFilter(by);
    }

    public void setTagFilter(int n) {
        this.dataBrowser.setTagFilter(n);
    }

    public void showPage() {
        if (this.dataBrowser != null) {
            this.dataBrowser.ReloadDataTree();
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataBrowser != null) {
            this.dataBrowser.removeTreeSelectionListener(this.treeListener);
            this.dataBrowser.cleanUp();
            this.dataBrowser = null;
        }
        if (this.comboBoxFilter != null) {
            this.comboBoxFilter.removeItemListener(this.itemListener);
            this.comboBoxFilter = null;
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof DataTreeInterface && WizardBrowserPage.this.wizard instanceof AbstractWindowWizard) {
                ((AbstractWindowWizard)WizardBrowserPage.this.wizard).selectDti((DataTreeInterface)object);
            }
        }
    }

    class ItemSelected
    implements ItemListener {
        ItemSelected() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                int n = ((ComboItem)itemEvent.getItem()).getType();
                WizardBrowserPage.this.dataBrowser.setTagFilter(n);
            }
        }
    }
}

