/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard.script;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.script.BasicWizardPage;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.FileDataClass;

public class BasicFileSelection
extends JScrollPane {
    private final JList list = new JList();
    private final String[] supportedExt = new String[]{"sac", "xml", "brz", "raw"};

    public BasicFileSelection(final BasicWizardPage basicWizardPage) {
        this.list.setCellRenderer(new ImageListCellRenderer());
        File file = IniManager.getWorkDir((byte)1);
        this.setFolder(new FileDataClass(file));
        this.list.setBorder(BorderFactory.createEtchedBorder());
        this.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                    basicWizardPage.pressNextButton();
                }
            }
        });
    }

    public Object getValue() {
        File file = (File)this.list.getSelectedValue();
        return new FileDataClass(file);
    }

    public void setFolder(FileDataClass fileDataClass) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = fileDataClass.getFile().listFiles();
        if (fileArray != null) {
            block0: for (File file3 : fileArray) {
                if (file3.isDirectory()) {
                    vector.addElement(file3);
                    continue;
                }
                String string = jopensaveDialog.getFileExtension(file3);
                for (String string2 : this.supportedExt) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    vector.addElement(file3);
                    continue block0;
                }
            }
            Collections.sort(vector, (file, file2) -> {
                File file3 = file;
                File file4 = file2;
                if (file3.isDirectory() && !file4.isDirectory()) {
                    return -1;
                }
                if (file4.isDirectory() && !file3.isDirectory()) {
                    return 1;
                }
                return Double.compare(file4.lastModified(), file3.lastModified());
            });
        }
        this.list.setListData(vector);
        if (vector.size() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    protected JList getFileList() {
        return this.list;
    }

    private static class ImageListCellRenderer
    implements ListCellRenderer {
        JLabel label = new JLabel();
        ImageIcon folderIcon;
        ImageIcon fileIcon;

        public ImageListCellRenderer() {
            this.label.setOpaque(true);
            Font font = this.label.getFont();
            this.label.setFont(new Font(font.getName(), font.getStyle(), 32));
            this.folderIcon = new ImageIcon(BasicFileSelection.class.getResource("images/folder64.png"));
            this.fileIcon = new ImageIcon(BasicFileSelection.class.getResource("images/file64.png"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            String string = file.getName();
            int n2 = string.lastIndexOf(".");
            if (n2 > 0) {
                // empty if block
            }
            if (file.isDirectory()) {
                this.label.setIcon(this.folderIcon);
            } else {
                this.label.setIcon(this.fileIcon);
            }
            this.label.setText(string);
            if (bl) {
                this.label.setBackground(jList.getSelectionBackground());
                this.label.setForeground(jList.getSelectionForeground());
            } else {
                this.label.setBackground(jList.getBackground());
                this.label.setForeground(jList.getForeground());
            }
            return this.label;
        }
    }
}

