/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard.script;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.common.wizard.script.BasicWizardPage;
import se.prediktera.map.common.wizard.script.PageBanner;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptParser;

public class BasicWizard
extends AbstractWizard
implements BasicTreeInterface {
    private final Project_GUI project_GUI;
    private final ScriptParser scriptParser;
    private final String title;
    private final Properties properties;
    private PageBanner pageBanner = null;

    public BasicWizard(Project_GUI project_GUI, ScriptParser scriptParser, String string, Properties properties) {
        this.project_GUI = project_GUI;
        this.scriptParser = scriptParser;
        this.title = string;
        this.properties = properties;
    }

    @Override
    public boolean canFinish() {
        return this.currentPage != null && this.isLastPage() && this.currentPage.canFinish();
    }

    public BasicWizardPage createPage() {
        return this.createPage("N/A");
    }

    public BasicWizardPage createPage(String string) {
        BasicWizardPage basicWizardPage = new BasicWizardPage(this, string);
        this.addPage(basicWizardPage, "page" + (this.getPageCount() + 1));
        return basicWizardPage;
    }

    @Override
    public int executeWizard() {
        try {
            this.pageBanner = new PageBanner(this);
            int n = 800;
            int n2 = 600;
            if (this.properties != null) {
                if (ScriptHelper.hasKey(this.properties, "width")) {
                    n = ScriptHelper.getPropertyInt(this.properties, "width");
                }
                if (ScriptHelper.hasKey(this.properties, "height")) {
                    n2 = ScriptHelper.getPropertyInt(this.properties, "height");
                }
            }
            this.setPreferredSize(new Dimension(n, n2));
            this.wizardWindow = new WizardDialog(IniManager.getMainFrame(), this.title, this, this.pageBanner, true, false, false);
            return this.wizardWindow.executeWizard();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return 0;
        }
    }

    @Override
    public boolean finished() {
        return true;
    }

    public void fullScreen() {
        Frame frame = new Frame();
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (graphicsDevice.isFullScreenSupported()) {
            graphicsDevice.setFullScreenWindow(frame);
        }
    }

    @Override
    public String getDescription() {
        return "Import";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public Project_GUI getProjectGUI() {
        return this.project_GUI;
    }

    public ScriptParser getScriptParser() {
        return this.scriptParser;
    }

    public void hideWizard() {
        if (this.wizardWindow instanceof JDialog) {
            ((JDialog)((Object)this.wizardWindow)).setDefaultCloseOperation(0);
            ((JDialog)((Object)this.wizardWindow)).setVisible(false);
        }
    }

    @Override
    public boolean isLastPage() {
        return super.isLastPage() && this.currentPage != null;
    }

    public Double showWizard() {
        return this.executeWizard();
    }

    @Override
    protected String getHelpID() {
        return "none";
    }

    @Override
    protected void pageChangedLocal(WizardPageClass wizardPageClass, int n) {
        this.pageBanner.togglePage(n);
    }
}

