/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.wizard.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.common.wizard.script.BasicFileSelection;
import se.prediktera.map.common.wizard.script.BasicSlideAdapter;
import se.prediktera.map.common.wizard.script.BasicWizard;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.ImageDataClass;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.ScriptParser;

public class BasicWizardPage
extends WizardPageClass
implements BasicTreeInterface {
    private String title;
    private final String shortName;
    private final List<ComponentClass> componentList = new ArrayList<ComponentClass>();
    private final List<ActionClass> actionList = new ArrayList<ActionClass>();
    private int rowindex = 0;
    private final BasicSlideAdapter basicSlideAdapter;

    public BasicWizardPage(BasicWizard basicWizard, String string) {
        super(basicWizard);
        this.shortName = string;
        this.setLayout(new GridBagLayout());
        this.basicSlideAdapter = new BasicSlideAdapter(this);
    }

    public void addComponent(String string) throws Exception {
        this.addComponent(string, null);
    }

    public Object addComponent(String string, Object object) throws Exception {
        return this.addComponent(string, object, null);
    }

    public Object addComponent(String string, Object object, Properties properties) throws Exception {
        JComponent jComponent = null;
        if ((string = string.toLowerCase()).startsWith("textarea")) {
            jComponent = this.addTextArea(properties);
        } else if (string.startsWith("htmlarea")) {
            jComponent = this.addHtmlArea(properties);
        } else if (string.startsWith("imagearea")) {
            jComponent = this.addImageArea();
        } else if (string.startsWith("filearea")) {
            jComponent = this.addFileSelection();
        }
        this.componentList.add(new ComponentClass(string, jComponent));
        ++this.rowindex;
        if (object != null) {
            this.setValue(string, object);
        }
        return jComponent;
    }

    public void addEvent(String string, String string2) {
        int n = (string = string.toLowerCase()).indexOf("_");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            for (final ComponentClass componentClass : this.componentList) {
                if (!string3.equalsIgnoreCase(componentClass.type)) continue;
                final String string4 = string.substring(n + 1);
                if (string4.equals("onclick") || string4.equals("ondubbleclick")) {
                    Component component = componentClass.component;
                    component.addMouseListener(new MouseAdapter(this){
                        final /* synthetic */ BasicWizardPage this$0;
                        {
                            this.this$0 = basicWizardPage;
                        }

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            if (!this.this$0.basicSlideAdapter.isSliding()) {
                                ImageDataClass imageDataClass = (ImageDataClass)componentClass.value;
                                double d = imageDataClass.getImage().getWidth(null);
                                double d2 = imageDataClass.getImage().getHeight(null);
                                double d3 = mouseEvent.getX();
                                double d4 = mouseEvent.getY();
                                int n = mouseEvent.getClickCount();
                                if (n > 1 == string4.equals("ondubbleclick")) {
                                    this.this$0.runAction(componentClass.type, new Variable[]{new Variable(d3 / d, "rel_x_coord"), new Variable(d4 / d2, "rel_y_coord")});
                                }
                            }
                        }
                    });
                    component.setCursor(Cursor.getPredefinedCursor(12));
                }
                this.actionList.add(new ActionClass(string3, string4, string2));
            }
        } else {
            this.actionList.add(new ActionClass(string, string2));
        }
    }

    @Override
    public boolean finishedPressed() {
        return this.runAction("finish", null);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public Object getValue(String string) {
        for (ComponentClass componentClass : this.componentList) {
            Component component;
            if (!componentClass.type.equalsIgnoreCase(string) || !(component = componentClass.component).getClass().equals(BasicFileSelection.class)) continue;
            BasicFileSelection basicFileSelection = (BasicFileSelection)component;
            return basicFileSelection.getValue();
        }
        return null;
    }

    @Override
    public boolean nextPressed() {
        return this.runAction("next", null);
    }

    @Override
    public void pageShown() {
        this.runAction("show", null);
        super.pageShown();
    }

    public void pressNextButton() {
        this.wizard.handleDoubleClick(this.wizard.isLastPage());
    }

    public void pressPreviousButton() {
        this.wizard.handlePreviousClick();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setValue(String string, Object object) {
        for (ComponentClass componentClass : this.componentList) {
            if (!componentClass.type.equalsIgnoreCase(string)) continue;
            Component component = componentClass.component;
            if (component.getClass().equals(JLabel.class)) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(2);
                jLabel.setVerticalAlignment(1);
                jLabel.setIcon(new ImageIcon(((ImageDataClass)object).getImage()));
            } else if (component.getClass().equals(JTextArea.class)) {
                JTextArea jTextArea = (JTextArea)component;
                jTextArea.setText(object.toString());
            } else if (component.getClass().equals(JTextPane.class)) {
                JTextPane jTextPane = (JTextPane)component;
                jTextPane.setContentType("text/html");
                jTextPane.setText(object.toString());
            } else if (component.getClass().equals(BasicFileSelection.class)) {
                BasicFileSelection basicFileSelection = (BasicFileSelection)component;
                basicFileSelection.setFolder((FileDataClass)object);
            }
            componentClass.value = object;
            break;
        }
    }

    @Override
    public String toString() {
        return this.title;
    }

    private BasicFileSelection addFileSelection() {
        BasicFileSelection basicFileSelection = new BasicFileSelection(this);
        this.basicSlideAdapter.addComponent(basicFileSelection);
        this.add((Component)basicFileSelection, new GridBagConstraints(0, this.rowindex, 1, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
        return basicFileSelection;
    }

    private JTextPane addHtmlArea(Properties properties) throws Exception {
        JTextPane jTextPane = new JTextPane();
        int n = 16;
        Color color = UIManager.getDefaults().getColor("Panel.background");
        if (properties != null && ScriptHelper.hasKey(properties, "size")) {
            n = ScriptHelper.getPropertyInt(properties, "size");
        }
        jTextPane.setBackground(color);
        jTextPane.setEnabled(false);
        jTextPane.setDisabledTextColor(jTextPane.getForeground());
        jTextPane.setFont(new Font("Dialog", 1, n));
        this.basicSlideAdapter.addComponent(jTextPane);
        this.add((Component)jTextPane, new GridBagConstraints(0, this.rowindex, 1, 1, 1.0, 0.1, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
        return jTextPane;
    }

    private JLabel addImageArea() {
        JLabel jLabel = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setBackground(Color.red);
        this.basicSlideAdapter.addComponent(jLabel);
        this.basicSlideAdapter.addComponent(jPanel);
        this.add((Component)jPanel, new GridBagConstraints(0, this.rowindex, 1, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jLabel;
    }

    private JTextArea addTextArea(Properties properties) throws Exception {
        JTextArea jTextArea = new JTextArea();
        int n = 16;
        Color color = UIManager.getDefaults().getColor("Panel.background");
        if (properties != null && ScriptHelper.hasKey(properties, "size")) {
            n = ScriptHelper.getPropertyInt(properties, "size");
        }
        jTextArea.setBackground(color);
        jTextArea.setTabSize(4);
        jTextArea.setColumns(20);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setFont(new Font("Dialog", 1, n));
        jTextArea.setLineWrap(true);
        jTextArea.setRows(5);
        jTextArea.setWrapStyleWord(true);
        this.basicSlideAdapter.addComponent(jTextArea);
        this.add((Component)jTextArea, new GridBagConstraints(0, this.rowindex, 1, 1, 1.0, 0.1, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
        return jTextArea;
    }

    private boolean runAction(String string, final Variable[] variableArray) {
        for (final ActionClass actionClass : this.actionList) {
            if (!actionClass.type.equalsIgnoreCase(string)) continue;
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ BasicWizardPage this$0;
                {
                    this.this$0 = basicWizardPage;
                }

                @Override
                public Object doWork() {
                    try {
                        ScriptManager scriptManager = new ScriptManager(null);
                        ScriptParser scriptParser = ((BasicWizard)this.this$0.wizard).getScriptParser();
                        scriptManager.addGlobalVariables(scriptParser);
                        for (ComponentClass componentClass : this.this$0.componentList) {
                            scriptManager.addVariable(componentClass.value, componentClass.type);
                        }
                        if (variableArray != null) {
                            for (Variable variable : variableArray) {
                                scriptManager.addVariable(variable.value, variable.name);
                            }
                        }
                        scriptManager.evaluteScript(this, actionClass.script);
                        return Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                        return Boolean.FALSE;
                    }
                }
            };
            progressManagerImpl.invokeNow();
            Boolean bl = (Boolean)progressManagerImpl.getResult();
            if (bl == null) continue;
            return bl;
        }
        return false;
    }

    private static class ComponentClass {
        public String type;
        public Component component;
        public Object value;

        public ComponentClass(String string, Component component) {
            this.type = string;
            this.component = component;
        }
    }

    private static class ActionClass {
        public String type;
        public String script;

        public ActionClass(String string, String string2) {
            this(string, null, string2);
        }

        public ActionClass(String string, String string2, String string3) {
            this.type = string;
            this.script = string3;
        }
    }

    private static class Variable {
        public Object value;
        public String name;

        public Variable(Object object, String string) {
            this.value = object;
            this.name = string;
        }
    }
}

