/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import se.prediktera.map.components.paint.PaintComposite;
import se.prediktera.map.components.paint.PaintCustomExtLib;
import se.prediktera.map.components.paint.PaintDataControl;
import se.prediktera.map.components.paint.PaintDataControlGroup;
import se.prediktera.map.components.paint.PaintDataSource;
import se.prediktera.map.components.paint.PaintDot;
import se.prediktera.map.components.paint.PaintEvince;
import se.prediktera.map.components.paint.PaintGraph;
import se.prediktera.map.components.paint.PaintHistory;
import se.prediktera.map.components.paint.PaintInput;
import se.prediktera.map.components.paint.PaintModel;
import se.prediktera.map.components.paint.PaintOutput;
import se.prediktera.map.components.paint.PaintPrediction;
import se.prediktera.map.components.paint.PaintStatistics;
import se.prediktera.map.components.paint.PaintTable;
import se.prediktera.map.components.paint.PaintTransform;
import se.prediktera.map.components.paint.PaintVisualization;

public abstract class AbstractPaint {
    public static final int NONE = -1;
    public static final int INPUT = 0;
    public static final int DATACONTROL = 1;
    public static final int TRANSFORM = 2;
    public static final int MODEL = 3;
    public static final int OUTPUT = 4;
    public static final int COMPOSITE = 5;
    public static final int VISUALIZATION = 6;
    public static final int CUSTOMEXTLIB = 7;
    public static final int OTHER = 8;
    public static final int TABLE = 9;
    public static final int EVINCE = 10;
    public static final int HISTORY = 11;
    public static final int DATASOURCE = 12;
    public static final int GRAPH = 13;
    public static final int MODELEXTERNAL = 14;
    public static final int PREDICTION = 15;
    public static final int INPUTEXTERNAL = 16;
    public static final int STATISTICS = 17;
    public static final int INPUTMODEL = 18;
    public static final int DOT = 19;
    public static final int DATACONTROLGROUP = 20;
    public static final int PORTWIDTH = 10;
    public static final int PORTWIDTH2 = 100;
    public static final byte NORMAL = 0;
    public static final byte MOUSEOVER = 1;
    public static final byte MOUSEDOWN = 2;
    public static final float[] dash1 = new float[]{10.0f};
    public static final BasicStroke stroke = new BasicStroke(1.0f, 1, 0, 10.0f);
    public static final BasicStroke stroke2 = new BasicStroke(2.0f, 1, 0, 10.0f);
    public static final BasicStroke stroke4 = new BasicStroke(4.0f, 1, 0, 10.0f);
    public static final BasicStroke dashed2 = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
    public static final BasicStroke dashed = new BasicStroke(3.0f, 0, 0, 10.0f, dash1, 0.0f);
    protected Dimension dim;
    protected byte componentstate = 0;
    private final String text;
    private boolean islocked = false;
    private boolean switchto = false;

    public static ImageIcon createIcon(int n) {
        return AbstractPaint.createIcon(n, 16);
    }

    public static ImageIcon createIcon(int n, int n2) {
        AbstractPaint abstractPaint = AbstractPaint.getPaintMethod(n);
        Dimension dimension = abstractPaint.getDimension();
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (abstractPaint.handleDimensionChange()) {
            abstractPaint.setDimension(new Dimension(n2, n2));
        } else {
            double d = dimension.width > dimension.height ? (double)n2 / (double)dimension.width : (double)n2 / (double)dimension.height;
            graphics2D.scale(d, d);
        }
        abstractPaint.paintComponent(graphics2D);
        graphics2D.setTransform(affineTransform);
        return new ImageIcon(bufferedImage);
    }

    public static AbstractPaint getPaintMethod(int n) {
        return switch (n) {
            case 5 -> new PaintComposite("");
            case 1 -> new PaintDataControl("");
            case 0 -> new PaintInput("");
            case 3 -> new PaintModel("", false);
            case 14 -> new PaintModel("", true);
            case 4 -> new PaintOutput("");
            case 2 -> new PaintTransform("");
            case 6 -> new PaintVisualization("");
            case 7 -> new PaintCustomExtLib("");
            case 9 -> new PaintTable("");
            case 10 -> new PaintEvince("");
            case 11 -> new PaintHistory("");
            case 12 -> new PaintDataSource("");
            case 13 -> new PaintGraph("");
            case 15 -> new PaintPrediction("");
            case 16 -> new PaintInput("", 1);
            case 17 -> new PaintStatistics("", true);
            case 18 -> new PaintInput("", 2);
            case 19 -> new PaintDot("");
            case 20 -> new PaintDataControlGroup("");
            default -> null;
        };
    }

    public AbstractPaint(Dimension dimension, String string) {
        this.dim = dimension;
        this.text = string;
    }

    public Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255));
    }

    public Color darker(Color color, double d) {
        return new Color(Math.max((int)((double)color.getRed() * d), 0), Math.max((int)((double)color.getGreen() * d), 0), Math.max((int)((double)color.getBlue() * d), 0));
    }

    public abstract Color getColor();

    public Dimension getDimension() {
        return this.dim;
    }

    public boolean handleDimensionChange() {
        return false;
    }

    public void paintComponent(Graphics2D graphics2D) {
        if (this.islocked) {
            AffineTransform affineTransform = graphics2D.getTransform();
            this.drawBody(graphics2D, false, true);
            Color[] colorArray = new Color[5];
            int n = this.componentstate == 2 || this.switchto ? 0 : 4;
            colorArray[n] = this.getColor();
            for (int i = 1; i < 5; ++i) {
                if (n > 0) {
                    colorArray[n - i] = this.darker(colorArray[n - (i - 1)], 0.85);
                    continue;
                }
                colorArray[i] = this.darker(colorArray[i - 1], 0.85);
            }
            double d = 1.0;
            for (int i = 0; i < 5; ++i) {
                if (i == 4 && n == 0) {
                    graphics2D.translate(1, 1);
                }
                graphics2D.scale(d, d);
                graphics2D.translate(((double)this.dim.width - (double)this.dim.width * d) / 2.0, ((double)this.dim.height - (double)this.dim.height * d) / 2.0);
                graphics2D.setColor(colorArray[i]);
                this.drawBody(graphics2D, false, false);
                d = this.getButtonCorr();
                if (i != 0) continue;
                graphics2D.translate(1, 1);
            }
            GradientPaint gradientPaint = null;
            gradientPaint = n > 0 ? new GradientPaint(this.getGradientStart(), this.getGradientStart(), new Color(255, 255, 255, 200), this.dim.width / 2 + this.getGradientStart(), this.dim.height / 2 + this.getGradientStart(), new Color(0, 0, 0, 0)) : new GradientPaint(this.dim.width / 2 - this.getGradientEnd(), this.dim.height / 2 - this.getGradientEnd(), new Color(0, 0, 0, 0), this.dim.width - this.getGradientEnd(), this.dim.height - this.getGradientEnd(), new Color(255, 255, 255, 200));
            graphics2D.setPaint(gradientPaint);
            this.drawBody(graphics2D, false, false);
            graphics2D.setTransform(affineTransform);
        } else {
            this.drawBody(graphics2D, false, true);
        }
    }

    public abstract void paintSelection(Graphics2D var1);

    public void paintText(Graphics2D graphics2D) {
        int n = 10;
        if (this.islocked && this.componentstate == 1) {
            n = 16;
        }
        graphics2D.setStroke(stroke);
        Font font = new Font("SansSerif", 1, n);
        if (this.islocked) {
            graphics2D.setColor(Color.white);
            graphics2D.setFont(font);
            this.drawText(graphics2D, this.text, 1, 1);
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(font);
        this.drawText(graphics2D, this.text, 0, 0);
    }

    public void setActive(boolean bl) {
    }

    public void setArrowVisible(boolean bl) {
    }

    public void setComponentState(byte by) {
        this.componentstate = by;
    }

    public void setDimension(Dimension dimension) {
        this.dim = dimension;
    }

    public void setLocked(boolean bl) {
        this.islocked = bl;
    }

    public void setSwitchTo(boolean bl) {
        this.switchto = bl;
    }

    protected abstract void drawBody(Graphics2D var1, boolean var2, boolean var3);

    protected double getButtonCorr() {
        return 0.95;
    }

    protected int getGradientEnd() {
        return 15;
    }

    protected int getGradientStart() {
        return 15;
    }

    protected abstract int getTextCorr();

    private void drawText(Graphics2D graphics2D, String string, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        graphics2D.drawString(string, this.dim.width / 2 - n3 / 2 + this.getTextCorr() + n, this.dim.height / 2 + n4 / 3 + n2);
    }
}

