/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.paint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import se.prediktera.map.components.paint.AbstractPaint;

public class PaintDot
extends AbstractPaint {
    private static final Color dotColor = new Color(138, 185, 56);

    public PaintDot(String string) {
        super(new Dimension(16, 16), string);
    }

    @Override
    public Color getColor() {
        return dotColor;
    }

    @Override
    public boolean handleDimensionChange() {
        return true;
    }

    @Override
    public void paintSelection(Graphics2D graphics2D) {
        int n = this.dim.width / 8;
        graphics2D.setStroke(dashed);
        graphics2D.setColor(Color.yellow);
        graphics2D.drawOval(n, n, this.dim.width - n * 2, this.dim.height - n * 2);
    }

    @Override
    protected void drawBody(Graphics2D graphics2D, boolean bl, boolean bl2) {
        graphics2D.setColor(dotColor);
        graphics2D.fillOval(2, 2, 10, 10);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(2, 2, 10, 10);
    }

    @Override
    protected int getGradientEnd() {
        return 20;
    }

    @Override
    protected int getGradientStart() {
        return 20;
    }

    @Override
    protected int getTextCorr() {
        return 1;
    }
}

