/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import se.prediktera.map.components.paint.AbstractPaint;

public class PaintEvince
extends AbstractPaint {
    private static final Color evinceColor = Color.red;
    private BasicStroke evinceStroke = null;

    public PaintEvince(String string) {
        super(new Dimension(80, 80), string);
    }

    @Override
    public Color getColor() {
        return evinceColor;
    }

    @Override
    public boolean handleDimensionChange() {
        return true;
    }

    @Override
    public void paintSelection(Graphics2D graphics2D) {
        int n = this.dim.width / 8;
        graphics2D.setStroke(dashed);
        graphics2D.setColor(Color.yellow);
        graphics2D.drawOval(n, n, this.dim.width - n * 2, this.dim.height - n * 2);
    }

    @Override
    protected void drawBody(Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (bl2) {
            graphics2D.setStroke(stroke);
            if (bl) {
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setColor(this.getColor());
            }
        }
        float f = (float)this.dim.width / 20.0f;
        if (this.evinceStroke == null || Float.compare(this.evinceStroke.getLineWidth(), f) != 0) {
            this.evinceStroke = new BasicStroke(f, 1, 0, 10.0f);
        }
        int n = this.dim.width / 8;
        graphics2D.fillOval(n, n, this.dim.width - n * 2, this.dim.height - n * 2);
        if (bl2) {
            graphics2D.drawOval(n, n, this.dim.width - n * 2, this.dim.height - n * 2);
        }
        graphics2D.setColor(Color.white);
        graphics2D.setStroke(this.evinceStroke);
        graphics2D.drawLine(this.dim.width / 2, this.dim.height / 4, this.dim.width / 2, this.dim.height - this.dim.height / 4);
        graphics2D.drawLine(this.dim.width / 4, this.dim.height / 2, this.dim.width - this.dim.width / 4, this.dim.height / 2);
        graphics2D.fillOval(this.dim.width - this.dim.width / 3 - this.dim.width / 20, this.dim.height / 3 - this.dim.width / 20, this.dim.width / 10, this.dim.height / 10);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.rotate(Math.toRadians(45.0), this.dim.width / 2, this.dim.height / 2);
        graphics2D.fillRoundRect(this.dim.width / 2 - this.dim.width / 12, this.dim.height / 2 - this.dim.height / 12, this.dim.width / 6, this.dim.height / 6, this.dim.width / 20, this.dim.height / 20);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    protected int getGradientEnd() {
        return 20;
    }

    @Override
    protected int getGradientStart() {
        return 20;
    }

    @Override
    protected int getTextCorr() {
        return 1;
    }
}

