/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.paint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;

public class PaintInput
extends AbstractPaint {
    static final Dimension dim = new Dimension(80, 80);
    static final Color color = PerfectSpread.generateColor(0);
    private boolean paintArrow = true;
    private final GeneralPath path;
    private final GeneralPath arrow;
    private final int beginleft = 15;
    private final int middleY;
    private final int arrowheight = 4;
    private byte type;

    public PaintInput(String string) {
        this(string, 0);
    }

    public PaintInput(String string, byte by) {
        super(dim, string);
        this.middleY = PaintInput.dim.height / 2;
        this.arrowheight = 4;
        this.type = 0;
        this.type = by;
        this.path = new GeneralPath();
        this.path.moveTo(15.0f, 5.0f);
        this.path.lineTo(PaintInput.dim.width - 5, this.middleY);
        this.path.lineTo(15.0f, PaintInput.dim.height - 5);
        this.path.lineTo(15.0f, 5.0f);
        this.path.closePath();
        this.arrow = new GeneralPath();
        this.arrow.moveTo(5.0f, this.middleY - 4);
        this.arrow.lineTo(13.0f, this.middleY - 4);
        this.arrow.lineTo(13.0f, this.middleY - 4 - 4);
        this.arrow.lineTo(23.0f, this.middleY);
        this.arrow.lineTo(13.0f, this.middleY + 4 + 4);
        this.arrow.lineTo(13.0f, this.middleY + 4);
        this.arrow.lineTo(5.0f, this.middleY + 4);
        this.arrow.closePath();
    }

    @Override
    public Color getColor() {
        return color;
    }

    @Override
    public void paintSelection(Graphics2D graphics2D) {
        graphics2D.setStroke(dashed);
        graphics2D.setColor(Color.yellow);
        graphics2D.draw(this.path);
    }

    @Override
    public void setArrowVisible(boolean bl) {
        this.paintArrow = bl;
    }

    @Override
    protected void drawBody(Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                graphics2D.setStroke(stroke);
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setStroke(stroke2);
                switch (this.type) {
                    case 0: {
                        graphics2D.setColor(this.getColor());
                        break;
                    }
                    case 1: {
                        graphics2D.setColor(new Color(255, 162, 0));
                        break;
                    }
                    case 2: {
                        graphics2D.setColor(PerfectSpread.generateColor(1));
                    }
                }
            }
        }
        graphics2D.fill(this.path);
        if (bl2) {
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.path);
        }
        if (bl || this.paintArrow) {
            // empty if block
        }
    }

    @Override
    protected double getButtonCorr() {
        return 0.92;
    }

    @Override
    protected int getGradientEnd() {
        return 25;
    }

    @Override
    protected int getTextCorr() {
        return -2;
    }
}

