/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.paint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import se.prediktera.map.components.paint.AbstractPaint;

public class PaintOutput
extends AbstractPaint {
    static final Dimension dim = new Dimension(80, 80);
    static final Color color = new Color(255, 0, 255);
    GeneralPath path;
    GeneralPath arrow;
    int middleY;
    int arrowheight;
    int arrowwidth;

    public PaintOutput(String string) {
        super(dim, string);
        this.middleY = PaintOutput.dim.height / 2;
        this.arrowheight = 4;
        this.arrowwidth = PaintOutput.dim.width / 3;
        this.path = new GeneralPath();
        this.path.moveTo(5.0f, this.middleY);
        this.path.lineTo(PaintOutput.dim.width - 15, 5.0f);
        this.path.lineTo(PaintOutput.dim.width - 15, PaintOutput.dim.height - 5);
        this.path.lineTo(5.0f, this.middleY);
        this.path.closePath();
        this.arrow = new GeneralPath();
        this.arrow.moveTo(PaintOutput.dim.width - this.arrowwidth, this.middleY - this.arrowheight);
        this.arrow.lineTo(PaintOutput.dim.width - 10, this.middleY - this.arrowheight);
        this.arrow.lineTo(PaintOutput.dim.width - 10, this.middleY - this.arrowheight - this.arrowheight);
        this.arrow.lineTo(PaintOutput.dim.width, this.middleY);
        this.arrow.lineTo(PaintOutput.dim.width - 10, this.middleY + this.arrowheight + this.arrowheight);
        this.arrow.lineTo(PaintOutput.dim.width - 10, this.middleY + this.arrowheight);
        this.arrow.lineTo(PaintOutput.dim.width - this.arrowwidth, this.middleY + this.arrowheight);
        this.arrow.closePath();
    }

    @Override
    public Color getColor() {
        return color;
    }

    @Override
    public void paintSelection(Graphics2D graphics2D) {
        graphics2D.setStroke(dashed);
        graphics2D.setColor(Color.yellow);
        graphics2D.draw(this.path);
    }

    @Override
    protected void drawBody(Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                graphics2D.setStroke(stroke);
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setStroke(stroke2);
                graphics2D.setColor(this.getColor());
            }
        }
        graphics2D.fill(this.path);
        if (bl2) {
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.path);
        }
        if (bl || bl2) {
            // empty if block
        }
    }

    @Override
    protected double getButtonCorr() {
        return 0.92;
    }

    @Override
    protected int getGradientStart() {
        return 25;
    }

    @Override
    protected int getTextCorr() {
        return -1;
    }
}

