/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.paint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import se.prediktera.map.components.paint.AbstractPaint;

public class PaintTransform
extends AbstractPaint {
    static final Dimension dim = new Dimension(80, 80);
    private boolean active = true;

    public PaintTransform(String string) {
        super(dim, string);
    }

    @Override
    public Color getColor() {
        return Color.cyan;
    }

    @Override
    public void paintSelection(Graphics2D graphics2D) {
        graphics2D.setStroke(dashed);
        graphics2D.setColor(Color.yellow);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.rotate(Math.toRadians(45.0), PaintTransform.dim.width / 2, PaintTransform.dim.height / 2);
        graphics2D.drawRoundRect(PaintTransform.dim.width / 8 + 2, PaintTransform.dim.height / 8 + 2, PaintTransform.dim.width - PaintTransform.dim.width / 4 - 5, PaintTransform.dim.height - PaintTransform.dim.height / 4 - 5, PaintTransform.dim.width / 3, PaintTransform.dim.height / 3);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void paintText(Graphics2D graphics2D) {
        super.paintText(graphics2D);
        if (!this.active) {
            this.drawInActive(graphics2D);
        }
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    protected void drawBody(Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                graphics2D.setStroke(stroke);
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setStroke(stroke2);
                graphics2D.setColor(this.getColor());
            }
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.rotate(Math.toRadians(45.0), PaintTransform.dim.width / 2, PaintTransform.dim.height / 2);
        graphics2D.fillRoundRect(PaintTransform.dim.width / 8 + 2, PaintTransform.dim.height / 8 + 2, PaintTransform.dim.width - PaintTransform.dim.width / 4 - 5, PaintTransform.dim.height - PaintTransform.dim.height / 4 - 5, PaintTransform.dim.width / 3, PaintTransform.dim.height / 3);
        if (bl2) {
            graphics2D.setColor(Color.black);
            graphics2D.drawRoundRect(PaintTransform.dim.width / 8 + 2, PaintTransform.dim.height / 8 + 2, PaintTransform.dim.width - PaintTransform.dim.width / 4 - 5, PaintTransform.dim.height - PaintTransform.dim.height / 4 - 5, PaintTransform.dim.width / 3, PaintTransform.dim.height / 3);
        }
        graphics2D.setTransform(affineTransform);
    }

    @Override
    protected int getTextCorr() {
        return 1;
    }

    private void drawInActive(Graphics2D graphics2D) {
        graphics2D.setColor(Color.orange);
        graphics2D.fillRect(5, 25, PaintTransform.dim.width - 10, 27);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(5, 25, PaintTransform.dim.width - 10, 27);
        graphics2D.drawString("Inactive", 22, PaintTransform.dim.height / 2 + 2);
    }
}

