/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.tree;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import se.prediktera.map.common.cleanup.CleanUpTree;
import se.prediktera.map.components.tree.AbstractComponentNode;
import se.prediktera.map.components.tree.CustomNodeRenderer;
import se.prediktera.map.main.Main_GUI;

public abstract class AbstractComponentTree
extends CleanUpTree
implements DragSourceListener,
DragGestureListener,
TreeSelectionListener {
    private static final Hashtable<ImageIcon, Cursor> customCursors = new Hashtable();
    protected AbstractComponentNode selectedNode;
    private DragSource dragSource = null;

    private static Cursor getDragCursor(AbstractComponentNode abstractComponentNode) {
        ImageIcon imageIcon = abstractComponentNode.getIcon((byte)0);
        if (imageIcon != null) {
            Cursor cursor = customCursors.get(imageIcon);
            if (cursor == null) {
                BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ImageIcon imageIcon2 = new ImageIcon(Main_GUI.class.getResource("cursor/normal.gif"));
                imageIcon2.paintIcon(null, graphics2D, 0, 0);
                imageIcon.paintIcon(null, graphics2D, bufferedImage.getWidth() - imageIcon.getIconWidth(), bufferedImage.getHeight() - imageIcon.getIconHeight());
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                cursor = toolkit.createCustomCursor(bufferedImage, new Point(0, 0), "Custom Drag");
                customCursors.put(imageIcon, cursor);
            }
            return cursor;
        }
        return null;
    }

    public AbstractComponentTree() {
        this(null, false);
    }

    public AbstractComponentTree(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        super(defaultMutableTreeNode, "AbstractComponentTree");
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        CustomNodeRenderer customNodeRenderer = new CustomNodeRenderer();
        this.setCellRenderer(customNodeRenderer);
        this.setFont(new Font("Dialog", 0, 10));
        this.setRowHeight(16);
        customNodeRenderer.setFont(this.getFont());
        this.addTreeSelectionListener(this);
        if (bl) {
            this.dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFEFFF);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        AbstractComponentNode abstractComponentNode = this.getSelectedNode();
        if (abstractComponentNode == null) {
            return;
        }
        Transferable transferable = this.createTransferable(abstractComponentNode);
        if (transferable == null) {
            return;
        }
        this.dragSource.startDrag(dragGestureEvent, AbstractComponentTree.getDragCursor(abstractComponentNode), transferable, this);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public AbstractComponentNode getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath == null) {
            this.selectedNode = null;
            return;
        }
        this.selectedNode = (AbstractComponentNode)treePath.getLastPathComponent();
    }

    @Override
    protected void cleanUpChild() {
        this.selectedNode = null;
    }

    protected abstract Transferable createTransferable(AbstractComponentNode var1);
}

