/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.components.tree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.components.tree.AbstractComponentNode;
import se.prediktera.map.components.tree.CustomNodeInterface;
import se.prediktera.map.main.BrowserElement;
import se.prediktera.map.main.DataBrowser;

public class CustomNodeRenderer
extends DefaultTreeCellRenderer {
    public static final float[] dash1 = new float[]{5.0f};
    public static final BasicStroke stroke = new BasicStroke(1.0f, 1, 0, 10.0f);
    public static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
    private AbstractComponentNode componentNode;
    private boolean expanded = false;
    private boolean leaf = false;
    private byte marked = 0;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        if (bl3 && object instanceof BrowserElement && (object2 = ((BrowserElement)object).getDataTreeInterface()) != null) {
            bl3 = object2.isLeaf();
        }
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (jTree instanceof DataBrowser) {
            this.marked = ((DataBrowser)jTree).isMarked((BrowserElement)object);
            if (this.marked == 1 && bl2) {
                this.marked = 0;
            }
        } else {
            this.marked = 0;
        }
        this.componentNode = null;
        this.expanded = bl2;
        this.leaf = bl3;
        this.setFont(jTree.getFont());
        if (object instanceof CustomNodeInterface) {
            ImageIcon imageIcon;
            object2 = (CustomNodeInterface)object;
            if (object instanceof AbstractComponentNode) {
                this.componentNode = (AbstractComponentNode)object;
            }
            if ((imageIcon = object2.getIcon((byte)(bl2 ? 1 : 0))) != null) {
                this.setIcon(imageIcon);
                this.componentNode = null;
            }
            this.setToolTipText(object2.getToolTipText());
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        AbstractPaint abstractPaint;
        Object object;
        super.paintComponent(graphics);
        if (this.marked > 0) {
            object = (Graphics2D)graphics;
            if (this.marked == 1) {
                ((Graphics2D)object).setStroke(dashed);
            }
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if ((object = this.componentNode) != null && (abstractPaint = ((AbstractComponentNode)object).getPaint()) != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension dimension = abstractPaint.getDimension();
            double d = 1.0;
            double d2 = 5.0;
            double d3 = 0.5;
            double d4 = 3.0;
            if (this.expanded && !this.leaf) {
                d = 0.8;
                d2 = 7.0;
            }
            if (this.leaf) {
                d3 = 0.8;
                d2 = 0.0;
                d4 = 0.0;
                Color color = this.getBackground();
                if (color != null) {
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, 20, this.getHeight());
                }
            }
            double d5 = dimension.height;
            double d6 = dimension.width;
            double d7 = (double)this.getHeight() / (d5 > d6 ? d5 : d6 * 0.85) * d3;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(d4, d2);
            graphics2D.scale(d7, d7 * d);
            abstractPaint.paintComponent(graphics2D);
            graphics2D.setTransform(affineTransform);
        }
    }
}

