/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.DataTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.fixed.AbstractFixedTable;
import se.prediktera.map.data.fixed.FixedColumnTable;
import se.prediktera.map.data.fixed.FixedInterface;
import se.prediktera.map.data.fixed.FixedRowTable;

public abstract class AbstractDataTable
extends AbstractSimpleTable
implements FixedInterface {
    protected JSplitPane splitPane;
    private boolean isResizing = false;
    private JPanel leftPanel;
    private JPanel rightPanel;

    public AbstractDataTable(DataInit dataInit) {
        super(dataInit);
        this.init();
    }

    public AbstractDataTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init();
    }

    public void resetSplitPane() {
        if (this.splitPane != null) {
            this.setupColumnLocations();
        }
    }

    @Override
    public void resetToPreferredSizes() {
        if (this.splitPane != null) {
            int n = this.getDefaultCellWidth();
            if (n == 0) {
                n = 75;
            }
            this.splitPane.setDividerLocation(n + ((DataTable)this.simpleTable).getFixedTable(0).getColumnTable().getRowHeader().getFixedCellWidth());
        }
    }

    public void setDividerLocation(int n) {
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(n);
        }
    }

    public void setupColumnLocations() {
        if (this.isResizing) {
            return;
        }
        this.isResizing = true;
        try {
            FixedColumnTable fixedColumnTable = this.getFixedColumnTableFromSplitPane();
            int n = fixedColumnTable.getRowHeader().getWidth();
            int n2 = fixedColumnTable.getColumnTable().getColumnCount();
            TableColumnModel tableColumnModel = fixedColumnTable.getColumnTable().getColumnModel();
            int n3 = this.splitPane.getDividerLocation() - n;
            int n4 = this.calculateTotalColumnWidth(tableColumnModel);
            for (int i = 0; i < n2; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                float f = (float)tableColumn.getWidth() / ((float)n4 * 1.0f);
                int n5 = (int)(f * (float)n3);
                n5 = n5 < 40 ? 40 : n5;
                this.setColumnWidth(tableColumn, n5, i == n2 - 1);
            }
            if (n2 > 0 && this.splitPane.getDividerLocation() < n + 40 * Math.min(n2, 2)) {
                this.splitPane.setDividerLocation(n + 40 * Math.min(n2, 2));
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        this.isResizing = false;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.splitPane = null;
        this.leftPanel = null;
        this.rightPanel = null;
    }

    @Override
    protected SimpleTable createSimpleTable() {
        return new DataTable(this, this.centerPane);
    }

    private int calculateTotalColumnWidth(TableColumnModel tableColumnModel) {
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += tableColumnModel.getColumn(i).getPreferredWidth();
        }
        return n2;
    }

    private FixedColumnTable getFixedColumnTableFromSplitPane() {
        for (int i = 0; i < this.splitPane.getComponentCount(); ++i) {
            Component component = this.splitPane.getComponent(i);
            if (!(component instanceof JPanel)) continue;
            JPanel jPanel = (JPanel)component;
            for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                if (!(jPanel.getComponent(j) instanceof FixedColumnTable)) continue;
                return (FixedColumnTable)jPanel.getComponent(j);
            }
        }
        return null;
    }

    private void init() {
        AbstractFixedTable abstractFixedTable;
        DataTable dataTable = (DataTable)this.simpleTable;
        this.leftPanel = new JPanel(new BorderLayout());
        AbstractFixedTable abstractFixedTable2 = dataTable.getFixedTable(2);
        if (abstractFixedTable2 != null) {
            this.leftPanel.add((Component)abstractFixedTable2, "North");
        }
        if ((abstractFixedTable = dataTable.getFixedTable(0)) != null) {
            this.leftPanel.add((Component)abstractFixedTable, "Center");
            this.leftPanel.addComponentListener(abstractFixedTable.getColumnTable());
        }
        this.rightPanel = new JPanel(new BorderLayout());
        AbstractFixedTable abstractFixedTable3 = dataTable.getFixedTable(1);
        if (abstractFixedTable3 != null) {
            this.rightPanel.add((Component)abstractFixedTable3, "North");
        }
        this.rightPanel.add((Component)this.centerPane, "Center");
        this.splitPane = new JSplitPane(1, this.leftPanel, this.rightPanel);
        this.splitPane.setDividerSize(2);
        this.splitPane.addPropertyChangeListener(propertyChangeEvent -> {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                this.setupColumnLocations();
            }
        });
        this.splitPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = AbstractDataTable.this.splitPane.getParent().getWidth();
                Object object = AbstractDataTable.this.rightPanel.getComponent(0);
                if (!(object instanceof FixedRowTable)) {
                    return;
                }
                FixedRowTable fixedRowTable = (FixedRowTable)object;
                object = fixedRowTable.getColumnTable().getColumnModel();
                int n2 = AbstractDataTable.this.calculateTotalColumnWidth((TableColumnModel)object);
                if (n2 > n) {
                    return;
                }
                int n3 = Math.min(AbstractDataTable.this.splitPane.getDividerLocation(), n - n2 - 20);
                AbstractDataTable.this.splitPane.setDividerLocation(n3);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        int n = this.getDefaultCellWidth();
        if (n == 0) {
            n = 75;
        }
        if (abstractFixedTable != null) {
            this.splitPane.setDividerLocation(n + abstractFixedTable.getColumnTable().getRowHeader().getFixedCellWidth());
        }
        this.add((Component)this.splitPane, "Center");
    }

    private void setColumnWidth(TableColumn tableColumn, int n, boolean bl) {
        if (bl) {
            --n;
            tableColumn.setResizable(false);
        } else {
            tableColumn.setResizable(true);
        }
        tableColumn.setWidth(n);
        tableColumn.setPreferredWidth(n);
        if (tableColumn.getHeaderValue().toString().equals("")) {
            tableColumn.setHeaderValue("Col " + (tableColumn.getModelIndex() + 1));
        }
    }
}

