/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.DataSelectionDialog;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.fixed.FixedColumnTable;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataGroupListener;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public abstract class AbstractSimpleTable
extends AbstractTable
implements DataGroupListener {
    public static ImageIcon plotIcon = new ImageIcon(Main_GUI.class.getResource("gif/table.gif"));
    protected int firstDataColumn = 0;
    protected SimpleTable simpleTable;
    protected JScrollPane centerPane = new JScrollPane(){

        @Override
        public void setColumnHeaderView(Component component) {
        }
    };

    public AbstractSimpleTable(DataInit dataInit) {
        super(dataInit);
        this.init(dataInit.getDataTreeInterface());
    }

    public AbstractSimpleTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init(this.dti);
        try {
            int n;
            int[] nArray;
            if (mapProperty.hasProperty("selR") && (nArray = mapProperty.getLVIntArray()) != null && nArray.length > 0) {
                this.simpleTable.setRowSelectionInterval(nArray[0], nArray[0]);
                for (n = 1; n < nArray.length; ++n) {
                    this.simpleTable.addRowSelectionInterval(nArray[n], nArray[n]);
                }
            }
            if (mapProperty.hasProperty("selC") && (nArray = mapProperty.getLVIntArray()) != null && nArray.length > 0) {
                this.simpleTable.setColumnSelectionInterval(nArray[0], nArray[0]);
                for (n = 1; n < nArray.length; ++n) {
                    this.simpleTable.addColumnSelectionInterval(nArray[n], nArray[n]);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorHandler.logAndReportException(illegalArgumentException);
        }
        byte by = this.getInteractionFlag();
        this.setInteractionFlag((byte)0);
        this.setInteractionFlag(by);
    }

    public void addRowSelectionInterval(int n, int n2) {
        if (this.simpleTable != null) {
            this.simpleTable.addRowSelectionInterval(n, n2);
        }
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        ImageIcon imageIcon = new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png"));
        if (dataTreeInterface instanceof DataSet) {
            CMenu cMenu = new CMenu("Apply Template", true);
            ScriptManager.addScriptToMenu(cMenu, this, dataTreeInterface, "table", "dataset");
            jPopupMenu.add(cMenu);
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new CMenuItem("Save As...", imageIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimpleTable.this.exportData();
            }
        });
        this.simpleTable.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        return true;
    }

    public int binarySearch(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            int n6 = nArray[n5];
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    @Override
    public void dataGroupChanged(AbstractInnerColumn abstractInnerColumn, byte by) {
        this.fireTableStructureChanged();
        try {
            JSplitPane jSplitPane = (JSplitPane)this.getComponent(0);
            for (int i = 0; i < jSplitPane.getComponentCount(); ++i) {
                Component component = jSplitPane.getComponent(i);
                if (!(component instanceof JPanel)) continue;
                JPanel jPanel = (JPanel)component;
                for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                    Component component2 = jPanel.getComponent(j);
                    if (!(component2 instanceof FixedColumnTable)) continue;
                    FixedColumnTable fixedColumnTable = (FixedColumnTable)component2;
                    int n = fixedColumnTable.getColumnTable().getColumnCount();
                    TableColumnModel tableColumnModel = fixedColumnTable.getColumnTable().getColumnModel();
                    TableColumn tableColumn = tableColumnModel.getColumn(n - 1);
                    if (!tableColumn.getHeaderValue().toString().equals("")) continue;
                    tableColumn.setHeaderValue(abstractInnerColumn.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void DataSelected() {
        if (this.window_gui != null) {
            this.window_gui.selectedWindowUpdated(this);
        }
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        this.simpleTable.beginInteraction();
        int n = this.doInteraction(interactionInterface, this.getRowType());
        int n2 = this.doInteraction(interactionInterface, this.getColumnType());
        byte by = this.getInteractionFlag();
        if (by == 2) {
            this.simpleTable.fireTableStructureChanged();
        } else {
            Rectangle rectangle = this.simpleTable.getCellRect(n, n2, true);
            Rectangle rectangle2 = this.simpleTable.getVisibleRect();
            if (rectangle.x < rectangle2.x || rectangle.y < rectangle2.y || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width || rectangle.y + rectangle.height > rectangle2.y + rectangle2.width) {
                if (n2 >= 0) {
                    rectangle2.x = rectangle.x - (rectangle2.width - rectangle.width) / 2;
                }
                if (n >= 0) {
                    rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height) / 2;
                }
                this.simpleTable.scrollRectToVisible(rectangle2);
            }
        }
        this.simpleTable.endInteraction();
        return n >= 0 || n2 >= 0;
    }

    public void exportData() {
        AbstractExportInfo.ExportDataNow(this.getSimpleTable().getSimpleTableModel(), false);
    }

    @Override
    public void finishInteraction() {
    }

    public void fireTableChanged() {
        if (this.simpleTable != null) {
            this.simpleTable.fireTableChanged();
        }
    }

    public void fireTableStructureChanged() {
        if (this.simpleTable != null) {
            this.simpleTable.fireTableStructureChanged();
        }
    }

    public int getColumnType() {
        return this.simpleTable.getSimpleTableModel().getColumnType();
    }

    public int getCount(boolean bl) {
        if (bl) {
            return this.simpleTable.getRowCount();
        }
        return this.simpleTable.getColumnCount();
    }

    @Override
    public DataTreeInterface getDataTreeInterface() {
        return this.dti;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(470);
        stringBuilder.append("<HTML><BODY>");
        if (this.simpleTable != null) {
            DataTreeInterface dataTreeInterface;
            stringBuilder.append("<B>Table - ").append(this).append("</B><br>");
            if (this.getMatrix() != null) {
                stringBuilder.append(this.getMatrix().getCase()).append("<br>");
            }
            stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            if (this.getMatrix() != null && (dataTreeInterface = this.getMatrix().getTreeParent()) != null) {
                stringBuilder.append("<tr><td>Parent:</td><td>").append(dataTreeInterface).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>Data:</td><td>").append(this.getMatrix()).append("</td></tr>");
            stringBuilder.append("<TR><TD>Rows:</TD><TD>").append(this.simpleTable.getRowCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Columns:</TD><TD>").append(this.simpleTable.getColumnCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Selected rows:</TD><TD>").append(this.simpleTable.getSelectedRowCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Selected columns:</TD><TD>").append(this.simpleTable.getSelectedColumnCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Sort by:</TD><TD>").append(this.simpleTable.getSortBy()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Order by:</TD><TD>").append(this.simpleTable.getOrderBy()).append("</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public InteractionArray getInteractionArray(int n) {
        SimpleTableModel simpleTableModel = this.simpleTable.getSimpleTableModel();
        if (this.project_GUI != null) {
            return this.project_GUI.getInteractionArray(n, simpleTableModel.getGroupID());
        }
        return null;
    }

    @Override
    public int getInteractiveTag() {
        if (this.simpleTable == null) {
            return 0;
        }
        AbstractDataMatrix abstractDataMatrix = this.simpleTable.getMatrix();
        if (abstractDataMatrix != null) {
            return abstractDataMatrix.getMatrixTag();
        }
        return 1;
    }

    public AbstractDataMatrix getMatrix() {
        return this.simpleTable.getMatrix();
    }

    public int getOrigCount(boolean bl) {
        if (bl) {
            return ((SimpleTableModel)this.simpleTable.getModel()).getOrigRowCount();
        }
        return ((SimpleTableModel)this.simpleTable.getModel()).getOrigColumnCount();
    }

    public int getRowType() {
        return this.simpleTable.getSimpleTableModel().getRowType();
    }

    public int[] getSelectedColumns() {
        if (this.simpleTable == null) {
            return null;
        }
        int[] nArray = this.simpleTable.getSelectedColumns();
        if (this.firstDataColumn > 0) {
            int n = nArray.length;
            for (int n2 : nArray) {
                if (n2 >= this.firstDataColumn) continue;
                --n;
            }
            int[] nArray2 = new int[n];
            int n3 = 0;
            for (int n4 : nArray) {
                if (n4 < this.firstDataColumn) continue;
                nArray2[n3++] = n4 - this.firstDataColumn;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSelectedOrigIndex(boolean bl) {
        SimpleTableModel simpleTableModel = (SimpleTableModel)this.simpleTable.getModel();
        int[] nArray = this.getSelectedIndicis(bl);
        int[] nArray2 = this.getMatrixRef(bl);
        if (nArray2 == null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) continue;
                nArray[i] = bl ? simpleTableModel.getDataRow(nArray[i]) : simpleTableModel.getDataCol(nArray[i]);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                if (nArray[i] < 0) continue;
                if (bl) {
                    n = simpleTableModel.getDataRow(nArray[i]);
                    if (n >= 0 && n < nArray2.length) {
                        nArray[i] = nArray2[n];
                        continue;
                    }
                    nArray[i] = n;
                    continue;
                }
                n = simpleTableModel.getDataCol(nArray[i]);
                nArray[i] = n >= 0 && n < nArray2.length ? nArray2[n] : n;
            }
        }
        return nArray;
    }

    public int[] getSelectedRows() {
        if (this.simpleTable == null) {
            return null;
        }
        return this.simpleTable.getSelectedRows();
    }

    @Override
    public SimpleTable getSimpleTable() {
        return this.simpleTable;
    }

    public SimpleTableModel getSimpleTableModel() {
        if (this.simpleTable == null) {
            return null;
        }
        return this.simpleTable.getSimpleTableModel();
    }

    public boolean hasInteraction(int n) {
        return this.simpleTable.getSimpleTableModel().hasInteraction(n);
    }

    @Override
    public boolean hasInteractivity() {
        return super.hasInteractivity() && this.simpleTable != null;
    }

    public boolean interactiveSelection() {
        if (this.window_gui != null) {
            return this.window_gui.getProject_GUI().doInteraction(this);
        }
        return false;
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        SwingUtilities.invokeLater(() -> this.fireTableStructureChanged());
    }

    @Override
    public void prepareInteraction() {
        this.prepareInteraction(this.getRowType(), true);
        this.prepareInteraction(this.getColumnType(), false);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        if (this.simpleTable != null) {
            int[] nArray;
            int[] nArray2;
            if (this.getInteractionFlag() == 2) {
                nArray2 = this.simpleTable.getSimpleTableModel().getRowIndex();
                nArray = this.simpleTable.getSimpleTableModel().getColumnIndex();
            } else {
                nArray2 = this.simpleTable.getSelectedRows();
                nArray = this.simpleTable.getSelectedColumns();
            }
            randomOutputStream.writePropertyIntArray("selR", nArray2);
            randomOutputStream.writePropertyIntArray("selC", nArray);
        }
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 0 && this.simpleTable.matrix.isCleaned()) {
            this.cleanUp();
            return 2;
        }
        return 0;
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        if (this.simpleTable != null) {
            this.simpleTable.addDropTarget(abstractWindow_GUI);
            this.simpleTable.addGlobalMouseListener(this);
            if (UpdateHelper.Product.isRunningProductEvince()) {
                this.setSelectionDialog(new DataSelectionDialog(this));
            }
        }
    }

    @Override
    public void setInteractionFlag(byte by) {
        byte by2 = this.getInteractionFlag();
        if (by2 == by) {
            return;
        }
        SimpleTable simpleTable = this.getSimpleTable();
        simpleTable.beginInteraction();
        SimpleTableModel simpleTableModel = (SimpleTableModel)simpleTable.getModel();
        if (by == 2) {
            if ((this.getInteractiveTag() & 1) != 0) {
                if (simpleTable.isObsColumn()) {
                    simpleTableModel.setRowIndex((int[])this.getSelectedIndicis(true).clone());
                } else {
                    simpleTableModel.setColumnIndex((int[])this.getSelectedIndicis(true).clone());
                }
            }
            if ((this.getInteractiveTag() & 2) != 0) {
                if (simpleTable.isObsColumn()) {
                    simpleTableModel.setColumnIndex((int[])this.getSelectedIndicis(false).clone());
                } else {
                    simpleTableModel.setRowIndex((int[])this.getSelectedIndicis(false).clone());
                }
            }
            simpleTable.clearSelection();
            simpleTable.fireTableStructureChanged();
        } else if (by2 == 2) {
            boolean bl = true;
            int[] nArray = simpleTableModel.getRowIndex();
            simpleTableModel.setRowIndex(null);
            int[] nArray2 = simpleTableModel.getColumnIndex();
            simpleTableModel.setColumnIndex(null);
            simpleTable.fireTableStructureChanged();
            if ((this.getInteractiveTag() & 1) != 0 && nArray != null) {
                for (int n : nArray) {
                    if (bl) {
                        simpleTable.setRowSelectionInterval(n, n);
                        bl = false;
                        continue;
                    }
                    simpleTable.addRowSelectionInterval(n, n);
                }
            }
            bl = true;
            if ((this.getInteractiveTag() & 2) != 0 && nArray2 != null) {
                for (int n : nArray2) {
                    if (bl) {
                        simpleTable.setColumnSelectionInterval(n + this.firstDataColumn, n + this.firstDataColumn);
                        bl = false;
                        continue;
                    }
                    simpleTable.addColumnSelectionInterval(n + this.firstDataColumn, n + this.firstDataColumn);
                }
            }
        }
        simpleTable.endInteraction();
        super.setInteractionFlag(by);
    }

    public void setMatrix(AbstractDataMatrix abstractDataMatrix) {
        if (this.simpleTable != null) {
            DataInit dataInit = this.getDataInit();
            if (dataInit != null) {
                dataInit.setDataTreeInterface(abstractDataMatrix);
            }
            this.simpleTable.setMatrix(abstractDataMatrix);
        }
    }

    public void setRowSelectionInterval(int n, int n2) {
        if (this.simpleTable != null) {
            this.simpleTable.setRowSelectionInterval(n, n2);
        }
    }

    public int setSelectIntervalFromRefOrig(int[] nArray, boolean bl) {
        int n = -1;
        int n2 = this.getCount(bl) - 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            if (nArray[i] < 0) continue;
            int n4 = n3 = nArray[i++];
            while (i < nArray.length && nArray[i] >= 0) {
                if (nArray[i] > n4 + 1) {
                    --i;
                    break;
                }
                n4 = nArray[i];
                ++i;
            }
            if (n3 > n2) break;
            if (n4 > n2) {
                n4 = n2;
            }
            this.selectedInterval(n == -1, n3, n4, bl);
            if (n == -1) {
                n = n3;
            }
            if (n4 == n2) break;
        }
        return n;
    }

    public AbstractDataMatrix toMatrix() {
        return new MVmatrix(this.simpleTable.getRowCount(), this.simpleTable.getColumnCount());
    }

    @Override
    protected void cleanUpChild() {
        DataGroupValues dataGroupValues;
        AbstractDataInfo[] abstractDataInfoArray;
        DataSet dataSet = null;
        if (this.dti instanceof AbstractDataMatrix) {
            abstractDataInfoArray = ((AbstractDataMatrix)this.dti).getCase();
            if (abstractDataInfoArray != null) {
                dataSet = abstractDataInfoArray.getOriginalDataSet();
            }
        } else if (this.dti instanceof DataSet) {
            dataSet = (DataSet)this.dti;
        }
        if (dataSet != null && (abstractDataInfoArray = dataSet.getDataInfo()) != null && (dataGroupValues = abstractDataInfoArray[0].getGroupColumnByType(0)) != null) {
            dataGroupValues.removeListener(this);
            dataGroupValues = abstractDataInfoArray[1].getGroupColumnByType(0);
            dataGroupValues.removeListener(this);
        }
        super.cleanUpChild();
        if (this.simpleTable != null) {
            this.simpleTable.removeGlobalMouseListener(this);
            this.simpleTable.cleanUp();
            this.simpleTable = null;
        }
        this.centerPane = null;
    }

    protected void clearSelection(boolean bl) {
        if (bl) {
            if (this.simpleTable.getRowCount() > 0) {
                this.simpleTable.removeRowSelectionInterval(0, this.simpleTable.getRowCount() - 1);
            }
        } else if (this.simpleTable.getColumnCount() > 0) {
            this.simpleTable.removeColumnSelectionInterval(0, this.simpleTable.getColumnCount() - 1);
        }
    }

    protected SimpleTable createSimpleTable() {
        return new SimpleTable(this.centerPane, this, true, true, true);
    }

    protected int doInteraction(InteractionInterface interactionInterface, int n) {
        SimpleTableModel simpleTableModel = this.simpleTable.getSimpleTableModel();
        InteractionArray interactionArray = this.getInteractionArray(n);
        if (interactionArray == null) {
            return -1;
        }
        boolean bl = this.getRowType() == n;
        byte by = this.getInteractionFlag();
        int n2 = -1;
        int n3 = (n & 1) > 0 ? 0 : this.firstDataColumn;
        int n4 = this.getOrigCount(bl);
        int[] nArray = this.getMatrixRef(bl);
        if (by == 2) {
            int n5 = 0;
            for (int i = 0; i < n4 - n3; ++i) {
                if ((nArray != null && i < nArray.length || i >= interactionArray.size() || !interactionArray.get(i)) && (nArray == null || i >= nArray.length || !interactionArray.get(nArray[i]))) continue;
                ++n5;
            }
            int[] nArray2 = null;
            if (n5 > 0) {
                nArray2 = new int[n5];
                n5 = 0;
                for (int i = 0; i < n4 - n3; ++i) {
                    if ((nArray != null || !interactionArray.get(i)) && (nArray == null || i >= nArray.length || !interactionArray.get(nArray[i]))) continue;
                    nArray2[n5++] = i;
                }
            }
            if (bl) {
                simpleTableModel.setRowIndex(nArray2);
            } else {
                simpleTableModel.setColumnIndex(nArray2);
            }
            this.simpleTable.noSort();
        } else {
            int n6;
            boolean bl2 = true;
            int n7 = -1;
            int n8 = -1;
            for (n6 = 0; n6 < n4; ++n6) {
                int n9 = this.getSortedColOrRow(simpleTableModel, n6, bl) - n3;
                if ((nArray != null && n9 < nArray.length || n9 >= interactionArray.size() || !interactionArray.get(n9)) && (nArray == null || n9 < 0 || n9 >= nArray.length || !interactionArray.get(nArray[n9]))) continue;
                if (n7 < 0) {
                    n8 = n7 = n6;
                    continue;
                }
                if (n6 == n8 + 1) {
                    ++n8;
                    continue;
                }
                this.selectedInterval(bl2, n7, n8, bl);
                if (bl2) {
                    n2 = n7;
                    bl2 = false;
                }
                n8 = n7 = n6;
            }
            if (n7 >= 0) {
                this.selectedInterval(bl2, n7, n8, bl);
                if (bl2) {
                    n2 = n7;
                    bl2 = false;
                }
            }
            if (n2 < 0) {
                n6 = interactionArray.getSetCount();
                if (n6 == 0 && !bl) {
                    this.selectedInterval(true, 0, this.getCount(false), false);
                } else {
                    this.clearSelection(bl);
                }
            }
        }
        return n2;
    }

    protected InteractionArray getInteractionArray(DataTreeInterface dataTreeInterface, int n, int n2, int n3) {
        return this.project_GUI.getInteractionArray(dataTreeInterface, n, n2, n3);
    }

    protected int[] getMatrixRef(boolean bl) {
        return this.getSimpleTableModel().getRef(bl);
    }

    protected int[] getSelectedIndicis(boolean bl) {
        if (bl) {
            return this.getSelectedRows();
        }
        return this.getSelectedColumns();
    }

    protected int getSortedColOrRow(SimpleTableModel simpleTableModel, int n, boolean bl) {
        return bl ? simpleTableModel.getDataRow(n) : simpleTableModel.getDataCol(n);
    }

    protected void selectedInterval(boolean bl, int n, int n2, boolean bl2) {
        try {
            if (bl2) {
                int n3 = this.simpleTable.getRowCount() - 1;
                if (bl) {
                    this.simpleTable.setRowSelectionInterval(Math.min(n, n3), Math.min(n2, n3));
                } else {
                    this.simpleTable.addRowSelectionInterval(Math.min(n, n3), Math.min(n2, n3));
                }
            } else {
                int n4 = this.simpleTable.getColumnCount() - 1;
                if (bl) {
                    this.simpleTable.setColumnSelectionInterval(Math.min(n, n4), Math.min(n2, n4));
                } else {
                    this.simpleTable.addColumnSelectionInterval(Math.min(n, n4), Math.min(n2, n4));
                }
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void init(DataTreeInterface dataTreeInterface) {
        DataTreeClass dataTreeClass;
        AbstractDataInfo[] abstractDataInfoArray;
        this.simpleTable = this.createSimpleTable();
        DataSet dataSet = null;
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            abstractDataInfoArray = (AbstractDataInfo[])dataTreeInterface;
            this.setMatrix((AbstractDataMatrix)abstractDataInfoArray);
            dataTreeClass = abstractDataInfoArray.getCase();
            if (dataTreeClass != null) {
                dataSet = ((Case)dataTreeClass).getOriginalDataSet();
            }
        } else if (dataTreeInterface instanceof DataSet) {
            dataSet = (DataSet)dataTreeInterface;
        }
        if (dataSet != null) {
            abstractDataInfoArray = dataSet.getDataInfo();
            if (abstractDataInfoArray != null && abstractDataInfoArray[0] != null && (dataTreeClass = abstractDataInfoArray[0].getGroupColumnByType(0)) != null) {
                ((DataGroupValues)dataTreeClass).addListener(this);
            }
            if (abstractDataInfoArray != null && abstractDataInfoArray[1] != null && (dataTreeClass = abstractDataInfoArray[1].getGroupColumnByType(0)) != null) {
                ((DataGroupValues)dataTreeClass).addListener(this);
            }
        }
        this.setLayout(new BorderLayout());
        this.centerPane.setHorizontalScrollBarPolicy(32);
        this.centerPane.setVerticalScrollBarPolicy(22);
        this.centerPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AbstractSimpleTable.this.mousePressed(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AbstractSimpleTable.this.mousePressed(mouseEvent);
                }
            }
        });
    }

    private void prepareInteraction(int n, boolean bl) {
        int[] nArray;
        SimpleTableModel simpleTableModel = (SimpleTableModel)this.simpleTable.getModel();
        if (simpleTableModel == null || n == 16) {
            return;
        }
        byte by = this.getSelectionType();
        int n2 = simpleTableModel.getGroupID();
        if (by == 3) {
            this.getInteractionArray(null, n, 0, n2);
            return;
        }
        if (by == 1) {
            this.simpleTable.beginInteraction();
            if (this.simpleTable.getRowCount() > 0) {
                this.simpleTable.setRowSelectionInterval(0, this.simpleTable.getRowCount() - 1);
            }
            if (this.simpleTable.getColumnCount() > 0) {
                this.simpleTable.setColumnSelectionInterval(0, this.simpleTable.getColumnCount() - 1);
            }
            this.simpleTable.endInteraction();
        }
        int[] nArray2 = this.getSelectedOrigIndex(bl);
        this.setInteractionArray(n, bl, by, nArray2, n2);
        if (n == 1 && simpleTableModel.isGroup() && (nArray = simpleTableModel.getGroupRow(nArray2)) != null) {
            this.setInteractionArray(n, bl, by, nArray, 0);
        }
    }

    private void setInteractionArray(int n, boolean bl, byte by, int[] nArray, int n2) {
        if (by == 2) {
            int n3 = this.getOrigCount(bl);
            InteractionArray interactionArray = this.getInteractionArray(null, n, n3, n2);
            for (int i = 0; i < n3; ++i) {
                interactionArray.set(i);
            }
            for (int n4 : nArray) {
                interactionArray.set(n4, false);
            }
        } else {
            int n5 = -1;
            for (int n6 : nArray) {
                if (n6 <= n5) continue;
                n5 = n6;
            }
            Object object = this.getInteractionArray(null, n, ++n5, n2);
            for (int n7 : nArray) {
                ((BooleanArray)object).set(n7);
            }
        }
    }
}

