/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.data.AbstractDataTable;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public abstract class AbstractTabbedTable
extends AbstractTable {
    protected TabbedPane tabbedPane = new TabbedPane();

    public AbstractTabbedTable(DataInit dataInit) {
        super(dataInit);
        this.init();
    }

    public AbstractTabbedTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init();
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        }
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        return false;
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        boolean bl = false;
        for (int i = 0; i < this.tabbedPane.getNumberOfTables(); ++i) {
            AbstractDataTable abstractDataTable = this.tabbedPane.getTableEditorAt(i);
            if (abstractDataTable == null || abstractDataTable == interactionInterface) continue;
            bl = abstractDataTable.doInteraction(interactionInterface) || bl;
        }
        return bl;
    }

    @Override
    public void finishInteraction() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            abstractTable.finishInteraction();
        }
    }

    public AbstractTable getCurrentTable() {
        if (this.tabbedPane != null) {
            return this.tabbedPane.getSelectedTableEditor();
        }
        return null;
    }

    public SimpleTable getDataTable() {
        AbstractTable abstractTable;
        if (this.tabbedPane != null && (abstractTable = this.tabbedPane.getSelectedTableEditor()) != null) {
            return abstractTable.getSimpleTable();
        }
        return null;
    }

    @Override
    public String getGUI_Name() {
        if (this.tabbedPane == null) {
            return "";
        }
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.getGUI_Name();
        }
        return "";
    }

    @Override
    public String getInformation() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.getInformation();
        }
        return "";
    }

    @Override
    public byte getInteractionFlag() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.getInteractionFlag();
        }
        return super.getInteractionFlag();
    }

    @Override
    public int getInteractiveTag() {
        int n = 0;
        for (int i = 0; i < this.tabbedPane.getNumberOfTables(); ++i) {
            AbstractDataTable abstractDataTable = this.tabbedPane.getTableEditorAt(i);
            n |= ((AbstractWindow)abstractDataTable).getInteractiveTag();
        }
        return n;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.tabbedPane == null) {
            return null;
        }
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.getSettingsPanel();
        }
        return null;
    }

    @Override
    public void getToolbars(Vector<JToolBar> vector) {
        AbstractTable abstractTable = this.getCurrentTable();
        if (abstractTable != null) {
            abstractTable.getToolbars(vector);
        }
    }

    @Override
    public boolean hasInteractionByAncestor() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.hasInteractionByAncestor();
        }
        return super.hasInteractionByAncestor();
    }

    @Override
    public boolean hasInteractivity() {
        AbstractTable abstractTable;
        if (this.tabbedPane != null && (abstractTable = this.tabbedPane.getSelectedTableEditor()) != null) {
            return abstractTable.hasInteractivity();
        }
        return super.hasInteractivity();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.window_gui.selectedWindowUpdated(this, true);
        super.mousePressed(mouseEvent);
    }

    @Override
    public void prepareInteraction() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            abstractTable.prepareInteraction();
        }
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        switch (by) {
            case 0: {
                if (!this.tabbedPane.PurgeSignal()) break;
                this.cleanUp();
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.tabbedPane.setCreated(abstractWindow_GUI, bl);
    }

    @Override
    public void setInteractionFlag(byte by) {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            abstractTable.setInteractionFlag(by);
        }
    }

    @Override
    public void setInteractive(boolean bl) {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            abstractTable.setInteractive(bl);
        }
    }

    @Override
    public boolean showOnlySelected() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.showOnlySelected();
        }
        return super.showOnlySelected();
    }

    @Override
    protected void cleanUpChild() {
        if (this.window_gui != null) {
            this.window_gui.selectedWindowUpdated(null);
        }
        super.cleanUpChild();
        if (this.tabbedPane != null) {
            this.tabbedPane.cleanUp();
            this.tabbedPane = null;
        }
    }

    @Override
    protected AbstractWindowProperties createProperties() {
        AbstractTable abstractTable = this.tabbedPane.getSelectedTableEditor();
        if (abstractTable != null) {
            return abstractTable.createProperties();
        }
        return null;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    protected class TabbedPane
    extends JTabbedPane {
        private TabChangeListener tabChangeListener;

        public TabbedPane() {
            super(3);
            this.tabChangeListener = new TabChangeListener();
            this.addChangeListener(this.tabChangeListener);
            this.addMouseListener(AbstractTabbedTable.this);
        }

        public void addEditor(AbstractTable abstractTable, String string, Icon icon) {
            DataTreeInterface dataTreeInterface = abstractTable.getDataTreeInterface();
            if (dataTreeInterface != null) {
                this.addTab(abstractTable.getGUI_Name(), icon, abstractTable);
            }
        }

        public void cleanUp() {
            if (this.tabChangeListener != null) {
                this.removeChangeListener(this.tabChangeListener);
                this.removeMouseListener(AbstractTabbedTable.this);
                this.tabChangeListener = null;
            }
        }

        public int getMatrixIndex(AbstractDataMatrix abstractDataMatrix) {
            for (int i = 0; i < this.getNumberOfTables(); ++i) {
                AbstractDataTable abstractDataTable = this.getTableEditorAt(i);
                if (abstractDataTable == null || !abstractDataTable.getMatrix().equals(abstractDataMatrix)) continue;
                return i;
            }
            return -1;
        }

        public int getNumberOfTables() {
            return this.getTabCount();
        }

        public AbstractTable getSelectedTableEditor() {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                return this.getTableEditorAt(n);
            }
            return null;
        }

        public AbstractDataTable getTableEditorAt(int n) {
            Component component;
            if (n >= 0 && n < this.getComponentCount() && (component = this.getComponentAt(n)) instanceof AbstractDataTable) {
                return (AbstractDataTable)component;
            }
            return null;
        }

        public int getTableEditorIndex(AbstractTable abstractTable) {
            for (int i = 0; i < this.getNumberOfTables(); ++i) {
                AbstractDataTable abstractDataTable = this.getTableEditorAt(i);
                if (abstractDataTable == null || !abstractDataTable.equals(abstractTable)) continue;
                return i;
            }
            return -1;
        }

        public boolean hasTableEditor(AbstractTable abstractTable) {
            return this.getTableEditorIndex(abstractTable) >= 0;
        }

        public boolean PurgeSignal() {
            for (int i = this.getNumberOfTables() - 1; i >= 0; --i) {
                if (!this.getTableEditorAt(i).getDataTreeInterface().isCleaned()) continue;
                this.removeTabAt(i);
            }
            return this.getNumberOfTables() == 0;
        }

        public void removeTableEditor(AbstractTable abstractTable) {
            this.removeTabAt(this.getTableEditorIndex(abstractTable));
        }

        public void selectTableEditor(AbstractTable abstractTable) {
            int n = this.getTableEditorIndex(abstractTable);
            if (n >= 0) {
                this.setSelectedIndex(n);
            }
        }

        public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
            for (int i = 0; i < this.getNumberOfTables(); ++i) {
                AbstractDataTable abstractDataTable = this.getTableEditorAt(i);
                abstractDataTable.setCreated(abstractWindow_GUI, bl);
                abstractDataTable.setAssociatedFrame(AbstractTabbedTable.this.getAssociatedFrame());
            }
        }

        private class TabChangeListener
        implements ChangeListener {
            private TabChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AbstractTabbedTable.this.window_gui != null) {
                    AbstractTabbedTable.this.window_gui.selectedWindowUpdated(AbstractTabbedTable.this, true);
                }
            }
        }
    }
}

