/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.properties.DataProperties;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindowProperties;

public abstract class AbstractTable
extends AbstractWindow {
    public static final ImageIcon tableIcon = new ImageIcon(Main_GUI.class.getResource("gif/table_layout_button.png"));
    protected DataTreeInterface dti;
    private int defaultCellWidth = 75;

    public AbstractTable(DataInit dataInit) {
        super("AbstractTable", dataInit);
        this.init(dataInit.getDataTreeInterface());
    }

    public AbstractTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        DataTreeInterface dataTreeInterface;
        SimpleTable simpleTable = this.getSimpleTable();
        if (simpleTable != null) {
            simpleTable.setShowGrid(mapProperty.getPropertyBoolean("sgrids", true));
            simpleTable.setCellWidth(mapProperty.getPropertyInt("cellwidth", 50));
            simpleTable.setRowHeight(mapProperty.getPropertyInt("cellheight", 16));
            int n = mapProperty.getPropertyInt("textsize", 11);
            Font font = simpleTable.getFont();
            if (font.getSize() != n) {
                simpleTable.setFont(new Font(font.getFontName(), font.getStyle(), n));
            }
        }
        if ((dataTreeInterface = mapProperty.resolveNodeFromName(randomInputStream, "dti")) == null) {
            throw new IOException("AbstractTable:dti==null");
        }
        this.init(dataTreeInterface);
    }

    public void addDropTarget(DropTargetListener dropTargetListener) {
    }

    public void DataSelected() {
        if (this.window_gui != null) {
            this.window_gui.selectedWindowUpdated(this);
        }
    }

    @Override
    public DataTreeInterface get(String string) {
        if (string.equalsIgnoreCase("data")) {
            return this.dti;
        }
        throw new RuntimeException("No such name: " + string);
    }

    public DataInit getDataInit() {
        return (DataInit)this.init;
    }

    public DataTreeInterface getDataTreeInterface() {
        return this.dti;
    }

    public int getDefaultCellWidth() {
        return this.defaultCellWidth;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return tableIcon;
    }

    public Container getInnerTable() {
        return null;
    }

    @Override
    public byte getNodeType() {
        return 6;
    }

    public List getSelectedValues() {
        return null;
    }

    public SimpleTable getSimpleTable() {
        return null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return 1;
    }

    public void resetToPreferredSizes() {
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyNode("dti", this.dti);
    }

    @Override
    public abstract byte SendGlobalMessage(byte var1, byte var2);

    public void setCellHeight(Double d) {
        SimpleTable simpleTable = this.getSimpleTable();
        if (simpleTable != null) {
            simpleTable.setRowHeight(d.intValue());
        }
    }

    public void setCellWidth(Double d) {
        SimpleTable simpleTable = this.getSimpleTable();
        if (simpleTable != null) {
            simpleTable.setCellWidth(d.intValue());
        }
    }

    public void setDefaultCellWidth(int n) {
        this.defaultCellWidth = n;
    }

    @Override
    public String toString() {
        if (this.dti != null) {
            return this.dti.toString();
        }
        return "Data Table";
    }

    public void UpdateInfo() {
        if (this.window_gui != null) {
            this.window_gui.selectedWindowUpdated(this);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dti = null;
    }

    @Override
    protected AbstractWindowProperties createProperties() {
        return new DataProperties(this);
    }

    @Override
    protected String getHelpID() {
        return "evinceTable2";
    }

    @Override
    protected AbstractInit loadInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return new DataInit(randomInputStream, mapProperty);
    }

    private void init(DataTreeInterface dataTreeInterface) {
        this.dti = dataTreeInterface;
        this.setLayout(new BorderLayout());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTable.this.showSelectionDialog();
            }
        };
        this.registerKeyAction(KeyStroke.getKeyStroke(70, 2), abstractAction);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isContentReady()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(this.getForeground());
            Font font = graphics2D.getFont();
            graphics2D.setFont(new Font(font.getName(), font.getStyle(), 16));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = this.getContentInformation();
            if (string != null) {
                int n = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, this.getWidth() / 2 - n / 2, this.getHeight() / 2);
            }
        } else {
            super.paint(graphics);
        }
    }
}

