/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.Component;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.data.DescriptionLayer;
import se.prediktera.map.data.TableLayer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class DataGroupLayer
extends TableLayer {
    private Object userObject = null;
    private boolean isObsColumn = true;

    public DataGroupLayer(DataTreeInterface dataTreeInterface, boolean bl) {
        this(dataTreeInterface, -1, bl);
    }

    public DataGroupLayer(DataTreeInterface dataTreeInterface, int n, boolean bl) {
        super(0);
        this.isObsColumn = bl;
        this.userObject = n >= 0 && dataTreeInterface instanceof DataGroupValues ? ((DataGroupValues)dataTreeInterface).getInnerColumn(n) : dataTreeInterface;
        this.setLayerVisible(true);
        this.setEnabled(this.userObject instanceof AbstractInnerColumn);
        this.setLayerNode(new DefaultMutableTreeNode(this));
    }

    public DataGroupLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.userObject = mapProperty.resolveNodeFromName(randomInputStream, "uo");
        if (this.userObject == null) {
            this.userObject = mapProperty.resolveNodeFromName(randomInputStream, "cparent");
        }
        if (this.userObject instanceof DataGroupValues && mapProperty.hasProperty("cindx")) {
            this.userObject = ((DataGroupValues)this.userObject).getInnerColumn(mapProperty.getLVInt());
        }
        if (mapProperty.hasProperty("obsc")) {
            this.isObsColumn = mapProperty.getLVBoolean();
        }
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void LoadData(RandomInputStream randomInputStream) throws IOException {
    }

    public void remove() {
        Object object = this.userObject;
        if (object instanceof AbstractInnerColumn) {
            AbstractInnerColumn abstractInnerColumn = (AbstractInnerColumn)object;
            abstractInnerColumn.getParent().removeColumn(abstractInnerColumn);
        }
        this.cleanUp();
    }

    @Override
    public void SaveData(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        Object object;
        if (this.userObject instanceof DataTreeInterface) {
            randomOutputStream.writePropertyNode("uo", (DataTreeInterface)this.userObject);
        }
        if ((object = this.userObject) instanceof AbstractInnerColumn) {
            AbstractInnerColumn abstractInnerColumn = (AbstractInnerColumn)object;
            randomOutputStream.writePropertyNode("cparent", abstractInnerColumn.getParent());
            randomOutputStream.writePropertyInt("cindx", abstractInnerColumn.getParentIndexOf());
        }
        randomOutputStream.writePropertyBoolean("obsc", this.isObsColumn);
    }

    @Override
    public void setCellBackground(Component component, Object object, int n, int n2, int n3, boolean bl) {
        DataTreeInterface dataTreeInterface;
        int n4 = n2;
        if (this.isObsColumn && this.isObs() || !this.isObsColumn && !this.isObs()) {
            n4 = n3;
        }
        if (n4 >= 0 && n4 < this.getTreeNodeCount() && (dataTreeInterface = this.getTreeNodeAt(n4)) instanceof DescriptionLayer) {
            ((DescriptionLayer)dataTreeInterface).setCellBackground(component, object, bl);
            return;
        }
        component.setBackground(CellIdentifierModel.getColorByType(-2));
    }

    @Override
    public void setLayerName(String string) {
        super.setLayerName(string);
        if (this.userObject != null && this.userObject instanceof AbstractInnerColumn) {
            ((AbstractInnerColumn)this.userObject).setName(string);
        }
    }

    @Override
    public String toString() {
        if (this.userObject != null) {
            if (this.userObject instanceof AbstractInnerColumn) {
                return ((AbstractInnerColumn)this.userObject).toString();
            }
            return this.userObject.toString();
        }
        return super.toString();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.userObject = null;
    }

    protected boolean isObs() {
        if (this.userObject instanceof DataGroupValues) {
            return ((DataGroupValues)this.userObject).isObs();
        }
        return this.userObject instanceof ObservationInfo;
    }
}

