/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.Font;
import java.awt.Point;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.fixed.AbstractFixedTable;
import se.prediktera.map.data.fixed.FixedColumnTable;
import se.prediktera.map.data.fixed.FixedCornerTable;
import se.prediktera.map.data.fixed.FixedInterface;
import se.prediktera.map.data.fixed.FixedRowTable;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;

public class DataTable
extends SimpleTable
implements FixedInterface {
    private AbstractFixedTable[] fixedTable = new AbstractFixedTable[3];
    private SimpleTable[] table = new SimpleTable[3];
    private MatrixListener matrixListener = new MatrixListener();

    public DataTable(AbstractSimpleTable abstractSimpleTable, JScrollPane jScrollPane) {
        this(abstractSimpleTable, jScrollPane, true, true);
    }

    public DataTable(AbstractSimpleTable abstractSimpleTable, JScrollPane jScrollPane, boolean bl, boolean bl2) {
        super(jScrollPane, abstractSimpleTable, false, false, true);
        this.fixedTable[1] = new FixedRowTable(abstractSimpleTable, this, jScrollPane, bl);
        this.fixedTable[0] = new FixedColumnTable(abstractSimpleTable, this, jScrollPane);
        this.fixedTable[2] = new FixedCornerTable(abstractSimpleTable, this, jScrollPane, bl);
        this.setDescriptionTables(this.getDescriptionTable(0), this.getDescriptionTable(1), this.getDescriptionTable(2));
        for (int i = 0; i < 3; ++i) {
            if (this.fixedTable[i] == null) continue;
            this.table[i] = this.fixedTable[i].getTable();
        }
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        RightButtonListener rightButtonListener = new RightButtonListener();
        this.addMouseListener(rightButtonListener);
        if (this.table[0] != null) {
            this.table[0].addMouseListener(rightButtonListener);
        }
    }

    @Override
    public void addDropTarget(DropTargetListener dropTargetListener) {
        super.addDropTarget(dropTargetListener);
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].addDropTarget(dropTargetListener);
            }
        }
    }

    @Override
    public void addGlobalMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].addMouseListener(mouseListener);
            }
        }
    }

    @Override
    public void fireColumnChanged() {
        super.fireColumnChanged();
        this.fireFixedTableChanged(false);
    }

    @Override
    public void fireTableChanged() {
        super.fireTableChanged();
        this.fireFixedTableChanged(true);
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].fireTableStructureChanged();
            }
        }
    }

    @Override
    public int getCellWidth() {
        if (this.fixedTable != null && this.fixedTable[0] != null) {
            return this.fixedTable[0].getCellWidth();
        }
        return super.getCellWidth();
    }

    public AbstractFixedTable getFixedTable(int n) {
        if (this.fixedTable == null) {
            return null;
        }
        return this.fixedTable[n];
    }

    @Override
    public String getOrderBy() {
        SimpleTable simpleTable = this.getFixedTable(1).getTable();
        if (simpleTable != null) {
            return simpleTable.getOrderBy();
        }
        return super.getOrderBy();
    }

    @Override
    public String getSortBy() {
        SimpleTable simpleTable = this.getFixedTable(1).getTable();
        if (simpleTable != null) {
            return simpleTable.getSortBy();
        }
        return super.getSortBy();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n >= 0 && n2 >= 0 && this.fixedTable[1] != null) {
            return String.valueOf(this.fixedTable[1].getTable().getValueAt(0, n2));
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public void noSort() {
        if (this.table != null && this.table[1] != null) {
            this.table[1].noSort();
        }
    }

    @Override
    public void removeGlobalMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].removeMouseListener(mouseListener);
            }
        }
    }

    @Override
    public void setCellWidth(int n) {
        if (this.fixedTable != null) {
            if (this.fixedTable[0] != null) {
                this.fixedTable[0].setCellWidth(n);
            }
            super.setCellWidth(n);
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn.getPreferredWidth() != n) {
                tableColumn.setPreferredWidth(n);
            }
            if (tableColumn.getWidth() == n) continue;
            tableColumn.setWidth(n);
        }
    }

    @Override
    public void setCurrentColumn(int n) {
        super.setCurrentColumn(n);
        this.getFixedTable(1).getTable().setCurrentColumnNoPropagate(n);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].setFont(font);
            }
        }
    }

    @Override
    public void setMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        if (this.matrix != null) {
            this.matrix.removeDataTreeChangeListener(this.matrixListener);
        }
        if (abstractDataMatrix != null) {
            abstractDataMatrix.addDataTreeChangeListener(this.matrixListener);
        }
        super.setMatrix(abstractDataMatrix, bl);
    }

    @Override
    public void setModel(SimpleTableModel simpleTableModel) {
        if (this.fixedTable != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.fixedTable[i] == null) continue;
                this.fixedTable[i].setModel(simpleTableModel);
            }
        }
        this.setCellWidth(75);
        super.setModel(simpleTableModel);
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.table != null && this.table[0] != null) {
            this.table[0].setRowHeight(n);
        }
    }

    @Override
    public void setShowGrid(boolean bl) {
        super.setShowGrid(bl);
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].setShowGrid(bl);
            }
        }
    }

    @Override
    public void sort() {
        if (this.table != null && this.table[1] != null) {
            this.table[1].sort();
        }
    }

    @Override
    public void sortAll() {
        if (this.table != null && this.table[1] != null) {
            this.table[1].sortAll();
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.matrix != null) {
            this.matrix.removeDataTreeChangeListener(this.matrixListener);
            this.matrixListener = null;
        }
        super.cleanUpChild();
        if (this.fixedTable != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.fixedTable[i] == null) continue;
                this.fixedTable[i].cleanUp();
            }
        }
        this.fixedTable = null;
        this.table = null;
    }

    private void fireFixedTableChanged(boolean bl) {
        if (this.table != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.table[i] == null) continue;
                this.table[i].fireTableChanged();
                if (i != 1 || !bl) continue;
                this.table[i].sort();
            }
        }
    }

    private ExtendScrollTable getDescriptionTable(int n) {
        if (this.fixedTable == null || this.fixedTable[n] == null) {
            return null;
        }
        return this.fixedTable[n].getColumnTable();
    }

    private class MatrixListener
    implements DataMatrixListener {
        private MatrixListener() {
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
            if (dataMatrixEvent.getDataTreeInterface() instanceof AbstractDataMatrix && dataMatrixEvent.hasStructureChanged()) {
                DataTable.this.fireTableStructureChanged();
            } else {
                DataTable.this.repaint();
            }
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
        }
    }

    private class RightButtonListener
    extends MouseAdapter {
        private RightButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !DataTable.this.isRowSelected(n = DataTable.this.rowAtPoint(mouseEvent.getPoint()))) {
                // empty if block
            }
        }
    }
}

