/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JButton;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.data.DataGroupLayer;
import se.prediktera.map.data.DescriptionPanel;
import se.prediktera.map.data.settings.DataComboBoxColor;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public class DescriptionLayer
extends DataGroupLayer
implements SettingsBoxInterface {
    private DataComboBoxColor colorBox;
    private DescriptionPanel panel = null;

    public DescriptionLayer(Description description, int n, AbstractDataMatrix abstractDataMatrix) {
        super(description, n, true);
        this.initLayer(abstractDataMatrix);
    }

    public DescriptionLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.initLayer(null);
        mapProperty.setPrefix("col");
        this.colorBox.LoadProperty(randomInputStream, mapProperty);
        mapProperty.setPrefix("");
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.setPrefix("col");
        this.colorBox.SaveProperty(randomOutputStream);
        randomOutputStream.setPrefix("");
    }

    public void setCellBackground(Component component, Object object, boolean bl) {
        this.colorBox.setCellBackground(component, object, bl);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.colorBox.setCreated(abstractWindow_GUI, bl);
        if (this.panel != null && this.getUserObject() instanceof InnerColumnString) {
            this.panel.fillColumn((InnerColumnString)this.getUserObject());
        }
    }

    public void setFixedColor(Color color) {
        this.colorBox.setFixedColor(color);
    }

    public void setPanel(DescriptionPanel descriptionPanel) {
        this.panel = descriptionPanel;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.colorBox != null) {
            this.colorBox.cleanUp();
            this.colorBox = null;
        }
    }

    private void initLayer(AbstractDataMatrix abstractDataMatrix) {
        this.colorBox = new DataComboBoxColor(abstractDataMatrix, this);
        this.colorBox.addItem(new ComboItem("[FIXED]", 1));
        JButton jButton = new JButton("Set as primary");
        jButton.addActionListener(actionEvent -> {
            InnerColumnString innerColumnString = (InnerColumnString)this.getUserObject();
            if (!innerColumnString.isPrimary()) {
                innerColumnString.getParent().beginUpdate();
                innerColumnString.setParentPrimary();
                innerColumnString.endUpdate();
            }
        });
        this.add(jButton);
    }
}

