/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.fixed.FixedTableCellRenderer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableScrollTable;

public class SimpleTable
extends ExtendSortableScrollTable {
    protected SimpleTableModel simpleModel;
    protected AbstractDataMatrix matrix;
    private boolean interactive = false;
    private final boolean hasinteraction;
    private AbstractSimpleTable abstractTable;

    public SimpleTable(JScrollPane jScrollPane, AbstractSimpleTable abstractSimpleTable, boolean bl, boolean bl2, boolean bl3) {
        super(jScrollPane, true, false, bl, bl2);
        this.abstractTable = abstractSimpleTable;
        this.hasinteraction = bl3;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setAutoResizeMode(0);
        this.setGridColor(Color.lightGray);
        this.setShowHorizontalLines(true);
        this.setMatrix(null);
        this.setCellSelectionEnabled(true);
        this.setDefaultRenderer(String.class, new CustomTableCellRenderer());
        this.addKeyListener(new KeyClass());
        if (bl3) {
            SelectionListener selectionListener = new SelectionListener();
            this.getSelectionModel().addListSelectionListener(selectionListener);
            this.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        }
    }

    public TableColumn addColumn(int n) {
        return super.addColumn(n, this.abstractTable.getDefaultCellWidth());
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new CMenuItem("Properties", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleTable.this.abstractTable.showProperties();
            }
        });
        return true;
    }

    public void beginInteraction() {
        this.interactive = true;
    }

    public FixedTableCellRenderer createFixedTableCellRenderer() {
        return new FixedTableCellRenderer();
    }

    public void endInteraction() {
        this.interactive = false;
    }

    public void fireColumnChanged() {
        if (this.rowHeader != null) {
            this.rowHeader.invalidate();
            this.rowHeader.repaint();
        }
        if (this.colHeader != null) {
            this.colHeader.repaint();
        }
        this.simpleModel.fireTableStructureChanged(this);
        if (this.colHeader != null) {
            this.updateColumnRenderer();
        }
        this.revalidate();
        this.repaint();
    }

    public void fireTableChanged() {
        if (this.rowHeader != null) {
            this.rowHeader.invalidate();
            this.rowHeader.repaint();
        }
        if (this.colHeader != null) {
            this.colHeader.repaint();
        }
        this.simpleModel.fireTableDataChanged();
        if (this.colHeader != null) {
            this.updateColumnRenderer();
        }
        this.revalidate();
        this.repaint();
    }

    public void fireTableStructureChanged() {
        this.simpleModel.fireTableStructureChanged(this);
        this.fireTableChanged();
    }

    public AbstractSimpleTable getAbstractTable() {
        return this.abstractTable;
    }

    public int getCellWidth() {
        return 16;
    }

    public byte getColumnType(int n) {
        return this.simpleModel.getColumnType(n);
    }

    public AbstractDataMatrix getMatrix() {
        return this.matrix;
    }

    public String getOrderBy() {
        if (this.isAscending()) {
            return "Ascending";
        }
        return "Descending";
    }

    public byte getRowType(int n) {
        return this.simpleModel.getRowType(n);
    }

    public SimpleTableModel getSimpleTableModel() {
        return this.simpleModel;
    }

    public String getSortBy() {
        if (this.getSortCol() < 0) {
            return "Index";
        }
        if (this.isDescription()) {
            return "Identifier " + (this.getSortCol() + 1);
        }
        return String.valueOf(this.getValueAt(0, this.getSortCol()));
    }

    public boolean isObsColumn() {
        return this.simpleModel.isObsColumn();
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextField) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    public void setCellWidth(int n) {
        if (this.abstractTable != null) {
            this.abstractTable.resetToPreferredSizes();
        }
    }

    public void setMatrix(AbstractDataMatrix abstractDataMatrix) {
        this.setMatrix(abstractDataMatrix, true);
    }

    public void setMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        this.matrix = abstractDataMatrix;
        if (abstractDataMatrix == null) {
            this.clearTable();
            this.setCanPaste(false);
        } else {
            if (bl) {
                this.setModel(abstractDataMatrix.createTableModel(false));
            }
            this.setCanPaste(!abstractDataMatrix.isProtected());
        }
    }

    public void setModel(SimpleTableModel simpleTableModel) {
        this.simpleModel = simpleTableModel;
        super.setModel(simpleTableModel);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.abstractTable = null;
        this.matrix = null;
    }

    private void clearTable() {
        this.setModel(new SimpleTableModel(null, 0, 0, false){

            @Override
            public Object getValueAt_Sort(int n, int n2) {
                return "";
            }

            @Override
            public void setValueAt_Sort(Object object, int n, int n2) {
            }

            @Override
            protected int getColumnDescriptionCountInternal() {
                return 0;
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return 0;
            }
        });
    }

    public class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            byte by = SimpleTable.this.simpleModel.getTypeAt(n, n2);
            if (bl) {
                component.setBackground(jTable.getSelectionBackground());
                component.setForeground(jTable.getSelectionForeground());
            } else {
                component.setBackground(CellIdentifierModel.getColorByType(by));
                component.setForeground(Color.black);
            }
            if (by == 4 || by == 10 || by == 16) {
                String string = object.toString();
                try {
                    if (string.length() > 0) {
                        this.setText(NiceDataFormat.toString(Double.parseDouble(string)));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setText(string);
                }
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return component;
        }
    }

    class KeyClass
    implements KeyListener {
        KeyClass() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (SimpleTable.this.matrix == null || SimpleTable.this.matrix.isProtected()) {
                return;
            }
            if (keyEvent.getKeyCode() == 127) {
                int[] nArray = SimpleTable.this.getSelectedColumns();
                int[] nArray2 = SimpleTable.this.getSelectedRows();
                SimpleTable.this.matrix.beginUpdate();
                for (int n : nArray2) {
                    for (int n2 : nArray) {
                        SimpleTable.this.matrix.setValue(n, n2, 0.0, true);
                    }
                }
                SimpleTable.this.matrix.endUpdate();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SimpleTable.this.abstractTable != null && SimpleTable.this.abstractTable.getSimpleTable() != null) {
                ListSelectionModel listSelectionModel = SimpleTable.this.getSelectionModel();
                if (SimpleTable.this.hasinteraction && !SimpleTable.this.interactive && !listSelectionEvent.getValueIsAdjusting() && listSelectionModel != null) {
                    SimpleTable.this.abstractTable.interactiveSelection();
                }
            }
        }
    }
}

