/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.SparseMatrix;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableTableModel;

public abstract class SimpleTableModel
extends ExtendSortableTableModel
implements DataTreeListener {
    private AbstractDataMatrix matrix;
    private boolean includeIdentifiers = true;

    public static Double parseObject(Object object) {
        try {
            if (object.toString().length() == 0) {
                return null;
            }
            String string = object.toString().replace(',', '.');
            Double d = Double.valueOf(string);
            if (d.isInfinite() || d.isNaN()) {
                return null;
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public SimpleTableModel(AbstractDataMatrix abstractDataMatrix, int n, int n2, boolean bl) {
        super(n, n2, bl);
        this.matrix = abstractDataMatrix;
        if (abstractDataMatrix != null) {
            abstractDataMatrix.addDataTreeChangeListener(this);
        }
    }

    public void beginCalculations() {
        if (this.matrix != null) {
            this.matrix.beginCalculations();
        }
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.matrix != null) {
            this.matrix.removeDataTreeChangeListener(this);
            this.matrix = null;
        }
    }

    public void endCalculations() {
        if (this.matrix != null) {
            this.matrix.endCalculations();
        }
    }

    @Override
    public void eventFinished(DataTreeEvent dataTreeEvent) {
    }

    public void fireTableStructureChanged(SimpleTable simpleTable) {
        block7: {
            if (this.matrix == null || this.matrix instanceof SparseMatrix) break block7;
            int n = simpleTable.getColumnModel().getColumnCount();
            if (this.transpose && !(this.matrix instanceof ModelMatrix)) {
                this.columns = this.matrix.getN();
                this.rows = this.matrix.getK();
            } else {
                this.rows = this.matrix.getN();
                this.columns = this.matrix.getK();
            }
            int n2 = this.getColumnCount();
            if (n2 != n) {
                if (n2 > n) {
                    for (int i = n; i < n2; ++i) {
                        simpleTable.addColumn(i);
                    }
                } else {
                    for (int i = n2; i < n; ++i) {
                        simpleTable.removeColumn(simpleTable.getColumnModel().getColumn(n2));
                    }
                }
            }
        }
    }

    public String getColumnDescription(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int[] nArray = this.getRowIndex();
        if (nArray != null && n < nArray.length) {
            n = nArray[n];
        }
        if (this.transpose) {
            return this.matrix.getColumnDescription(n, n2);
        }
        return this.matrix.getRowDescription(n, n2);
    }

    public int getColumnDescriptionCount() {
        if (!this.includeIdentifiers) {
            return 0;
        }
        if (this.transpose) {
            return this.getRowDescriptionCountInternal();
        }
        return this.getColumnDescriptionCountInternal();
    }

    public String getColumnDescriptionSorted(int n, int n2) {
        return this.getColumnDescription(this.getSortIndexForRow(n), n2);
    }

    public int getColumnType() {
        if (this.transpose) {
            return this.matrix.getRowType();
        }
        return this.matrix.getColumnType();
    }

    public byte getColumnType(int n) {
        if (this.matrix == null) {
            return 4;
        }
        if (this.transpose) {
            return this.matrix.getRowType(n);
        }
        return this.matrix.getColumnType(n);
    }

    public int getDataCol(int n) {
        int[] nArray = this.getColumnIndex();
        if (nArray != null) {
            if (n < nArray.length) {
                return nArray[n];
            }
            return -1;
        }
        return n;
    }

    public int getDataRow(int n) {
        n = this.getSortIndexForRow(n);
        int[] nArray = this.getRowIndex();
        if (nArray != null) {
            if (n < nArray.length) {
                return nArray[n];
            }
            return -1;
        }
        return n;
    }

    public double getDataValueAt(int n, int n2) {
        if (this.transpose) {
            return this.matrix.getValue(n2, n);
        }
        return this.matrix.getValue(n, n2);
    }

    @Override
    public FastDecimal getDoubleAt_Transpose_Sort(int n, int n2, FastDecimal fastDecimal) {
        if (this.matrix != null) {
            if (this.matrix.isMissing(n, n2)) {
                fastDecimal.error();
            } else {
                fastDecimal.setValue(this.matrix.getValue(n, n2));
            }
        }
        return fastDecimal;
    }

    public int getGroupID() {
        if (this.matrix != null) {
            return this.matrix.getGroupID();
        }
        return 0;
    }

    public int[] getGroupRow(int[] nArray) {
        if (this.matrix != null) {
            return this.matrix.getGroup(nArray);
        }
        return null;
    }

    public AbstractDataMatrix getMatrix() {
        return this.matrix;
    }

    public AbstractDataInfo getPrimaryDataInfo() {
        AbstractDataInfo abstractDataInfo = null;
        if (this.matrix != null) {
            if (this.matrix.getDataType() == 1) {
                abstractDataInfo = this.matrix.getDataInfo(0);
            } else if (this.matrix.getDataType() == 2) {
                abstractDataInfo = this.matrix.getDataInfo(1);
            }
        }
        return abstractDataInfo;
    }

    public int[] getPrimaryRef() {
        if (this.matrix != null) {
            if (this.transpose) {
                return this.matrix.getKref();
            }
            return this.matrix.getNref();
        }
        return null;
    }

    public int[] getRef(boolean bl) {
        if (this.matrix == null) {
            return null;
        }
        if (bl ^ this.transpose) {
            return this.matrix.getNref();
        }
        return this.matrix.getKref();
    }

    public String getRowDescription(int n, int n2) {
        if (this.matrix == null) {
            return "";
        }
        int[] nArray = this.getColumnIndex();
        if (nArray != null && n2 < nArray.length) {
            n2 = nArray[n2];
        }
        if (this.transpose) {
            return this.matrix.getRowDescription(n2, n);
        }
        return this.matrix.getColumnDescription(n2, n);
    }

    public int getRowDescriptionCount() {
        if (!this.includeIdentifiers) {
            return 0;
        }
        if (this.transpose) {
            return this.getColumnDescriptionCountInternal();
        }
        return this.getRowDescriptionCountInternal();
    }

    public String getRowDescriptionTitle(int n) {
        return this.matrix.getRowDescriptionTitle(n);
    }

    public int getRowType() {
        if (this.transpose) {
            return this.matrix.getColumnType();
        }
        return this.matrix.getRowType();
    }

    public byte getRowType(int n) {
        if (this.matrix == null) {
            return 4;
        }
        if (this.transpose) {
            return this.matrix.getColumnType(n);
        }
        return this.matrix.getRowType(n);
    }

    @Override
    public byte getTypeAt(int n, int n2) {
        if (this.matrix == null) {
            return 4;
        }
        n = this.getDataRow(n);
        n2 = this.getDataCol(n2);
        if (this.transpose) {
            return this.matrix.getTypeAt(n2, n);
        }
        return this.matrix.getTypeAt(n, n2);
    }

    @Override
    public Object getValueAt_Sort(int n, int n2) {
        if (this.matrix != null) {
            if (this.matrix.isMissing(n, n2)) {
                return "MV";
            }
            return String.valueOf(this.matrix.getValue(n, n2));
        }
        return "";
    }

    public boolean hasInteraction(int n) {
        if (this.matrix == null) {
            return false;
        }
        return (this.matrix.getMatrixTag() & n) == n;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.matrix != null) {
            return !this.matrix.isProtected();
        }
        return false;
    }

    public boolean isDescriptionEditable(int n, int n2) {
        return this.isCellEditable(n, n2);
    }

    public boolean isGroup() {
        if (this.matrix != null) {
            return this.matrix.isGroup();
        }
        return false;
    }

    public boolean isIncludeIdentifiers() {
        return this.includeIdentifiers;
    }

    public boolean isObsColumn() {
        boolean bl = true;
        if (this.matrix != null) {
            bl = this.matrix.isObsN();
        }
        if (this.transpose) {
            bl = !bl;
        }
        return bl;
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        this.matrix = (AbstractDataMatrix)dataTreeEvent.getReplaceDataTreeInterface();
    }

    @Override
    public void propertyChanged(DataTreeEvent dataTreeEvent) {
    }

    public void setColumnDescription(int n, int n2, String string) {
        if (n >= 0 && n2 >= 0) {
            int[] nArray = this.getRowIndex();
            if (nArray != null && n < nArray.length) {
                n = nArray[n];
            }
            if (this.transpose) {
                this.matrix.setKInfo(n, n2, string);
            }
            this.matrix.setNInfo(n, n2, string);
        }
    }

    public void setColumnDescriptionSorted(int n, int n2, String string) {
        this.setColumnDescription(this.getSortIndexForRow(n), n2, string);
    }

    public void setIncludeIdentifiers(boolean bl) {
        this.includeIdentifiers = bl;
    }

    public void setRowDescription(int n, int n2, String string) {
        int[] nArray = this.getColumnIndex();
        if (nArray != null && n2 < nArray.length) {
            n2 = nArray[n2];
        }
        if (this.transpose) {
            this.matrix.setNInfo(n2, n, string);
        }
        this.matrix.setKInfo(n2, n, string);
    }

    public void setRowDescriptionTitle(int n, String string) {
        this.matrix.setRowDescriptionTitle(n, string);
    }

    @Override
    public void setValueAt_Sort(Object object, int n, int n2) {
        Double d = SimpleTableModel.parseObject(object);
        this.matrix.setValue(n, n2, d == null ? 0.0 : d, d == null);
    }

    public String toString() {
        if (this.matrix != null) {
            return this.matrix.toString();
        }
        return super.toString();
    }

    protected abstract int getColumnDescriptionCountInternal();

    protected abstract int getRowDescriptionCountInternal();
}

