/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data;

import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public abstract class TableModelWithNonData
extends SimpleTableModel {
    private final int firstDataColumn;
    private final byte[] nonDataTypes;
    private final Class[] nonDataClasses;
    private final String[] nonDataDescriptions;

    public TableModelWithNonData(AbstractDataMatrix abstractDataMatrix, int n, int n2, boolean bl, int n3) {
        super(abstractDataMatrix, n, n2, bl);
        this.firstDataColumn = n3;
        this.nonDataTypes = new byte[n3];
        this.nonDataClasses = new Class[n3];
        this.nonDataDescriptions = new String[n3];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n < this.firstDataColumn) {
            return this.nonDataClasses[n];
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        if (this.transpose) {
            if (this.rowIndex != null) {
                return this.rowIndex.length;
            }
            return this.rows;
        }
        if (this.columnIndex != null) {
            return this.columnIndex.length + this.firstDataColumn;
        }
        return this.columns + this.firstDataColumn;
    }

    @Override
    public FastDecimal getDoubleAt(int n, int n2) {
        if (n2 < this.firstDataColumn) {
            return this.fastDecimal.error();
        }
        return super.getDoubleAt(n, n2 - this.firstDataColumn);
    }

    @Override
    public int getOrigColumnCount() {
        if (this.transpose) {
            return this.rows + this.firstDataColumn;
        }
        return this.columns + this.firstDataColumn;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        if (n2 < this.firstDataColumn) {
            return this.nonDataDescriptions[n2];
        }
        return super.getRowDescription(n, n2 - this.firstDataColumn);
    }

    @Override
    public byte getTypeAt(int n, int n2) {
        if (n2 < this.firstDataColumn) {
            return this.nonDataTypes[n2];
        }
        return super.getTypeAt(n, n2 - this.firstDataColumn);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 < this.firstDataColumn) {
            return this.getNonDataValueAt(n, n2);
        }
        return super.getValueAt(n, n2 - this.firstDataColumn);
    }

    public void setNonDataColumn(int n, byte by, Class clazz, String string) {
        this.nonDataTypes[n] = by;
        this.nonDataClasses[n] = clazz;
        this.nonDataDescriptions[n] = string;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 < this.firstDataColumn) {
            return;
        }
        super.setValueAt(object, n, n2 - this.firstDataColumn);
    }

    protected Object getNonDataValueAt(int n, int n2) {
        return "NONDATACOLUMN";
    }
}

