/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.treetable.TreeTableModel;
import se.prediktera.map.data.DataGroupLayer;
import se.prediktera.map.data.DescriptionLayer;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.datasettable.ObservationSettings;
import se.prediktera.map.data.datasettable.VariableSettings;
import se.prediktera.map.data.datasettable.table.DataControlTable;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoListener;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.datasetcontainer.transform.wizard.TransformationWizard;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.main.layer.LayerContainer;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractSettings
extends AbstractLayerPanel
implements DataInfoListener {
    protected Project_GUI project_gui;
    protected DataSet dataSet;
    protected ObservationInfo observationsInfo;
    protected VariablesInfo variablesInfo = null;
    protected DataControlTable curTable = null;
    protected boolean variable = this instanceof VariableSettings;

    public AbstractSettings(DataSet dataSet, DataControlTable dataControlTable) {
        super(dataControlTable.getAbstractTable(), new String[]{"V", "Name"}, false);
        AbstractDataInfo abstractDataInfo;
        this.dataSet = dataSet;
        this.curTable = dataControlTable;
        AbstractDataInfo[] abstractDataInfoArray = dataSet.getDataInfo();
        if (abstractDataInfoArray != null) {
            this.observationsInfo = (ObservationInfo)abstractDataInfoArray[0];
            this.variablesInfo = (VariablesInfo)abstractDataInfoArray[1];
        }
        if ((abstractDataInfo = this.getInfo()) != null) {
            abstractDataInfo.addListener(this);
            for (AbstractTransform.Type type : AbstractTransform.Type.values()) {
                LayerContainer layerContainer = (LayerContainer)abstractDataInfo.getTransformationNode(type);
                DefaultMutableTreeNode defaultMutableTreeNode = layerContainer.getLayerNode();
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(layerContainer);
                    layerContainer.setLayerNode(defaultMutableTreeNode);
                    layerContainer.setLayerVisible(true);
                    this.addChildrenToTree(layerContainer, defaultMutableTreeNode);
                }
                this.rootNode.add(defaultMutableTreeNode);
            }
            this.addLayersFromDataInfo(abstractDataInfo, dataControlTable.getMatrix(), dataControlTable.isObsColumn());
        }
        this.updateTable();
        this.layerTreeTable.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.layerTreeTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.layerTreeTable.getColumnModel().getColumn(1).setPreferredWidth(80);
    }

    public void addLayer(AbstractLayer abstractLayer) {
        this.addLayer(abstractLayer, null);
    }

    public void addLayer(AbstractLayer abstractLayer, ProgressManager progressManager) {
        if (abstractLayer instanceof DataGroupLayer) {
            AbstractDataInfo abstractDataInfo = this.getInfo();
            abstractLayer.setCreated(this.getGUI(), false);
            Description description = (Description)abstractDataInfo.getGroupColumnByType(0);
            int n = this.rootNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                if (!(defaultMutableTreeNode.getUserObject() instanceof DataGroupLayer) || ((DataGroupLayer)defaultMutableTreeNode.getUserObject()).getUserObject() != description) continue;
                defaultMutableTreeNode.add(abstractLayer.getLayerNode());
                this.updateTable();
                return;
            }
        } else if (abstractLayer instanceof AbstractTransform) {
            this.addLayer((AbstractTransform)abstractLayer);
        }
    }

    public void addLayer(AbstractTransform abstractTransform) {
        this.addLayer(abstractTransform, null);
    }

    public void addLayer(AbstractTransform abstractTransform, ProgressManager progressManager) {
        if (abstractTransform != null) {
            AbstractDataInfo abstractDataInfo = this.getInfo();
            abstractTransform.setCreated(this.project_gui, abstractDataInfo);
            LayerContainer layerContainer = (LayerContainer)abstractDataInfo.getTransformationNode(abstractTransform.getTransformationType());
            abstractTransform.setLayerVisible(layerContainer.isLayerVisible());
            AbstractSettings.addSortedToPriority(layerContainer, abstractTransform);
            DataInfoEvent dataInfoEvent = new DataInfoEvent(abstractDataInfo, 0, abstractTransform, null, progressManager);
            if (abstractTransform.getTransformationType() == AbstractTransform.Type.globalAdd) {
                this.dataSet.triggetDataInfoEvent(dataInfoEvent);
            } else {
                abstractDataInfo.triggerEvent(dataInfoEvent);
            }
        }
    }

    public static void addSortedToPriority(LayerContainer layerContainer, AbstractTransform abstractTransform) {
        int n = layerContainer.getTreeNodeCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (layerContainer.getTreeNodeAt(i) instanceof AbstractTransform && ((AbstractTransform)layerContainer.getTreeNodeAt(i)).getPriority() < abstractTransform.getPriority()) {
                    layerContainer.insertTreeNode(abstractTransform, i);
                    break;
                }
                if (i != n - 1) continue;
                layerContainer.addTreeNode(abstractTransform);
            }
        } else {
            layerContainer.addTreeNode(abstractTransform);
        }
    }

    @Override
    public AbstractLayer addLayer(boolean bl) {
        this.addLayerFromWizard(null);
        return null;
    }

    public void addLayerFromWizard(String string) {
        TransformationWizard transformationWizard = new TransformationWizard(this.variable, this.dataSet);
        int n = 0;
        if (string != null) {
            transformationWizard.selectWizardType(string);
            n = 1;
        }
        if (transformationWizard.executeWizard(n) == 1) {
            transformationWizard.createLayers(this, this.dataSet.getOriginalMatrix(), this instanceof ObservationSettings, this.getInfo());
        }
        transformationWizard.cleanUp();
    }

    public void addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        AbstractLayer abstractLayer = this.getSelectedLayer();
        if (abstractLayer != null) {
            abstractLayer.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        }
    }

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        Serializable serializable = dataInfoEvent.getT1();
        if (serializable instanceof AbstractTransform) {
            AbstractTransform abstractTransform = (AbstractTransform)serializable;
            serializable = this.getInfo();
            AbstractDataInfo abstractDataInfo = abstractTransform.getDataInfo();
            if (abstractDataInfo == null || abstractDataInfo.getGroupID() == ((AbstractDataInfo)serializable).getGroupID()) {
                switch (dataInfoEvent.getType()) {
                    case 0: {
                        if (this.getNodeForLayer(dataInfoEvent.getT1()) != null) break;
                        this.addSubLayerIntern((LayerContainer)((AbstractDataInfo)serializable).getTransformationNode(abstractTransform.getTransformationType()), abstractTransform, abstractTransform.isLayerVisible());
                        break;
                    }
                    case 1: {
                        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForLayer(abstractTransform);
                        if (defaultMutableTreeNode == null) break;
                        this.removeRecursive(defaultMutableTreeNode);
                        break;
                    }
                }
            }
        }
        boolean bl = true;
        if (dataInfoEvent instanceof DataInfoClassEvent && ((DataInfoClassEvent)dataInfoEvent).getChangeType() == 2) {
            bl = false;
        }
        if (bl) {
            this.updateTable();
        }
        return true;
    }

    public AbstractDataInfo getInfo() {
        if (this.variable) {
            return this.variablesInfo;
        }
        return this.observationsInfo;
    }

    public AbstractTransform getLayerWithColumn(AbstractInnerColumn abstractInnerColumn) {
        return this.getLayerWithColumn(this.getInfo().getTransformationNode(), abstractInnerColumn);
    }

    public AbstractTransform getLayerWithColumn(DataTreeInterface dataTreeInterface, AbstractInnerColumn abstractInnerColumn) {
        int n = dataTreeInterface.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            AbstractTransform abstractTransform;
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (dataTreeInterface2 instanceof AbstractTransform && (abstractTransform = (AbstractTransform)dataTreeInterface2).getInnerColumn() == abstractInnerColumn) {
                return abstractTransform;
            }
            abstractTransform = this.getLayerWithColumn(dataTreeInterface2, abstractInnerColumn);
            if (abstractTransform == null) continue;
            return abstractTransform;
        }
        return null;
    }

    public void handleStatus() {
        boolean bl = !this.dataSet.isProtected();
        this.setAllEnabled(bl);
        this.setNodeEnabled(this.rootNode, bl);
    }

    @Override
    public void layerRemoved(AbstractLayer abstractLayer, boolean bl) {
        if (abstractLayer instanceof AbstractTransform) {
            ((AbstractTransform)abstractLayer).remove();
        } else if (abstractLayer instanceof DataGroupLayer) {
            DefaultMutableTreeNode defaultMutableTreeNode = abstractLayer.getLayerNode();
            if (defaultMutableTreeNode != null) {
                ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).remove(defaultMutableTreeNode);
            }
            ((DataGroupLayer)abstractLayer).remove();
            this.updateTable();
        }
    }

    @Override
    public void layerSelected(AbstractLayer abstractLayer) {
    }

    @Override
    public void layerVisibleChanged(AbstractLayer abstractLayer) {
        if (abstractLayer instanceof AbstractTransform) {
            AbstractTransform abstractTransform = (AbstractTransform)abstractLayer;
            DataInfoEvent dataInfoEvent = new DataInfoEvent(this.getInfo(), 4, abstractTransform);
            if (abstractTransform.getTransformationType() == AbstractTransform.Type.globalAdd) {
                this.getInfo().triggerGlobalEvent(dataInfoEvent);
            } else {
                this.getInfo().triggerEvent(dataInfoEvent);
            }
        } else if (abstractLayer instanceof LayerContainer) {
            DataInfoEvent dataInfoEvent = new DataInfoEvent(this.getInfo(), 4);
            if (((LayerContainer)abstractLayer).getTransformationType() == AbstractTransform.Type.globalAdd) {
                this.getInfo().triggerGlobalEvent(dataInfoEvent);
            } else {
                this.getInfo().triggerEvent(dataInfoEvent);
            }
        }
    }

    public boolean selectLayerWithColumn(AbstractInnerColumn abstractInnerColumn) {
        AbstractTransform abstractTransform = this.getLayerWithColumn(abstractInnerColumn);
        if (abstractTransform != null) {
            this.selectLayer(abstractTransform);
            return true;
        }
        this.layerTreeTable.clearSelection();
        return false;
    }

    public void setCreated(DataSetTable dataSetTable, boolean bl) {
        this.project_gui = dataSetTable.getProject_GUI();
        this.setWindow(this.curTable.getAbstractTable());
        Data_GUI data_GUI = this.project_gui.getData_GUI();
        for (int i = 0; i < this.window.getTreeNodeCount(); ++i) {
            if (!(this.window.getTreeNodeAt(i) instanceof AbstractLayer)) continue;
            ((AbstractLayer)this.window.getTreeNodeAt(i)).setCreated(data_GUI, bl);
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.layerTreeTable != null) {
            this.layerTreeTable.cleanUp();
            this.layerTreeTable = null;
        }
        this.dataSet = null;
        this.project_gui = null;
        if (this.getInfo() != null) {
            this.getInfo().removeListener(this);
        }
        this.observationsInfo = null;
        this.variablesInfo = null;
        this.curTable = null;
    }

    @Override
    protected Class[] getCTypes() {
        return new Class[]{AbstractLayerPanel.VisibleTableCellRenderer.class, TreeTableModel.class};
    }

    protected void moveLayerDown_actionPerformed(ActionEvent actionEvent) {
        AbstractLayer abstractLayer = this.getSelectedLayer();
        if (!(abstractLayer instanceof AbstractTransform)) {
            return;
        }
        AbstractTransform abstractTransform = (AbstractTransform)abstractLayer;
        DataTreeInterface dataTreeInterface = this.getInfo().getTransformationNode(abstractTransform.getTransformationType());
        if (dataTreeInterface != null) {
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount() - 1; ++i) {
                if (!dataTreeInterface.getTreeNodeAt(i).equals(abstractTransform)) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = abstractTransform.getLayerNode();
                TreeNode treeNode = defaultMutableTreeNode.getParent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) break;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode;
                if (i < defaultMutableTreeNode2.getChildCount() - 2) {
                    defaultMutableTreeNode2.insert(defaultMutableTreeNode, i + 1);
                } else {
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                }
                dataTreeInterface.swapNodes(i, i + 1);
                this.updateTable();
                this.repaintLayers();
                DataInfoEvent dataInfoEvent = new DataInfoEvent(this.getInfo(), 5, abstractTransform, (AbstractTransform)dataTreeInterface.getTreeNodeAt(i + 1));
                if (abstractTransform.getTransformationType() == AbstractTransform.Type.globalAdd) {
                    this.getInfo().triggerGlobalEvent(dataInfoEvent);
                    break;
                }
                this.getInfo().triggerEvent(dataInfoEvent);
                break;
            }
        }
        this.curTable.fireUpdate();
    }

    protected void moveLayerUp_actionPerformed(ActionEvent actionEvent) {
        AbstractLayer abstractLayer = this.getSelectedLayer();
        if (!(abstractLayer instanceof AbstractTransform)) {
            return;
        }
        AbstractTransform abstractTransform = (AbstractTransform)abstractLayer;
        DataTreeInterface dataTreeInterface = this.getInfo().getTransformationNode(abstractTransform.getTransformationType());
        if (dataTreeInterface != null) {
            for (int i = 1; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                if (!dataTreeInterface.getTreeNodeAt(i).equals(abstractTransform)) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = abstractTransform.getLayerNode();
                TreeNode treeNode = defaultMutableTreeNode.getParent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) break;
                ((DefaultMutableTreeNode)treeNode).insert(defaultMutableTreeNode, i - 1);
                dataTreeInterface.swapNodes(i, i - 1);
                this.updateTable();
                this.repaintLayers();
                DataInfoEvent dataInfoEvent = new DataInfoEvent(this.getInfo(), 5, abstractTransform, (AbstractTransform)dataTreeInterface.getTreeNodeAt(i - 1));
                if (abstractTransform.getTransformationType() == AbstractTransform.Type.globalAdd) {
                    this.getInfo().triggerGlobalEvent(dataInfoEvent);
                    break;
                }
                this.getInfo().triggerEvent(dataInfoEvent);
                break;
            }
        }
        this.curTable.fireUpdate();
    }

    @Override
    protected String newLayerTooltip() {
        return "New modification";
    }

    @Override
    protected String removeLayerTooltip() {
        return "Delete modification";
    }

    @Override
    protected String renameLayerTooltip() {
        return "Rename modification";
    }

    @Override
    protected void repaintLayers() {
    }

    private void addChildrenToTree(DataTreeInterface dataTreeInterface, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (!(dataTreeInterface2 instanceof AbstractLayer)) continue;
            AbstractLayer abstractLayer = (AbstractLayer)dataTreeInterface2;
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof AbstractLayer) {
                AbstractLayer abstractLayer2 = (AbstractLayer)object;
                this.addChildrenToTree(dataTreeInterface2, this.addSubLayerIntern(abstractLayer2, abstractLayer, abstractLayer.isLayerVisible()));
                continue;
            }
            this.addChildrenToTree(dataTreeInterface2, this.addLayerIntern(abstractLayer, null, abstractLayer.isLayerVisible()));
        }
    }

    private void addLayersFromDataInfo(AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix, boolean bl) {
        Description description = (Description)abstractDataInfo.getGroupColumnByType(0);
        DataGroupLayer dataGroupLayer = new DataGroupLayer(description, bl);
        this.rootNode.add(dataGroupLayer.getLayerNode());
        this.window.addTreeNode(dataGroupLayer);
        if (description != null) {
            for (int i = 0; i < description.getColumnCount(); ++i) {
                DescriptionLayer descriptionLayer = new DescriptionLayer(description, i, abstractDataMatrix);
                Color color = CellIdentifierModel.getColorByType(description.isObs() ? 1 : 0);
                descriptionLayer.setFixedColor(color);
                dataGroupLayer.getLayerNode().add(descriptionLayer.getLayerNode());
                dataGroupLayer.addTreeNode(descriptionLayer);
            }
        }
    }

    private void setNodeEnabled(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof AbstractTransform && ((AbstractTransform)object).getTransformationType() != AbstractTransform.Type.globalAdd) {
            ((AbstractTransform)object).setEnabled(bl);
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.setNodeEnabled((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), bl);
        }
    }
}

