/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable;

import javax.swing.ImageIcon;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.data.datasettable.table.DataControlTable;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;

public class AbstractSettingsToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private final JFlatButton buttonInclude = new JFlatButton();
    private final JFlatButton buttonExclude = new JFlatButton();
    protected DataControlTable curTable = null;
    protected DataSet dataSet;

    public AbstractSettingsToolbar(DataControlTable dataControlTable, DataSet dataSet) {
        this.curTable = dataControlTable;
        this.dataSet = dataSet;
        this.buttonInclude.setToolTipText("Include Selected Rows");
        this.buttonInclude.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/inc.png")));
        this.buttonInclude.addActionListener(actionEvent -> this.includeExclude(true));
        this.buttonExclude.setToolTipText("Exclude Selected Rows");
        this.buttonExclude.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/exc.png")));
        this.buttonExclude.addActionListener(actionEvent -> this.includeExclude(false));
        this.setBorder(null);
        this.setFloatable(false);
        this.addSeparator();
        this.add(this.buttonInclude);
        this.add(this.buttonExclude);
    }

    public boolean handleStatus() {
        boolean bl = !this.dataSet.isProtected() && this.curTable.getSelectedRowCount() > 0;
        this.buttonInclude.setEnabled(bl);
        this.buttonExclude.setEnabled(bl);
        return bl;
    }

    public void PostGlobalMessage(byte by) {
    }

    public byte SendGlobalMessage(byte by) {
        return 1;
    }

    @Override
    protected void cleanUpChild() {
        this.curTable = null;
        this.dataSet = null;
    }

    private void includeExclude(boolean bl) {
        AbstractControlTable abstractControlTable = (AbstractControlTable)this.curTable.getAbstractTable();
        abstractControlTable.setIncludeExclude(bl);
    }
}

