/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable;

import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.propagation.PropagationProperties;
import se.prediktera.map.common.swing.flat.ColorIcon;
import se.prediktera.map.data.AbstractTabbedTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.data.datasettable.table.ObservationTable;
import se.prediktera.map.data.datasettable.table.VariableTable;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoListener;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.DataSetToolbar;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.ModelWrapper;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;

public class DataSetTable
extends AbstractTabbedTable
implements DataInfoListener {
    private ObservationTable observationTable;
    private VariableTable variableTable;
    private DataSet dataSet;
    private Case dataSetContainer;
    private MatrixListener matrixListener = new MatrixListener();
    private AbstractDataMatrix origmatrix;
    private DataSetToolbar dataSetToolbar = new DataSetToolbar();
    private PropagationProperties propProperties;
    private boolean isloading = false;

    public DataSetTable(DataInit dataInit) {
        super(dataInit);
        this.init((DataSet)dataInit.getDataTreeInterface());
    }

    public DataSetTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        Object object;
        this.isloading = true;
        this.init((DataSet)mapProperty.resolveNodeFromName(randomInputStream, "dataset"));
        if (mapProperty.hasProperty("selI")) {
            this.tabbedPane.setSelectedIndex(mapProperty.getLVInt());
        }
        if (mapProperty.hasProperty("varSelR")) {
            object = mapProperty.getLVIntArray();
            this.setSelectionInterval(this.variableTable, (int[])object);
        }
        if (mapProperty.hasProperty("obsSelR")) {
            object = mapProperty.getLVIntArray();
            this.setSelectionInterval(this.observationTable, (int[])object);
        }
        object = this.observationTable.getSimpleTable();
        if (mapProperty.hasProperty("rheight")) {
            ((ExtendScrollTable)object).setRowHeight(mapProperty.getPropertyInt("rheight"));
        }
        if (mapProperty.hasProperty("rwidth")) {
            ((SimpleTable)object).setCellWidth(mapProperty.getPropertyInt("rwidth"));
        }
        if (mapProperty.hasProperty("fsize")) {
            ((JComponent)object).setFont(new Font(((Component)object).getFont().getFontName(), ((Component)object).getFont().getStyle(), mapProperty.getPropertyInt("fsize")));
        }
        this.isloading = false;
    }

    public void addRemoveTransformationsToPopup(CMenu cMenu) {
        this.variableTable.addRemoveTransformationToPopup(cMenu);
    }

    public void addSubModel(ModelWrapper modelWrapper) {
        this.dataSetContainer.addSubModel(modelWrapper);
    }

    public void addTransformationsToPopup(CMenu cMenu) {
        this.variableTable.addTransformationToPopup(cMenu);
    }

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        byte by;
        DataSet dataSet = dataInfoEvent.getDataSet();
        if (this.isCleaned() || dataSet == null || !dataSet.equals(this.dataSet)) {
            // empty if block
        }
        if ((by = dataInfoEvent.getType()) == 15) {
            this.dataSet.setChanged();
            return true;
        }
        ProgressManager progressManager = dataInfoEvent.getProgressManager();
        if (by == 16) {
            this.dataSet.doTransformation((AbstractTransform)dataInfoEvent.getT1(), progressManager);
            this.dataSet.setTransformationResults();
        } else if (by == 5) {
            this.repaint();
        } else if (by == 7 || by == 8 || by == 9 || by == 10 || by == 3) {
            switch (by) {
                case 7: {
                    this.observationTable.repaint();
                    this.variableTable.getSimpleTable().fireTableChanged();
                    break;
                }
                case 8: {
                    this.variableTable.repaint();
                    break;
                }
                case 9: {
                    this.observationTable.getSimpleTable().fireColumnChanged();
                    this.variableTable.getSimpleTable().fireTableChanged();
                    break;
                }
                case 10: {
                    this.variableTable.getSimpleTable().fireColumnChanged();
                    this.observationTable.getSimpleTable().fireTableChanged();
                }
            }
            this.dataSet.doTransformation((AbstractTransform)dataInfoEvent.getT1(), progressManager);
            this.dataSet.setTransformationResults();
        } else if (by == 2) {
            this.variableTable.getSimpleTable().fireTableChanged();
            this.observationTable.getSimpleTable().fireTableChanged();
            this.dataSet.doTransformation((AbstractTransform)dataInfoEvent.getT1(), progressManager);
            this.dataSet.setTransformationResults();
        } else if (by == 11 || by == 12) {
            this.observationTable.updateTable();
            this.variableTable.updateTable();
        } else {
            if (this.dataSet.getResultMatrix().hasMatrixChildren()) {
                this.dataSet.doTransformations(progressManager);
            }
            if (by != 1 && dataInfoEvent.getT1() instanceof AbstractTransform) {
                this.dataSet.createResultMatrix(false);
                this.dataSet.doTransformation((AbstractTransform)dataInfoEvent.getT1(), progressManager);
                this.dataSet.transformationsChanged(progressManager, true);
            }
            boolean bl = true;
            if (dataInfoEvent instanceof DataInfoClassEvent && ((DataInfoClassEvent)dataInfoEvent).getChangeType() == 2) {
                bl = false;
            }
            if (bl) {
                this.dataSet.setTransformationResults();
            }
            if (dataInfoEvent.getSource().getDataType() == 0) {
                this.observationTable.getSimpleTable().fireColumnChanged();
                this.variableTable.getSimpleTable().fireTableChanged();
                this.observationTable.updateTable();
            } else {
                this.variableTable.getSimpleTable().fireColumnChanged();
                this.variableTable.getSimpleTable().fireTableChanged();
                this.variableTable.updateTable();
            }
            if (by == 1) {
                this.getWindowGui().selectedWindowUpdated(this, true);
            }
        }
        this.variableTable.resetSplitPane();
        this.observationTable.resetSplitPane();
        this.dataSet.setChanged();
        return true;
    }

    @Override
    public DataTreeInterface get(String string) {
        if (string.equalsIgnoreCase("obs")) {
            return this.observationTable;
        }
        if (string.equalsIgnoreCase("var")) {
            return this.variableTable;
        }
        return super.get(string);
    }

    public DataTreeInterface getData() throws Exception {
        return this.dti;
    }

    public AbstractControlTable getControlTable(boolean bl) {
        if (bl) {
            return this.observationTable;
        }
        return this.variableTable;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public String getGUI_Name() {
        return String.valueOf(this.dataSet) + " (" + super.getGUI_Name() + ")";
    }

    public InteractionArray getInteractionArray(int n) {
        return null;
    }

    public PropagationProperties getPropagationProperties() {
        return this.propProperties;
    }

    public AbstractControlTable getSelectedTable() {
        if (this.isObservationTableVisible()) {
            return this.observationTable;
        }
        return this.variableTable;
    }

    @Override
    public void getToolbars(Vector<JToolBar> vector) {
        super.getToolbars(vector);
        vector.add(this.propProperties.getToolbar());
        vector.add(this.dataSetToolbar);
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    public boolean isLoading() {
        return this.isloading;
    }

    public boolean isObservationTableVisible() {
        return this.tabbedPane.getSelectedTableEditor() instanceof ObservationTable;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        int[] nArray;
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dataset", this.dataSet);
        randomOutputStream.writePropertyInt("selI", this.tabbedPane.getSelectedIndex());
        if (this.variableTable != null) {
            nArray = this.getInteractionFlag() == 2 ? this.variableTable.getSimpleTableModel().getRowIndex() : this.variableTable.getSelectedRows();
            randomOutputStream.writePropertyIntArray("varSelR", nArray);
        }
        if (this.observationTable != null) {
            nArray = this.getInteractionFlag() == 2 ? this.observationTable.getSimpleTableModel().getRowIndex() : this.observationTable.getSelectedRows();
            randomOutputStream.writePropertyIntArray("obsSelR", nArray);
            SimpleTable simpleTable = this.observationTable.getSimpleTable();
            randomOutputStream.writePropertyInt("rheight", simpleTable.getRowHeight());
            randomOutputStream.writePropertyInt("rwidth", simpleTable.getColumnCount() > 0 ? simpleTable.getColumnModel().getColumn(0).getPreferredWidth() : 45);
            randomOutputStream.writePropertyInt("fsize", simpleTable.getFont().getSize());
        }
    }

    public void selectTransformation(AbstractTransform abstractTransform) {
        this.observationTable.selectTransformation(abstractTransform);
        this.variableTable.selectTransformation(abstractTransform);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.dataSetToolbar.setCreated(abstractWindow_GUI.getProject_GUI());
        AbstractDataInfo abstractDataInfo = this.dataSet.getObsDataInfo();
        if (abstractDataInfo != null) {
            abstractDataInfo.addListener(this);
        }
        if ((abstractDataInfo = this.dataSet.getVarDataInfo()) != null) {
            abstractDataInfo.addListener(this);
        }
    }

    public void showControlTable(boolean bl) {
        if (bl) {
            this.tabbedPane.selectTableEditor(this.observationTable);
        } else {
            this.tabbedPane.selectTableEditor(this.variableTable);
        }
    }

    @Override
    public void showSelectionDialog() {
        AbstractControlTable abstractControlTable = this.getSelectedTable();
        if (abstractControlTable != null) {
            abstractControlTable.showSelectionDialog();
        }
    }

    public void updateInformation() {
        this.dataSet.updateReferences();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.origmatrix != null) {
            this.origmatrix.removeDataTreeChangeListener(this.matrixListener);
            this.origmatrix = null;
        }
        if (this.observationTable != null) {
            this.observationTable.cleanUp();
            this.observationTable = null;
        }
        if (this.variableTable != null) {
            this.variableTable.cleanUp();
            this.variableTable = null;
        }
        if (this.dataSet != null) {
            this.dataSet.removeDataTreeChangeListener(this.matrixListener);
            if (!this.dataSet.isCleaned()) {
                this.dataSet.getObsDataInfo().removeListener(this);
                this.dataSet.getVarDataInfo().removeListener(this);
            }
            this.dataSet = null;
        }
        this.dataSetContainer = null;
        if (this.dataSetToolbar != null) {
            this.dataSetToolbar.cleanUp();
            this.dataSetToolbar = null;
        }
        if (this.propProperties != null) {
            this.propProperties.cleanUp();
            this.propProperties = null;
        }
        this.matrixListener = null;
    }

    @Override
    protected String getDefaultTitle() {
        return "View DataSet";
    }

    private void init(DataSet dataSet) {
        this.dataSet = dataSet;
        this.propProperties = new PropagationProperties(dataSet);
        this.dataSetContainer = dataSet.getCase();
        if (this.dataSetContainer != null) {
            this.origmatrix = this.dataSetContainer.getOriginalMatrix();
            if (this.origmatrix != null) {
                this.origmatrix.addDataTreeChangeListener(this.matrixListener);
            }
        }
        dataSet.addDataTreeChangeListener(this.matrixListener);
        this.dataSetToolbar.setDataSet(dataSet);
        this.observationTable = new ObservationTable(this, this.getDataInit());
        this.variableTable = new VariableTable(this, this.getDataInit());
        this.tabbedPane.addEditor(this.observationTable, "<html><b>Obs</b>ervations</html>", ColorIcon.createIcon(CellIdentifierModel.getColorByType(1), 14, 10));
        this.tabbedPane.addEditor(this.variableTable, "<html><b>Var</b>iables</html>", ColorIcon.createIcon(CellIdentifierModel.getColorByType(0), 14, 10));
    }

    private void setSelectionInterval(AbstractControlTable abstractControlTable, int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            boolean bl = true;
            int n = 0;
            int n2 = abstractControlTable.getSimpleTable().getRowCount();
            for (int i = 0; i < nArray.length; ++i) {
                if (i != nArray.length - 1 && (i <= 0 || nArray[i] - nArray[i - 1] == 1)) continue;
                int n3 = i - 1;
                if (i == nArray.length - 1) {
                    n3 = i;
                }
                if (nArray[n] < n2 && nArray[n3] < n2) {
                    if (bl) {
                        abstractControlTable.setRowSelectionInterval(nArray[n], nArray[n3]);
                        bl = false;
                    } else {
                        abstractControlTable.addRowSelectionInterval(nArray[n], nArray[n3]);
                    }
                }
                n = i;
            }
        }
    }

    private class MatrixListener
    implements DataMatrixListener {
        private MatrixListener() {
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
            Project_GUI project_GUI;
            if (dataTreeEvent.getDataTreeInterface() instanceof DataSet && (project_GUI = DataSetTable.this.getProject_GUI()) != null && project_GUI.getData_GUI() != null) {
                project_GUI.getData_GUI().repaint();
            }
        }
    }
}

