/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.selection.AbstractSelectionInfo;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;

public class RepresentativeSelectionPage
extends AbstractSelectionPage {
    private final JComboBox modelComboBox = new JComboBox();
    private final JComboBox algorithmComboBox = new JComboBox();
    private final JTextField numberTextField = new JTextField();
    private AbstractDataInfo dataInfo;
    private int selectionType = 0;
    private AbstractModel origModel;

    public RepresentativeSelectionPage(AbstractWindow abstractWindow, DataSet dataSet, AbstractModel abstractModel) {
        super(abstractWindow);
        this.origModel = abstractModel;
        this.dataInfo = dataSet.getObsDataInfo();
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Model:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.modelComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)new JLabel("Algorithm:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.algorithmComboBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)new JLabel("Number:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.numberTextField, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 2, new Insets(12, 12, 12, 12), 0, 0));
        Vector<AbstractSelectionInfo> vector = new Vector<AbstractSelectionInfo>();
        AbstractSelectionInfo.addExternSelection(vector, dataSet);
        for (AbstractSelectionInfo abstractSelectionInfo : vector) {
            this.algorithmComboBox.addItem(abstractSelectionInfo);
        }
        this.numberTextField.setText(String.valueOf(10));
    }

    @Override
    public AbstractWindow getWindow() {
        return this.window;
    }

    @Override
    public void prepareInteraction() {
        int n;
        Project_GUI project_GUI = this.window.getProject_GUI();
        InteractionArray interactionArray = project_GUI.getInteractionArray(1, n = this.dataInfo.getGroupID());
        if (interactionArray != null && this.selectionType != 0) {
            interactionArray = interactionArray.cloneArray();
        }
        final InteractionArray interactionArray2 = project_GUI.getInteractionArray(this.dataInfo.getCase(), 1, this.dataInfo.getRowCount(), n);
        if (interactionArray == null || interactionArray.size() == 0) {
            if (this.selectionType == 2) {
                return;
            }
            interactionArray = interactionArray2;
        }
        final InteractionArray interactionArray3 = interactionArray;
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
            final /* synthetic */ RepresentativeSelectionPage this$0;
            {
                this.this$0 = representativeSelectionPage;
            }

            @Override
            public Object doWork() {
                AbstractSelectionInfo abstractSelectionInfo = (AbstractSelectionInfo)this.this$0.algorithmComboBox.getSelectedItem();
                AbstractModel abstractModel = (AbstractModel)this.this$0.modelComboBox.getSelectedItem();
                if (abstractModel != null) {
                    int[][] nArray;
                    int n = Integer.parseInt(this.this$0.numberTextField.getText());
                    for (int[] nArray2 : nArray = abstractSelectionInfo.getGroup(this, this.this$0.dataInfo.getDataSet(), abstractModel, n, null)) {
                        for (int i = 0; i < nArray2.length; ++i) {
                            int n2 = nArray2[i];
                            if (this.this$0.selectionType == 2) {
                                interactionArray2.set(n2, n2 < interactionArray3.size() && interactionArray3.get(n2));
                                continue;
                            }
                            interactionArray2.set(n2);
                        }
                    }
                }
                return null;
            }
        };
        progressManagerImpl.invokeNow();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.window = null;
        this.dataInfo = null;
        this.origModel = null;
    }

    @Override
    protected void doSelection(int n) {
        this.selectionType = n;
        this.window.getProject_GUI().doInteraction(this);
    }

    @Override
    protected void initPage(AbstractWindow abstractWindow) {
        int n;
        DataSet dataSet = this.dataInfo.getDataSet();
        this.modelComboBox.removeAllItems();
        for (n = 0; n < dataSet.getTreeNodeCount(); n += 1) {
            AbstractModel abstractModel;
            DataTreeInterface dataTreeInterface = dataSet.getTreeNodeAt(n);
            if (!(dataTreeInterface instanceof AbstractModel) || !(abstractModel = (AbstractModel)dataTreeInterface).getModelName().equals("PCA") && !abstractModel.getModelName().equals("Model Container")) continue;
            this.modelComboBox.addItem(abstractModel);
        }
        n = this.modelComboBox.getItemCount() > 0 ? 1 : 0;
        this.modelComboBox.setEnabled(n != 0);
        if (this.origModel != null) {
            if (this.origModel.getTreeParent() instanceof AbstractModel) {
                this.origModel = (AbstractModel)this.origModel.getTreeParent();
            }
            this.modelComboBox.setSelectedItem(this.origModel);
            this.modelComboBox.setEnabled(false);
        }
        this.algorithmComboBox.setEnabled(n != 0);
        this.numberTextField.setEnabled(n != 0);
    }
}

