/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;

public class WildcardSelectionPage
extends AbstractSelectionPage {
    private DataSet dataset;
    private final JComboBoxCell createComboBox;
    private AbstractDataInfo dataInfo1;
    private AbstractDataInfo dataInfo2;
    private final JTextArea regexField;
    private int separatorIndex = -1;
    private int selectionType = 0;
    private final boolean isObservationTable;

    public WildcardSelectionPage(AbstractWindow abstractWindow, DataSet dataSet, boolean bl) {
        super(abstractWindow);
        this.dataset = dataSet;
        this.isObservationTable = bl;
        this.createComboBox = new JComboBoxCell();
        if (bl) {
            this.dataInfo2 = dataSet.getVarDataInfo();
            this.dataInfo1 = dataSet.getObsDataInfo();
        } else {
            this.dataInfo1 = dataSet.getVarDataInfo();
            this.dataInfo2 = dataSet.getObsDataInfo();
        }
        this.regexField = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.regexField);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Source:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        this.add((Component)this.createComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("Matching expression(s):"), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 6, 12), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 12, 12), 0, 0));
    }

    @Override
    public AbstractWindow getWindow() {
        return this.window;
    }

    @Override
    public void prepareInteraction() {
        Project_GUI project_GUI = this.window.getProject_GUI();
        int n = this.isObservationTable ? 1 : 2;
        int n2 = -1;
        InteractionArray interactionArray = project_GUI.getInteractionArray(n, this.dataInfo1.getGroupID());
        try {
            n2 = this.dataInfo1.getGroupColumnByType(0).getRows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (interactionArray != null && this.selectionType != 0) {
            interactionArray = interactionArray.cloneArray();
        }
        InteractionArray interactionArray2 = project_GUI.getInteractionArray(this.dataset.getCase(), n, Math.max(interactionArray != null ? interactionArray.size() : 0, n2), this.dataInfo1.getGroupID());
        if (interactionArray == null || interactionArray.size() == 0) {
            if (this.selectionType == 2) {
                return;
            }
            interactionArray = interactionArray2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.regexField.getText(), "\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n3 = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n3] = stringTokenizer.nextToken().replaceAll("(\\.\\*|\\*)", ".*");
                Pattern.compile(stringArray[n3]);
                ++n3;
            }
            if (this.isCurrentlyDescriptionColumn()) {
                this.selectFromObs(interactionArray, interactionArray2, stringArray);
            } else {
                this.selectFromVar(interactionArray, interactionArray2, stringArray);
            }
        }
        catch (Exception exception) {
            JOptionPane.showConfirmDialog(this, "\"" + stringArray[n3] + "\" is not a valid expression", "Invalid expression", -1, 1);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.window = null;
        this.dataset = null;
    }

    @Override
    protected void doSelection(int n) {
        this.selectionType = n;
        this.window.getProject_GUI().doInteraction(this);
    }

    @Override
    protected void initPage(AbstractWindow abstractWindow) {
        this.fillCreateBox();
    }

    private void fillCreateBox() {
        this.createComboBox.removeAllItems();
        if (this.dataInfo1 != null && this.dataInfo2 != null) {
            DataGroupValues dataGroupValues = this.dataInfo1.getGroupColumnByType(0);
            int n = dataGroupValues.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.createComboBox.addItem(new ComboItem(dataGroupValues.getColumnName(i), 0, i, false));
            }
            DataGroupValues dataGroupValues2 = this.dataInfo2.getGroupColumnByType(0);
            Object icType = dataGroupValues2.getPrimaryColumn();
            if (icType != null) {
                this.separatorIndex = this.createComboBox.getItemCount();
                this.createComboBox.addSeparator();
                int n2 = ((AbstractInnerColumn)icType).getSize();
                for (int i = 0; i < n2; ++i) {
                    Object object = ((AbstractInnerColumn)icType).getValue(i);
                    if (object == null || object.equals("")) continue;
                    this.createComboBox.addItem(new ComboItem(i + 1 + ": " + String.valueOf(object), 1, i, false));
                }
            }
        }
    }

    private InnerColumnString getCurrentColumn() {
        boolean bl = this.isCurrentlyDescriptionColumn();
        int n = this.createComboBox.getSelectedIndex();
        if (!bl) {
            return null;
        }
        DataGroupValues dataGroupValues = this.dataInfo1.getGroupColumnByType(0);
        return (InnerColumnString)dataGroupValues.getInnerColumn(n);
    }

    private boolean isCurrentlyDescriptionColumn() {
        int n = this.createComboBox.getSelectedIndex();
        return n < this.separatorIndex;
    }

    private void selectFromObs(BooleanArray booleanArray, BooleanArray booleanArray2, String[] stringArray) {
        InnerColumnString innerColumnString = this.getCurrentColumn();
        for (int i = 0; i < innerColumnString.getSize(); ++i) {
            String string = innerColumnString.getValueLocal(i);
            boolean bl = false;
            for (String string2 : stringArray) {
                if (string == null || !string.matches(string2)) continue;
                if (this.selectionType == 2 && booleanArray != null) {
                    booleanArray2.set(i, booleanArray.get(i));
                } else {
                    booleanArray2.set(i);
                }
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.selectionType == 1 && booleanArray != null) {
                booleanArray2.set(i, booleanArray.get(i));
                continue;
            }
            booleanArray2.set(i, false);
        }
    }

    private void selectFromVar(BooleanArray booleanArray, BooleanArray booleanArray2, String[] stringArray) {
        int n = this.dataInfo1.getAllInnerColumn(0).getSize();
        int n2 = this.createComboBox.getSelectedIndex() - this.separatorIndex - 1;
        AbstractDataMatrix abstractDataMatrix = this.dataset.getOriginalMatrix();
        for (int i = 0; i < n; ++i) {
            double d = this.isObservationTable ? abstractDataMatrix.getValue(i, n2) : abstractDataMatrix.getValue(n2, i);
            boolean bl = false;
            for (String string : stringArray) {
                if (!Double.toString(d).matches(string)) continue;
                if (this.selectionType == 2) {
                    booleanArray2.set(i, booleanArray.get(i));
                } else {
                    booleanArray2.set(i);
                }
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.selectionType == 1) {
                booleanArray2.set(i, booleanArray.get(i));
                continue;
            }
            booleanArray2.set(i, false);
        }
    }
}

