/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.data.DataTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.data.fixed.AbstractFixedTable;
import se.prediktera.map.data.fixed.FixedTableCellRenderer;
import se.prediktera.map.data.image.ImageTableCellRenderer;
import se.prediktera.map.data.intervall.AbstractIntervalTable;
import se.prediktera.map.data.intervall.IntervallTableCellRenderer;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataImage;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnImageResource;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.value.InnerColumnValue;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableScrollTable;

public class DataControlTable
extends DataTable {
    private AbstractDataInfo dataInfo = null;
    private CustomTableModel dm;
    private ClassRenderer classRenderer = new ClassRenderer();
    private final AddedDataRenderer addedDataRenderer = new AddedDataRenderer();
    private TableCellRenderer booleanRenderer;
    private CustomStringRenderer customStringRenderer;
    private TableCellRenderer xyRenderer;
    private TableCellRenderer incExlRenderer;
    private TableCellRenderer[] imageRenderer;
    private DataSet dataSet;

    public DataControlTable(AbstractIntervalTable abstractIntervalTable, JScrollPane jScrollPane, AbstractDataInfo abstractDataInfo) {
        super(abstractIntervalTable, jScrollPane, false, true);
        this.dataInfo = abstractDataInfo;
        this.dataSet = (DataSet)abstractIntervalTable.getDataTreeInterface();
        AbstractDataMatrix abstractDataMatrix = this.dataSet.getParentMatrix();
        this.setMatrix(this.dataSet.getResultMatrix(), false);
        this.setAutoResizeMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        if (abstractDataInfo == null) {
            return;
        }
        this.dm = new CustomTableModel(abstractDataMatrix, (TransformMatrix)this.matrix, abstractDataInfo);
        this.setModel(this.dm);
        this.incExlRenderer = this.booleanRenderer = new CustomIntervalCellRenderer(abstractIntervalTable);
        this.xyRenderer = new XYIntervalCellRenderer(abstractIntervalTable);
        this.customStringRenderer = new CustomStringRenderer();
        DataImage dataImage = (DataImage)abstractDataInfo.getGroupColumnByType(12);
        if (dataImage != null) {
            this.imageRenderer = new ImageTableCellRenderer[dataImage.getColumnCount()];
            for (int i = 0; i < dataImage.getColumnCount(); ++i) {
                InnerColumnImageResource innerColumnImageResource = (InnerColumnImageResource)dataImage.getInnerColumn(i);
                this.imageRenderer[i] = new ImageTableCellRenderer(this.dm, innerColumnImageResource.getResourceNode());
            }
        }
        this.dm.fireUpdate();
    }

    public AbstractInnerColumn addDataColumn(int n, String string) {
        return this.dm.addDataColumn(n, string);
    }

    @Override
    public void addToHeaderPopup(MouseEvent mouseEvent, JPopupMenu jPopupMenu, int n) {
        AbstractSimpleTable abstractSimpleTable = this.getAbstractTable();
        if (abstractSimpleTable instanceof AbstractControlTable) {
            CleanUpInterface cleanUpInterface;
            CleanUpInterface cleanUpInterface2;
            AbstractControlTable abstractControlTable = (AbstractControlTable)abstractSimpleTable;
            abstractControlTable.setCurrentColumn(mouseEvent);
            final int n2 = abstractControlTable.getCurrentColumn();
            AbstractInnerColumn abstractInnerColumn = this.dataInfo.getAllInnerColumn(n2);
            if (abstractInnerColumn instanceof InnerColumnBoolean) {
                cleanUpInterface2 = new CMenuItem(this, "Include all"){
                    final /* synthetic */ DataControlTable this$0;
                    {
                        this.this$0 = dataControlTable;
                        super(object);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.this$0.dataInfo.fillColumn(n2, true)) {
                            this.this$0.dataSet.updateReferences();
                            if (n2 == 0) {
                                this.this$0.dataInfo.triggerObsVarIncExc();
                            }
                            this.repaint();
                        }
                    }
                };
                cleanUpInterface = new CMenuItem(this, "Exclude all"){
                    final /* synthetic */ DataControlTable this$0;
                    {
                        this.this$0 = dataControlTable;
                        super(object);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.this$0.dataInfo.fillColumn(n2, false)) {
                            this.this$0.dataSet.updateReferences();
                            if (n2 == 0) {
                                this.this$0.dataInfo.triggerObsVarIncExc();
                            }
                            this.repaint();
                        }
                    }
                };
                jPopupMenu.addSeparator();
                ((JMenuItem)((Object)cleanUpInterface2)).setEnabled(!this.dataSet.isProtected());
                jPopupMenu.add((JMenuItem)((Object)cleanUpInterface2));
                ((JMenuItem)((Object)cleanUpInterface)).setEnabled(!this.dataSet.isProtected());
                jPopupMenu.add((JMenuItem)((Object)cleanUpInterface));
                abstractControlTable.addToHeaderPopup(mouseEvent, jPopupMenu, n);
            } else {
                super.addToHeaderPopup(mouseEvent, jPopupMenu, n2);
            }
            if (abstractInnerColumn != null && (cleanUpInterface = abstractInnerColumn.getParent()) instanceof Transformations) {
                CMenuItem cMenuItem;
                cleanUpInterface2 = (Transformations)cleanUpInterface;
                cleanUpInterface = ((Transformations)cleanUpInterface2).getTransform(abstractInnerColumn);
                jPopupMenu.addSeparator();
                if (!(cleanUpInterface instanceof AbstractDataTransform)) {
                    cMenuItem = new CMenuItem(this, "Rename modification", new ImageIcon(Main_GUI.class.getResource("gif/rename.png")), (AbstractTransform)cleanUpInterface){
                        final /* synthetic */ AbstractTransform val$transf;
                        final /* synthetic */ DataControlTable this$0;
                        {
                            this.val$transf = abstractTransform;
                            this.this$0 = dataControlTable;
                            super(string, imageIcon);
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$transf.renameModification();
                        }
                    };
                    cMenuItem.setEnabled(!this.dataSet.isProtected());
                    jPopupMenu.add(cMenuItem);
                }
                cMenuItem = new CMenuItem(this, "Delete modification", new ImageIcon(Main_GUI.class.getResource("gif/delete.png")), (AbstractTransform)cleanUpInterface){
                    final /* synthetic */ AbstractTransform val$transf;
                    final /* synthetic */ DataControlTable this$0;
                    {
                        this.val$transf = abstractTransform;
                        this.this$0 = dataControlTable;
                        super(string, imageIcon);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$transf.deleteModification();
                    }
                };
                cMenuItem.setEnabled(!this.dataSet.isProtected());
                jPopupMenu.add(cMenuItem);
            }
        }
    }

    @Override
    public FixedTableCellRenderer createFixedTableCellRenderer() {
        return new DescriptionRenderer();
    }

    public void fireUpdate() {
        this.dm.fireUpdate();
    }

    public String getRenderedValue(Object object, int n) {
        AbstractInnerColumn abstractInnerColumn;
        if (object instanceof Boolean) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            if (tableColumn.getCellRenderer() instanceof XYIntervalCellRenderer) {
                return (Boolean)object != false ? "X" : "Y";
            }
            return (Boolean)object != false ? "*" : "";
        }
        if (object instanceof Integer && (abstractInnerColumn = this.dataInfo.getAllInnerColumn(n)) instanceof InnerColumnClass) {
            ClassTypes classTypes = ((InnerColumnClass)abstractInnerColumn).getObject();
            return classTypes.getTypeDescription((Integer)object);
        }
        return String.valueOf(object);
    }

    public void removeDataColumn(int n) {
        this.removeColumn(this.getColumnModel().getColumn(n));
        this.dm.fireUpdate();
    }

    public void renameDataColumn() {
        this.dm.fireUpdate();
    }

    @Override
    public void setCurrentColumnNoPropagate(int n) {
        super.setCurrentColumnNoPropagate(n);
        if (this.getAbstractTable() instanceof AbstractControlTable) {
            ((AbstractControlTable)this.getAbstractTable()).setCurrentLayer(n);
        }
    }

    public void UpdateTable() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = 0;
        for (int i = 0; i < this.dataInfo.getGroupSize(); ++i) {
            DataGroupValues dataGroupValues = this.dataInfo.getGroupColumnByIndex(i);
            if (!dataGroupValues.isTableble()) continue;
            byte by = dataGroupValues.getTreeType();
            int n2 = dataGroupValues.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                TableColumn tableColumn = tableColumnModel.getColumn(n + j);
                tableColumn.setCellRenderer(this.customStringRenderer);
                switch (by) {
                    case 1: {
                        tableColumn.setCellRenderer(this.incExlRenderer);
                        tableColumn.setPreferredWidth(45);
                        break;
                    }
                    case 3: {
                        tableColumn.setCellRenderer(this.xyRenderer);
                        tableColumn.setPreferredWidth(45);
                        break;
                    }
                    case 4: 
                    case 5: {
                        tableColumn.setCellRenderer(this.booleanRenderer);
                        tableColumn.setPreferredWidth(45);
                        break;
                    }
                    case 12: {
                        tableColumn.setCellRenderer(this.imageRenderer[j]);
                        tableColumn.setPreferredWidth(45);
                        break;
                    }
                    case 10: {
                        if (((Transformations)dataGroupValues).getColumnType(j) == 4) {
                            tableColumn.setCellRenderer(this.classRenderer);
                            tableColumn.setPreferredWidth(50);
                            break;
                        }
                        if (((Transformations)dataGroupValues).getColumnType(j) == 13) {
                            tableColumn.setCellRenderer(this.addedDataRenderer);
                            tableColumn.setPreferredWidth(50);
                            break;
                        }
                        tableColumn.setCellRenderer(this.booleanRenderer);
                        tableColumn.setPreferredWidth(45);
                        break;
                    }
                }
                tableColumn.setHeaderValue(dataGroupValues.getInnerColumn(j));
            }
            n += n2;
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dataInfo = null;
        if (this.dm != null) {
            this.dm.cleanUp();
            this.dm = null;
        }
        this.classRenderer = null;
        this.booleanRenderer = null;
        this.customStringRenderer = null;
        this.xyRenderer = null;
        this.incExlRenderer = null;
        this.imageRenderer = null;
        this.dataSet = null;
    }

    private class ClassRenderer
    extends CustomStringRenderer
    implements TableCellRenderer {
        private ClassRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Integer) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                AbstractInnerColumn abstractInnerColumn = DataControlTable.this.dataInfo.getAllInnerColumn(n2);
                if (abstractInnerColumn instanceof InnerColumnClass) {
                    ClassTypes classTypes = ((InnerColumnClass)abstractInnerColumn).getObject();
                    this.setText(classTypes.getTypeDescription((Integer)object));
                }
                return this;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        protected Color getBackground(JTable jTable) {
            return CellIdentifier.colorCategory;
        }
    }

    private class AddedDataRenderer
    extends CustomStringRenderer
    implements TableCellRenderer {
        private AddedDataRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        protected Color getBackground(JTable jTable) {
            return CellIdentifier.colorAddedData;
        }
    }

    private class CustomTableModel
    extends SimpleTableModel {
        private final AbstractDataInfo dataInfo;
        private final TransformMatrix resultMatrix;
        private final HashSet<Integer> updateColumns;
        private final SwingTimer updateTimer;

        public CustomTableModel(AbstractDataMatrix abstractDataMatrix, TransformMatrix transformMatrix, AbstractDataInfo abstractDataInfo) {
            super(abstractDataMatrix, abstractDataInfo.getRowCount(), abstractDataInfo.getTableColumnCount(), abstractDataInfo instanceof VariablesInfo);
            this.updateColumns = new HashSet();
            this.updateTimer = new SwingTimer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Iterator<Integer> iterator = CustomTableModel.this.updateColumns.iterator();
                    while (iterator.hasNext()) {
                        this.triggerUpdateOnColumn(iterator.next());
                        iterator.remove();
                    }
                }

                private void triggerUpdateOnColumn(Integer n) {
                    AbstractInnerColumn abstractInnerColumn = CustomTableModel.this.dataInfo.getAllInnerColumn(n);
                    if (abstractInnerColumn instanceof InnerColumnValue) {
                        AbstractTransform abstractTransform = CustomTableModel.this.dataInfo.getTransformation(abstractInnerColumn);
                        CustomTableModel.this.dataInfo.triggerGlobalEvent(new DataInfoEvent(CustomTableModel.this.dataInfo, 7, abstractTransform));
                    } else {
                        CustomTableModel.this.updateDescription();
                    }
                }
            }, false);
            this.dataInfo = abstractDataInfo;
            this.resultMatrix = transformMatrix;
        }

        public AbstractInnerColumn addDataColumn(int n, String string) {
            AbstractInnerColumn abstractInnerColumn = this.dataInfo.addColumn(string, n);
            this.fireUpdate();
            return abstractInnerColumn;
        }

        @Override
        public void fireTableStructureChanged(SimpleTable simpleTable) {
            block4: {
                int n = simpleTable.getColumnModel().getColumnCount();
                this.rows = this.dataInfo.getRowCount();
                this.columns = this.dataInfo.getTableColumnCount();
                int n2 = this.getColumnCount();
                if (n2 == n) break block4;
                if (n2 > n) {
                    for (int i = n; i < n2; ++i) {
                        simpleTable.addColumn(i);
                    }
                } else {
                    for (int i = n2; i < n; ++i) {
                        simpleTable.removeColumn(simpleTable.getColumnModel().getColumn(n2));
                    }
                }
            }
        }

        public void fireUpdate() {
            this.fireTableChanged(null);
            DataControlTable.this.UpdateTable();
        }

        @Override
        public int getColumnCount() {
            int[] nArray = this.getColumnIndex();
            if (nArray != null) {
                return nArray.length;
            }
            return this.dataInfo.getTableColumnCount();
        }

        @Override
        public String getColumnDescription(int n, int n2) {
            if (n < 0 || n2 < 0) {
                return null;
            }
            int[] nArray = this.getRowIndex();
            if (nArray != null && n < nArray.length) {
                n = nArray[n];
            }
            if (this.resultMatrix != null && !this.resultMatrix.hasMatrixChildren()) {
                if (this.dataInfo instanceof VariablesInfo) {
                    return this.resultMatrix.getColumnDescription(n, n2);
                }
                return this.resultMatrix.getRowDescription(n, n2);
            }
            return "N/A";
        }

        @Override
        public byte getColumnType(int n) {
            if (this.resultMatrix == null) {
                return 4;
            }
            if (this.transpose) {
                return this.resultMatrix.getRowType(n);
            }
            return this.resultMatrix.getColumnType(n);
        }

        @Override
        public FastDecimal getDoubleAt_Transpose_Sort(int n, int n2, FastDecimal fastDecimal) {
            if (this.transpose) {
                return this.dataInfo.getDoubleAt(n2, n, fastDecimal);
            }
            return this.dataInfo.getDoubleAt(n, n2, fastDecimal);
        }

        @Override
        public Object getRenderedTableValue(int n, int n2) {
            return DataControlTable.this.getRenderedValue(super.getValueAt(n, n2), n2);
        }

        @Override
        public int getRowCount() {
            int[] nArray = this.getRowIndex();
            if (nArray != null) {
                return nArray.length;
            }
            if (this.resultMatrix != null) {
                if (this.dataInfo instanceof VariablesInfo) {
                    return this.resultMatrix.getK();
                }
                return this.resultMatrix.getN();
            }
            if (this.dataInfo == null) {
                return 0;
            }
            return this.dataInfo.getRowCount();
        }

        @Override
        public String getRowDescription(int n, int n2) {
            DataGroupValues dataGroupValues;
            AbstractInnerColumn abstractInnerColumn;
            AbstractInnerColumn abstractInnerColumn2 = abstractInnerColumn = this.dataInfo == null ? null : this.dataInfo.getAllInnerColumn(n2);
            if (abstractInnerColumn == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(abstractInnerColumn.toString());
            if (abstractInnerColumn.hasSiblings() && abstractInnerColumn.isPrimary()) {
                stringBuilder.append("*");
            }
            if ((dataGroupValues = abstractInnerColumn.getParent()) != null && dataGroupValues.getTreeType() == 2) {
                ClassTypes classTypes = ((InnerColumnClass)abstractInnerColumn).getObject();
                stringBuilder.append("(").append(classTypes.size() - 1).append(")");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getRowDescriptionTitle(int n) {
            Object icType;
            if (this.dataInfo == null) {
                return null;
            }
            DataGroupValues dataGroupValues = this.dataInfo.getGroupColumnByType(0);
            if (dataGroupValues != null && (icType = dataGroupValues.getInnerColumn(n)) != null) {
                return ((AbstractInnerColumn)icType).toString();
            }
            return "N/A";
        }

        @Override
        public byte getRowType(int n) {
            if (this.resultMatrix == null) {
                return 4;
            }
            if (this.transpose) {
                return this.resultMatrix.getColumnType(n);
            }
            return this.resultMatrix.getRowType(n);
        }

        @Override
        public Object getValueAt_Sort(int n, int n2) {
            if (this.transpose) {
                return this.dataInfo.getValueAt(n2, n);
            }
            return this.dataInfo.getValueAt(n, n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            AbstractInnerColumn abstractInnerColumn = this.dataInfo.getAllInnerColumn(n2);
            return abstractInnerColumn instanceof InnerColumnValue;
        }

        @Override
        public boolean isDescriptionEditable(int n, int n2) {
            if (DataControlTable.this.dataSet != null) {
                return !DataControlTable.this.dataSet.isProtected();
            }
            return false;
        }

        @Override
        public void setColumnDescription(int n, int n2, String string) {
            if (n >= 0 && n2 >= 0) {
                int[] nArray = this.getRowIndex();
                if (nArray != null && n < nArray.length) {
                    n = nArray[n];
                }
                if (this.dataInfo != null) {
                    Description description = (Description)this.dataInfo.getGroupColumnByType(0);
                    description.setValue(n, n2, string);
                    if (this.resultMatrix != null) {
                        this.resultMatrix.setColumnDescription(n, n2, string);
                    }
                    this.updateDescription();
                }
            }
        }

        @Override
        public void setRowDescription(int n, int n2, String string) {
            AbstractInnerColumn abstractInnerColumn;
            AbstractInnerColumn abstractInnerColumn2 = abstractInnerColumn = this.dataInfo == null ? null : this.dataInfo.getAllInnerColumn(n2);
            if (abstractInnerColumn != null) {
                abstractInnerColumn.getParent().setName(string);
                this.updateDescription();
            }
        }

        @Override
        public void setRowDescriptionTitle(int n, String string) {
            if (this.dataInfo != null) {
                DataGroupValues dataGroupValues = this.dataInfo.getGroupColumnByType(0);
                ((AbstractInnerColumn)dataGroupValues.getInnerColumn(n)).setName(string);
                this.updateDescription();
            }
        }

        @Override
        public void setValueAt_Sort(Object object, int n, int n2) {
            if (this.isCellEditable(n, n2)) {
                this.dataInfo.setValueAt(n, n2, object);
                this.updateColumns.add(n2);
                this.updateTimer.restart();
            }
        }

        @Override
        protected int getColumnDescriptionCountInternal() {
            DataGroupValues dataGroupValues;
            if (this.dataInfo instanceof VariablesInfo && (dataGroupValues = this.dataInfo.getGroupColumnByType(0)) != null) {
                return dataGroupValues.getColumnCount();
            }
            return 1;
        }

        @Override
        protected int getRowDescriptionCountInternal() {
            DataGroupValues dataGroupValues;
            if (this.dataInfo instanceof ObservationInfo && (dataGroupValues = this.dataInfo.getGroupColumnByType(0)) != null) {
                return dataGroupValues.getColumnCount();
            }
            return 1;
        }

        private void updateDescription() {
            if (this.resultMatrix != null && !this.resultMatrix.hasMatrixChildren()) {
                if (this.dataInfo instanceof VariablesInfo) {
                    this.resultMatrix.varDescriptionUpdated();
                } else {
                    this.resultMatrix.obsDescriptionUpdated();
                }
            }
            DataControlTable.this.dataSet.updateDescription();
            DataControlTable.this.dataSet.setChangedAskApplyChanges();
        }
    }

    private class CustomIntervalCellRenderer
    extends IntervallTableCellRenderer {
        private IncExclude incExlude;

        public CustomIntervalCellRenderer(AbstractIntervalTable abstractIntervalTable) {
            super(abstractIntervalTable);
            this.setFont(new Font("SansSerif", 0, 12));
        }

        public CustomIntervalCellRenderer(AbstractIntervalTable abstractIntervalTable, Color color) {
            super(abstractIntervalTable, color);
            this.setFont(new Font("SansSerif", 0, 12));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Boolean) {
                this.setText(null);
                this.paintBars = true;
            } else {
                this.setText(String.valueOf(object));
                this.paintBars = false;
            }
            this.setColors(jTable, bl, n, n2);
            int n3 = -1;
            if (jTable instanceof ExtendSortableScrollTable) {
                n3 = ((ExtendSortableScrollTable)jTable).getCurrentColumnIndex();
            }
            if (n3 == n2) {
                boolean bl3 = n == 0;
                boolean bl4 = n == jTable.getRowCount() - 1;
                this.setBorder(EvinceBorderFactory.createMarkerBorder(bl3, bl4));
            } else {
                this.setBorder(null);
            }
            return this;
        }

        protected void setColors(JTable jTable, boolean bl, int n, int n2) {
            if (this.incExlude == null && DataControlTable.this.dataInfo != null) {
                this.incExlude = (IncExclude)DataControlTable.this.dataInfo.getGroupColumnByType(1);
            }
            if (n >= 0) {
                boolean bl2 = this.isIncluded = this.incExlude == null || this.incExlude.isIncluded(DataControlTable.this.dm.getDataRow(n));
            }
            if (bl) {
                if (this.isIncluded) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setBackground(jTable.getSelectionBackground().darker());
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
            } else if (this.isIncluded) {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            this.inc = this.intervalTable.isCellIncluded(n, n2);
            this.firstRow = n <= 0;
            this.uinc = this.firstRow ? false : this.intervalTable.isCellIncluded(n - 1, n2);
            this.lastRow = n >= jTable.getRowCount() - 1;
            this.linc = this.lastRow ? false : this.intervalTable.isCellIncluded(n + 1, n2);
        }
    }

    private class XYIntervalCellRenderer
    extends CustomIntervalCellRenderer {
        public XYIntervalCellRenderer(AbstractIntervalTable abstractIntervalTable) {
            super(abstractIntervalTable, new Color(255, 0, 0, 100));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    this.setText("X");
                } else {
                    this.setText("Y");
                }
                this.setHorizontalAlignment(0);
                this.paintBars = true;
            } else {
                this.setText(String.valueOf(object));
                this.paintBars = false;
            }
            this.setColors(jTable, bl, n, n2);
            boolean bl3 = n == 0;
            boolean bl4 = n == jTable.getRowCount() - 1;
            int n3 = -1;
            if (jTable instanceof ExtendSortableScrollTable) {
                n3 = ((ExtendSortableScrollTable)jTable).getCurrentColumnIndex();
            }
            if (n3 == n2) {
                this.setBorder(EvinceBorderFactory.createMarkerBorder(bl3, bl4));
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    private class CustomStringRenderer
    extends FixedTableCellRenderer {
        protected boolean isIncluded;
        private IncExclude incExlude;

        public CustomStringRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setFont(new Font("SansSerif", 0, 12));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = n == 0;
            boolean bl4 = n == jTable.getRowCount() - 1;
            this.setText(object == null ? "" : object.toString());
            n = DataControlTable.this.dm.getDataRow(n);
            if (this.incExlude == null && DataControlTable.this.dataInfo != null) {
                this.incExlude = (IncExclude)DataControlTable.this.dataInfo.getGroupColumnByType(1);
            }
            if (n >= 0) {
                this.isIncluded = this.incExlude == null || this.incExlude.isIncluded(n);
            }
            AbstractFixedTable abstractFixedTable = DataControlTable.this.getFixedTable(0);
            AbstractFixedTable abstractFixedTable2 = DataControlTable.this.getFixedTable(1);
            if (abstractFixedTable != null && jTable.equals(abstractFixedTable.getTable())) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!this.isIncluded) {
                    if (bl) {
                        this.setForeground(UIManager.getColor("Label.disabledForeground").darker());
                    } else {
                        this.setForeground(UIManager.getColor("Label.disabledForeground"));
                    }
                }
                return this;
            }
            if (bl) {
                if (this.isIncluded) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setBackground(jTable.getSelectionBackground().darker());
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
            } else {
                if (abstractFixedTable2 != null && jTable.equals(abstractFixedTable2.getTable())) {
                    this.setBackground(jTable.getBackground());
                } else {
                    this.setBackground(this.getBackground(jTable));
                }
                if (this.isIncluded) {
                    this.setForeground(jTable.getForeground());
                } else {
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
            }
            int n3 = -1;
            if (jTable instanceof ExtendSortableScrollTable) {
                n3 = ((ExtendSortableScrollTable)jTable).getCurrentColumnIndex();
            }
            if (n3 == n2) {
                this.setBorder(EvinceBorderFactory.createMarkerBorder(bl3, bl4));
            } else {
                this.setBorder(null);
            }
            return this;
        }

        protected Color getBackground(JTable jTable) {
            return jTable.getBackground();
        }
    }

    private class DescriptionRenderer
    extends CustomStringRenderer {
        private final Color newDataColor = CellIdentifier.colorAddedData;
        private final Color newDataSelectedColor = this.newDataColor.darker();
        private final Color classColor = CellIdentifier.colorCategory;
        private final Color classSelectedColor = this.classColor.darker();

        private DescriptionRenderer() {
        }

        @Override
        protected Color getColor(JTable jTable, int n, int n2, boolean bl) {
            byte by = DataControlTable.this.dm.getRowType(n);
            switch (by) {
                case 12: 
                case 13: {
                    if (bl) {
                        return this.newDataSelectedColor;
                    }
                    return this.newDataColor;
                }
                case 3: {
                    if (bl) {
                        return this.classSelectedColor;
                    }
                    return this.classColor;
                }
            }
            return super.getColor(jTable, n, n2, bl);
        }
    }
}

