/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable.table;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.datasettable.ObservationSettings;
import se.prediktera.map.data.datasettable.ObservationSettingsToolbar;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.data.datasettable.table.DataControlTable;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class ObservationTable
extends AbstractControlTable {
    public ObservationTable(DataSetTable dataSetTable, DataInit dataInit) {
        super(dataSetTable, dataInit);
        this.table = dataSetTable;
    }

    @Override
    public int getColumnType() {
        return 16;
    }

    @Override
    public String getGUI_Name() {
        return "Observations";
    }

    @Override
    public int getInteractiveTag() {
        return 1;
    }

    @Override
    public int getRowType() {
        return 1;
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.setSelectionDialog(new AbstractControlTable.DataSetSelectionDialog(this.table, true));
    }

    public void setTrainTest(boolean bl, boolean bl2) {
        this.observationInfo.setTrainTest(this.getSelectedOrigIndex(true), bl, bl2);
        this.dataSetTable.updateInformation();
        this.simpleTable.repaint();
    }

    @Override
    protected boolean addToPopupInternal(Point point, JPopupMenu jPopupMenu, boolean bl) {
        boolean bl2 = this.simpleTable.getSelectedRowCount() > 0;
        CMenuItem cMenuItem = new CMenuItem("Train", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservationTable.this.setTrainTest(true, false);
            }
        };
        cMenuItem.setEnabled(bl2 && !this.dataSet.isProtected());
        jPopupMenu.add(cMenuItem);
        CMenuItem cMenuItem2 = new CMenuItem("Test", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservationTable.this.setTrainTest(false, true);
            }
        };
        cMenuItem2.setEnabled(bl2 && !this.dataSet.isProtected());
        jPopupMenu.add(cMenuItem2);
        CMenuItem cMenuItem3 = new CMenuItem("Train, Test", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservationTable.this.setTrainTest(true, true);
            }
        };
        cMenuItem3.setEnabled(bl2 && !this.dataSet.isProtected());
        jPopupMenu.add(cMenuItem3);
        jPopupMenu.addSeparator();
        if (this.dataSet instanceof DataSetGroup) {
            ((DataSetGroup)this.dataSet).addToPopupInternal(this, point, jPopupMenu, bl);
        }
        return true;
    }

    @Override
    protected SimpleTable createSimpleTable() {
        this.dataSet = (DataSet)this.dti;
        this.observationInfo = this.dataSet.getObsDataInfo();
        DataControlTable dataControlTable = new DataControlTable(this, this.centerPane, this.observationInfo);
        this.controlSettings = new ObservationSettings(this.dataSet, dataControlTable);
        this.controlToolbar = new ObservationSettingsToolbar(dataControlTable, this.dataSet);
        return dataControlTable;
    }
}

