/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datasettable.table;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.datasettable.VariableSettings;
import se.prediktera.map.data.datasettable.VariableSettingsToolbar;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.data.datasettable.table.DataControlTable;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class VariableTable
extends AbstractControlTable {
    public VariableTable(DataSetTable dataSetTable, DataInit dataInit) {
        super(dataSetTable, dataInit);
        this.table = dataSetTable;
    }

    @Override
    public int getColumnType() {
        return 16;
    }

    @Override
    public String getGUI_Name() {
        return "Variables";
    }

    @Override
    public int getInteractiveTag() {
        return 2;
    }

    @Override
    public int getOrigCount(boolean bl) {
        return super.getOrigCount(!bl);
    }

    @Override
    public int getRowType() {
        return 2;
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.setSelectionDialog(new AbstractControlTable.DataSetSelectionDialog(this.table, false));
    }

    public void setXY(boolean bl) {
        this.variableInfo.setXY(this.getSelectedOrigIndex(true), bl);
        this.dataSetTable.updateInformation();
        this.simpleTable.repaint();
    }

    @Override
    protected boolean addToPopupInternal(Point point, JPopupMenu jPopupMenu, boolean bl) {
        boolean bl2 = this.simpleTable.getSelectedRowCount() > 0;
        CMenuItem cMenuItem = new CMenuItem("X", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTable.this.setXY(true);
            }
        };
        cMenuItem.setEnabled(bl2 && !this.dataSet.isProtected());
        jPopupMenu.add(cMenuItem);
        CMenuItem cMenuItem2 = new CMenuItem("Y", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTable.this.setXY(false);
            }
        };
        cMenuItem2.setEnabled(bl2 && !this.dataSet.isProtected());
        jPopupMenu.add(cMenuItem2);
        jPopupMenu.addSeparator();
        return true;
    }

    @Override
    protected SimpleTable createSimpleTable() {
        this.dataSet = (DataSet)this.dti;
        this.variableInfo = this.dataSet.getVarDataInfo();
        DataControlTable dataControlTable = new DataControlTable(this, this.centerPane, this.variableInfo);
        this.controlSettings = new VariableSettings(this.dataSet, dataControlTable);
        this.controlToolbar = new VariableSettingsToolbar(dataControlTable, this.dataSet);
        return dataControlTable;
    }
}

