/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datatabbedpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicArrowButton;
import se.prediktera.map.data.datatabbedpanel.DataTabbedPaneUI;
import se.prediktera.map.data.datatabbedpanel.StopArrowButton;
import se.prediktera.map.data.datatabbedpanel.TabbedPaneButton;

public class DataTabbedPane
extends JTabbedPane {
    public static final String ROTATE = "Rotate";
    public static final String PREVIOUS = "Previous";
    public static final String NEXT = "Next";
    public static final String FIRST = "First";
    public static final String LEFT_SHIFT = "Left";
    public static final String RIGHT_SHIFT = "Right";
    public static final String LAST = "Last";
    public static final int ONE_BUTTON = 1;
    public static final int TWO_BUTTONS = 2;
    public static final int FOUR_BUTTONS = 4;
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 17;
    protected int buttonPlacement;
    protected int buttonCount;
    protected JButton[] tabPaneButtons;
    protected Dimension buttonSize;
    protected int visibleCount;
    protected int visibleStartIndex;

    public DataTabbedPane() {
        this(2, 4);
    }

    public DataTabbedPane(int n, int n2) {
        this.setButtonPreferredSize(new Dimension(16, 17));
        this.tabPaneButtons = this.createButtons(n);
        this.buttonPlacement = n2;
        this.visibleStartIndex = 0;
        this.setUI(new DataTabbedPaneUI());
    }

    public int getButtonCount() {
        return this.buttonCount;
    }

    public int getButtonPlacement() {
        return this.buttonPlacement;
    }

    public Dimension getButtonPreferredSize() {
        return this.buttonSize;
    }

    public JButton[] getButtons() {
        return this.tabPaneButtons;
    }

    public int getVisibleCount() {
        return this.visibleCount;
    }

    public int getVisibleStartIndex() {
        return this.visibleStartIndex;
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        if (component instanceof TabbedPaneButton) {
            component.setVisible(true);
            this.addImpl(component, null, -1);
            return;
        }
        super.insertTab(string, icon, component, string2, n);
    }

    public boolean isVisibleTab(int n) {
        return this.visibleStartIndex <= n && n < this.visibleStartIndex + this.visibleCount;
    }

    @Override
    public void removeTabAt(int n) {
        if (this.getTabCount() > 1) {
            if (n == this.getTabCount() - 1) {
                ((DataTabbedPaneUI)this.getUI()).selectPreviousTab(n);
            } else {
                ((DataTabbedPaneUI)this.getUI()).selectNextTab(n);
            }
        }
        super.removeTabAt(n);
        if (this.isVisibleTab(n)) {
            this.setVisibleStartIndex(this.visibleStartIndex - 1);
            this.setVisibleCount(this.visibleCount - 1);
        }
    }

    public void setButtonPreferredSize(Dimension dimension) {
        if (dimension != null) {
            this.buttonSize = dimension;
        }
    }

    @Override
    public void setTabPlacement(int n) {
        if (n == 2 || n == 4) {
            throw new IllegalArgumentException("not suported: LEFT and RIGHT");
        }
        super.setTabPlacement(n);
    }

    public void setVisibleCount(int n) {
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    public void setVisibleStartIndex(int n) {
        if (n < 0 || this.getTabCount() <= n) {
            return;
        }
        this.visibleStartIndex = n;
    }

    protected JButton[] createButtons(int n) {
        JButton[] jButtonArray = new JButton[n];
        this.buttonCount = n;
        switch (n) {
            case 1: {
                jButtonArray[0] = new PrevOrNextButton(3);
                jButtonArray[0].setActionCommand(ROTATE);
                break;
            }
            case 2: {
                jButtonArray[0] = new PrevOrNextButton(7);
                jButtonArray[0].setActionCommand(PREVIOUS);
                jButtonArray[1] = new PrevOrNextButton(3);
                jButtonArray[1].setActionCommand(NEXT);
                break;
            }
            case 4: {
                jButtonArray[0] = new FirstOrLastButton(7);
                jButtonArray[0].setActionCommand(FIRST);
                jButtonArray[1] = new PrevOrNextButton(7);
                jButtonArray[1].setActionCommand(LEFT_SHIFT);
                jButtonArray[2] = new PrevOrNextButton(3);
                jButtonArray[2].setActionCommand(RIGHT_SHIFT);
                jButtonArray[3] = new FirstOrLastButton(3);
                jButtonArray[3].setActionCommand(LAST);
                break;
            }
        }
        return jButtonArray;
    }

    protected void rightMouseClicked(int n, Point point) {
    }

    static class PrevOrNextButton
    extends BasicArrowButton
    implements TabbedPaneButton {
        public PrevOrNextButton(int n) {
            super(n);
        }
    }

    static class FirstOrLastButton
    extends StopArrowButton
    implements TabbedPaneButton {
        public FirstOrLastButton(int n) {
            super(n);
        }
    }
}

