/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.datatabbedpanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import se.prediktera.map.data.datatabbedpanel.DataTabbedPane;

public class DataTabbedPaneUI
extends MetalTabbedPaneUI {
    static final boolean showCloseButton = false;
    private final BasicStroke stroke1 = new BasicStroke(1.0f, 1, 0);
    private final BasicStroke stroke2 = new BasicStroke(2.0f, 1, 0);
    protected ActionListener[] buttonListeners;

    @Override
    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.selectColor = Color.white;
        this.runCount = 1;
        this.selectedRun = 0;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getTabCount();
        this.ensureCurrentLayout();
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        int n4 = dataTabbedPane.getVisibleCount();
        int n5 = dataTabbedPane.getVisibleStartIndex();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        this.tabRuns[0] = n5;
        int n6 = 0;
        for (int i = n5; n6 < n4 && i < n3; ++n6, ++i) {
            if (!this.rects[i].intersects(rectangle3)) continue;
            this.paintTab(graphics, n2, this.rects, i, rectangle, rectangle2);
        }
        if (dataTabbedPane.isVisibleTab(n) && this.rects[n].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n, rectangle, rectangle2);
        }
        this.paintContentBorder(graphics, n2, n);
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        int n3 = dataTabbedPane.getVisibleCount();
        int n4 = dataTabbedPane.getVisibleStartIndex();
        int n5 = 0;
        int n6 = n4;
        while (n5 < n3) {
            if (this.rects[n6].contains(n, n2)) {
                return n6;
            }
            ++n5;
            ++n6;
        }
        return -1;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        super.uninstallUI(jComponent);
    }

    @Override
    protected void assureRectsCreated(int n) {
        super.assureRectsCreated(n);
    }

    @Override
    protected int calculateMaxTabHeight(int n) {
        return super.calculateMaxTabHeight(n);
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return super.calculateTabWidth(n, n2, fontMetrics) + 20;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SingleRowTabbedLayout(this.tabPane);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    protected void ensureCurrentLayout() {
        SingleRowTabbedLayout singleRowTabbedLayout = (SingleRowTabbedLayout)this.tabPane.getLayout();
        singleRowTabbedLayout.calculateLayoutInfo();
        this.setButtonsEnabled();
    }

    protected void ensureVisibleTabAt(int n) {
        int n2;
        int n3;
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        int n4 = dataTabbedPane.getVisibleCount();
        int n5 = dataTabbedPane.getVisibleStartIndex();
        int n6 = n5 + n4 - 1;
        if (n5 < n && n < n6) {
            return;
        }
        if (n <= n5) {
            if (n5 == 0) {
                return;
            }
            dataTabbedPane.setVisibleStartIndex(--n5);
            ((SingleRowTabbedLayout)this.tabPane.getLayout()).calculateLayoutInfo();
            n3 = dataTabbedPane.getVisibleCount();
            n2 = dataTabbedPane.getVisibleStartIndex();
            if (n2 > n || n > n2 + n3 - 1) {
                dataTabbedPane.setVisibleStartIndex(++n5);
            }
        }
        if (n6 <= n) {
            if (n5 == n4 + 1) {
                return;
            }
            dataTabbedPane.setVisibleStartIndex(++n5);
            ((SingleRowTabbedLayout)this.tabPane.getLayout()).calculateLayoutInfo();
            n3 = dataTabbedPane.getVisibleCount();
            n2 = dataTabbedPane.getVisibleStartIndex();
            if (n2 > n || n > n2 + n3 - 1) {
                dataTabbedPane.setVisibleStartIndex(--n5);
            }
        }
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        if (this.tabPane.getGraphics() != null) {
            return this.tabPane.getGraphics().getFontMetrics(font);
        }
        return this.tabPane.getFontMetrics(font);
    }

    @Override
    protected Insets getTabAreaInsets(int n) {
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        Dimension dimension = dataTabbedPane.getButtonPreferredSize();
        int n2 = dataTabbedPane.getButtonCount();
        int n3 = dataTabbedPane.getButtonPlacement();
        Insets insets = new Insets(0, 0, 0, 0);
        if (n == 1) {
            insets.top = this.tabAreaInsets.top;
            insets.bottom = this.tabAreaInsets.bottom;
        } else {
            insets.top = this.tabAreaInsets.bottom;
            insets.bottom = this.tabAreaInsets.top;
        }
        if (n3 == 4) {
            insets.left = this.tabAreaInsets.left;
            insets.right = this.tabAreaInsets.right + n2 * dimension.width;
        } else {
            insets.left = this.tabAreaInsets.left + n2 * dimension.width;
            insets.right = this.tabAreaInsets.right;
        }
        return insets;
    }

    @Override
    protected void installComponents() {
        JButton[] jButtonArray = ((DataTabbedPane)this.tabPane).getButtons();
        if (jButtonArray != null) {
            for (JButton jButton : jButtonArray) {
                this.tabPane.add(jButton);
            }
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        JButton[] jButtonArray = dataTabbedPane.getButtons();
        int n = jButtonArray == null ? 0 : jButtonArray.length;
        this.buttonListeners = new ActionListener[n];
        for (int i = 0; i < n; ++i) {
            this.buttonListeners[i] = null;
            String string = jButtonArray[i].getActionCommand();
            if (string.equals("Rotate")) {
                this.buttonListeners[i] = new ShiftTabs(this){

                    @Override
                    protected int getStartIndex() {
                        int n = this.sPane.getVisibleStartIndex() + this.sPane.getVisibleCount();
                        return n < this.sPane.getTabCount() ? n : 0;
                    }
                };
            } else if (string.equals("Previous")) {
                this.buttonListeners[i] = new ShiftTabs(this){

                    @Override
                    protected int getStartIndex() {
                        return this.getStartIndex(this.sPane.getVisibleStartIndex() - 1);
                    }
                };
            } else if (string.equals("Next")) {
                this.buttonListeners[i] = new ShiftTabs(this){

                    @Override
                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() + this.sPane.getVisibleCount();
                    }
                };
            } else if (string.equals("First")) {
                this.buttonListeners[i] = new ShiftTabs();
            } else if (string.equals("Left")) {
                this.buttonListeners[i] = new ShiftTabs(this){

                    @Override
                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() - 1;
                    }
                };
            } else if (string.equals("Right")) {
                this.buttonListeners[i] = new ShiftTabs(this){

                    @Override
                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() + 1;
                    }
                };
            } else if (string.equals("Last")) {
                this.buttonListeners[i] = new ShiftTabs(this){

                    @Override
                    protected int getStartIndex() {
                        return this.getStartIndex(this.sPane.getTabCount() - 1);
                    }
                };
            }
            jButtonArray[i].addActionListener(this.buttonListeners[i]);
        }
    }

    @Override
    protected int lastTabInRun(int n, int n2) {
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        return dataTabbedPane.getVisibleStartIndex() + dataTabbedPane.getVisibleCount() - 1;
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.darkShadow);
        if (n != 3 || n2 < 0 || this.rects[n2].y - 1 > n6 || !((DataTabbedPane)this.tabPane).isVisibleTab(n2)) {
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.selectHighlight);
        if (n != 1 || n2 < 0 || this.rects[n2].y + this.rects[n2].height + 1 < n4 || !((DataTabbedPane)this.tabPane).isVisibleTab(n2)) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4, rectangle.x + 1, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
        }
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        super.paintTab(graphics, n, rectangleArray, n2, rectangle, rectangle2);
    }

    @Override
    protected void selectNextTab(int n) {
        for (int i = n + 1; i < this.tabPane.getTabCount(); ++i) {
            if (!this.tabPane.isEnabledAt(i)) continue;
            this.ensureVisibleTabAt(i);
            this.tabPane.setSelectedIndex(i);
            break;
        }
    }

    @Override
    protected void selectPreviousTab(int n) {
        for (int i = n - 1; 0 <= i; --i) {
            if (!this.tabPane.isEnabledAt(i)) continue;
            this.ensureVisibleTabAt(i);
            this.tabPane.setSelectedIndex(i);
            break;
        }
    }

    protected void setButtonsEnabled() {
        DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
        int n = dataTabbedPane.getVisibleCount();
        int n2 = dataTabbedPane.getVisibleStartIndex();
        JButton[] jButtonArray = dataTabbedPane.getButtons();
        boolean bl = 0 < n2;
        boolean bl2 = n2 + n < this.tabPane.getTabCount();
        for (JButton jButton : jButtonArray) {
            boolean bl3 = false;
            String string = jButton.getActionCommand();
            if (string.equals("Rotate")) {
                bl3 = bl || bl2;
            } else if (string.equals("Previous")) {
                bl3 = bl;
            } else if (string.equals("Next")) {
                bl3 = bl2;
            } else if (string.equals("First") || string.equals("Left")) {
                bl3 = bl;
            } else if (string.equals("Right")) {
                bl3 = bl2;
            } else if (string.equals("Last")) {
                bl3 = bl2;
            }
            jButton.setEnabled(bl3);
        }
    }

    @Override
    protected void uninstallComponents() {
        JButton[] jButtonArray = ((DataTabbedPane)this.tabPane).getButtons();
        if (jButtonArray != null) {
            for (JButton jButton : jButtonArray) {
                this.tabPane.remove(jButton);
            }
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        JButton[] jButtonArray = ((DataTabbedPane)this.tabPane).getButtons();
        if (jButtonArray != null) {
            for (int i = 0; i < jButtonArray.length; ++i) {
                jButtonArray[i].removeActionListener(this.buttonListeners[i]);
            }
        }
    }

    int getMaxTabHeight() {
        return this.maxTabHeight;
    }

    Rectangle[] getRects() {
        return this.rects;
    }

    DataTabbedPane getTabbedPane() {
        return (DataTabbedPane)this.tabPane;
    }

    void setMaxTabHeight(int n) {
        this.maxTabHeight = n;
    }

    class SingleRowTabbedLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        JTabbedPane tabPane;

        SingleRowTabbedLayout(JTabbedPane jTabbedPane) {
            super(DataTabbedPaneUI.this);
            this.tabPane = jTabbedPane;
        }

        @Override
        public void calculateLayoutInfo() {
            int n = this.tabPane.getTabCount();
            DataTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabWidths(this.tabPane.getTabPlacement(), n);
            this.calculateTabRects(this.tabPane.getTabPlacement(), n);
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            if (this.tabPane.getComponentCount() < 1) {
                return;
            }
            int n = this.tabPane.getTabPlacement();
            int n2 = DataTabbedPaneUI.this.calculateMaxTabHeight(n);
            Insets insets = DataTabbedPaneUI.this.getTabAreaInsets(n);
            Insets insets2 = this.tabPane.getInsets();
            Rectangle rectangle = this.tabPane.getBounds();
            DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
            Dimension dimension = dataTabbedPane.getButtonPreferredSize();
            JButton[] jButtonArray = dataTabbedPane.getButtons();
            int n3 = dataTabbedPane.getButtonPlacement();
            int n4 = n == 1 ? rectangle.y + insets2.top + insets.top : rectangle.y + rectangle.height - insets2.bottom - insets.bottom - n2;
            if (n3 == 4) {
                int n5 = rectangle.x + rectangle.width - insets2.right;
                for (int i = jButtonArray.length - 1; 0 <= i; --i) {
                    jButtonArray[i].setBounds(n5 -= dimension.width, n4, dimension.width, dimension.height);
                }
            } else {
                int n6 = rectangle.x + insets2.left;
                for (JButton jButton : jButtonArray) {
                    jButton.setBounds(n6, n4, dimension.width, dimension.height);
                    n6 += dimension.width;
                }
            }
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            DataTabbedPane dataTabbedPane = (DataTabbedPane)this.tabPane;
            Dimension dimension = this.tabPane.getSize();
            Insets insets = this.tabPane.getInsets();
            Insets insets2 = DataTabbedPaneUI.this.getTabAreaInsets(n);
            int n3 = DataTabbedPaneUI.this.getMaxTabHeight();
            int n4 = insets.left + insets2.left;
            int n5 = n == 1 ? insets.top + insets2.top : dimension.height - insets.bottom - insets2.bottom - n3;
            int n6 = dimension.width - (insets.right + insets2.right);
            Rectangle[] rectangleArray = DataTabbedPaneUI.this.getRects();
            int n7 = dataTabbedPane.getVisibleStartIndex();
            int n8 = 0;
            for (int i = n7; i < n2; ++i) {
                Rectangle rectangle = rectangleArray[i];
                rectangle.x = n7 < i ? rectangleArray[i - 1].x + rectangleArray[i - 1].width : n4;
                if (rectangle.x + rectangle.width > n6) break;
                ++n8;
                rectangle.y = n5;
            }
            dataTabbedPane.setVisibleCount(n8);
            dataTabbedPane.setVisibleStartIndex(n7);
        }

        protected void calculateTabWidths(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = DataTabbedPaneUI.this.getFontMetrics();
            int n3 = DataTabbedPaneUI.this.calculateMaxTabHeight(n);
            DataTabbedPaneUI.this.setMaxTabHeight(n3);
            Rectangle[] rectangleArray = DataTabbedPaneUI.this.getRects();
            for (int i = 0; i < n2; ++i) {
                rectangleArray[i].width = DataTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                rectangleArray[i].height = n3;
            }
        }
    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(DataTabbedPaneUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = -1;
            int n5 = DataTabbedPaneUI.this.tabPane.getTabCount();
            DataTabbedPane dataTabbedPane = (DataTabbedPane)DataTabbedPaneUI.this.tabPane;
            for (int i = n = dataTabbedPane.getVisibleStartIndex(); i < n5; ++i) {
                if (!DataTabbedPaneUI.this.rects[i].contains(n2, n3)) continue;
                n4 = i;
                break;
            }
            if (n4 >= 0 && SwingUtilities.isRightMouseButton(mouseEvent)) {
                ((DataTabbedPane)DataTabbedPaneUI.this.tabPane).rightMouseClicked(n4, mouseEvent.getPoint());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!DataTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = DataTabbedPaneUI.this.tabPane.getTabCount();
            DataTabbedPane dataTabbedPane = (DataTabbedPane)DataTabbedPaneUI.this.tabPane;
            int n4 = dataTabbedPane.getVisibleStartIndex();
            int n5 = -1;
            for (int i = n4; i < n3; ++i) {
                if (!DataTabbedPaneUI.this.rects[i].contains(n, n2)) continue;
                n5 = i;
                break;
            }
            if (n5 >= 0 && DataTabbedPaneUI.this.tabPane.isEnabledAt(n5)) {
                if (n5 == DataTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (DataTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        DataTabbedPaneUI.this.tabPane.requestFocus();
                        DataTabbedPaneUI.this.tabPane.repaint(DataTabbedPaneUI.this.getTabBounds(DataTabbedPaneUI.this.tabPane, n5));
                    }
                } else {
                    DataTabbedPaneUI.this.tabPane.setSelectedIndex(n5);
                }
            }
        }
    }

    protected class ShiftTabs
    implements ActionListener {
        DataTabbedPane sPane;

        protected ShiftTabs() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.sPane = DataTabbedPaneUI.this.getTabbedPane();
            int n = this.getStartIndex();
            this.sPane.setVisibleStartIndex(n);
            this.sPane.repaint();
        }

        protected int getStartIndex() {
            return 0;
        }

        protected int getStartIndex(int n) {
            int n2;
            Insets insets = this.sPane.getInsets();
            Insets insets2 = DataTabbedPaneUI.this.getTabAreaInsets(this.sPane.getTabPlacement());
            int n3 = this.sPane.getSize().width - (insets.left + insets.right) - (insets2.left + insets2.right);
            Rectangle[] rectangleArray = DataTabbedPaneUI.this.getRects();
            for (n2 = n; 0 <= n2 && (n3 -= rectangleArray[n2].width) >= 0; --n2) {
            }
            return ++n2;
        }
    }
}

