/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.fixed;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.cleanup.CleanUpScrollPane;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.fixed.FixedInterface;
import se.prediktera.map.data.fixed.FixedTableCellRenderer;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractFixedTable
extends CleanUpScrollPane
implements FixedInterface {
    protected AbstractTable abstractTable;
    protected SimpleTableModel tableModel;
    protected AbstractInnerTable table;
    protected AbstractFixedModel fixedModel;
    protected JList globalrowheader = null;
    protected int cellWidth = 75;

    public AbstractFixedTable(AbstractTable abstractTable, SimpleTable simpleTable) {
        this.abstractTable = abstractTable;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.table = this.createInnerTable(simpleTable);
        this.table.setAutoResizeMode(0);
        this.fixedModel = this.createFixedModel();
        ToolTipManager.sharedInstance().registerComponent(this.table);
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public AbstractInnerTable getColumnTable() {
        return this.table;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.height = 10000;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.table != null) {
            int n = 0;
            if (this.table.getRowHeader() != null) {
                n = this.table.getRowHeader().getFixedCellWidth();
            }
            int n2 = 0;
            if (this.table.getTableHeader() != null) {
                n2 = this.table.getTableHeader().getHeight();
            }
            if (this.table.getRowCount() > 0) {
                n2 += this.table.getRowHeight();
            }
            return new Dimension(n, n2);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public SimpleTable getTable() {
        return this.table;
    }

    public abstract boolean isFixedColumn();

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public void setModel(SimpleTableModel simpleTableModel) {
        this.tableModel = simpleTableModel;
        this.table.setModel(simpleTableModel, this.fixedModel);
    }

    @Override
    protected void cleanUpChild() {
        if (this.table != null) {
            this.table.cleanUp();
            this.table = null;
        }
    }

    protected abstract AbstractFixedModel createFixedModel();

    protected abstract AbstractInnerTable createInnerTable(SimpleTable var1);

    public abstract class AbstractInnerTable
    extends SimpleTable
    implements ComponentListener {
        protected SimpleTable mainTable;
        protected FixedTableCellRenderer fixedCellRenderer;

        public AbstractInnerTable(SimpleTable simpleTable) {
            super((JScrollPane)AbstractFixedTable.this, AbstractFixedTable.this.abstractTable instanceof AbstractSimpleTable ? (AbstractSimpleTable)AbstractFixedTable.this.abstractTable : null, false, false, false);
            this.mainTable = simpleTable;
            this.setBorder(null);
            this.setSelectionModel(simpleTable.getSelectionModel());
            this.fixedCellRenderer = simpleTable.createFixedTableCellRenderer();
            this.setDefaultRenderer(String.class, this.fixedCellRenderer);
        }

        @Override
        public void addToHeaderPopup(MouseEvent mouseEvent, JPopupMenu jPopupMenu, int n) {
            this.mainTable.addToHeaderPopup(mouseEvent, jPopupMenu, n);
        }

        public void autoSize() {
            Serializable serializable;
            int n;
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n2 = this.getColumnCount();
            for (n = 0; n < n2; ++n) {
                serializable = tableColumnModel.getColumn(n);
                ((TableColumn)serializable).setWidth(AbstractFixedTable.this.cellWidth);
                ((TableColumn)serializable).setMinWidth(AbstractFixedTable.this.cellWidth);
                ((TableColumn)serializable).setPreferredWidth(AbstractFixedTable.this.cellWidth);
            }
            n = AbstractFixedTable.this.cellWidth * this.getColumnCount();
            serializable = this.getTableHeader();
            Dimension dimension = ((JTableHeader)serializable).getPreferredSize();
            dimension.width = n += (AbstractFixedTable.this.cellWidth * this.getColumnCount() - 1) * this.getIntercellSpacing().width;
            ((JComponent)serializable).setPreferredSize(dimension);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void fireTableStructureChanged() {
            AbstractFixedTable.this.fixedModel.fireTableStructureChanged(this);
            super.fireTableStructureChanged();
        }

        public SimpleTable getMainTable() {
            return this.mainTable;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                Object object = this.getValueAt(n, n2);
                jComponent.setToolTipText(object == null ? null : object.toString());
            }
            return component;
        }

        @Override
        public void setCurrentColumn(int n) {
            super.setCurrentColumn(n);
            this.mainTable.setCurrentColumnNoPropagate(n);
        }

        public void setModel(SimpleTableModel simpleTableModel, AbstractTableModel abstractTableModel) {
            super.setModel(abstractTableModel);
            Color color = simpleTableModel.isObsColumn() == AbstractFixedTable.this.isFixedColumn() ? CellIdentifierModel.getColorByType(1) : CellIdentifierModel.getColorByType(0);
            this.fixedCellRenderer.setTypeColor(color);
            this.fireTableChanged();
        }

        @Override
        public void updateInfo() {
            AbstractFixedTable.this.abstractTable.UpdateInfo();
        }

        @Override
        protected void cleanUpChild() {
            super.cleanUpChild();
            this.mainTable = null;
        }
    }

    protected abstract class AbstractFixedModel
    extends AbstractTableModel {
        protected AbstractFixedModel() {
        }

        public void fireTableStructureChanged(SimpleTable simpleTable) {
            block4: {
                int n = simpleTable.getColumnModel().getColumnCount();
                int n2 = this.getColumnCount();
                if (n2 == n) break block4;
                if (n2 > n) {
                    for (int i = n; i < n2; ++i) {
                        simpleTable.addColumn(i);
                    }
                } else {
                    for (int i = n2; i < n; ++i) {
                        simpleTable.removeColumn(simpleTable.getColumnModel().getColumn(n2));
                    }
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (AbstractFixedTable.this.tableModel != null) {
                return AbstractFixedTable.this.tableModel.isDescriptionEditable(n, n2);
            }
            return true;
        }
    }
}

