/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.fixed;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.datasettable.table.ObservationTable;
import se.prediktera.map.data.fixed.AbstractFixedTable;

public class FixedColumnTable
extends AbstractFixedTable
implements MouseWheelListener {
    private final JScrollBar centerColumnBar;
    private final JScrollBar columnBar;

    public FixedColumnTable(AbstractTable abstractTable, SimpleTable simpleTable, JScrollPane jScrollPane) {
        super(abstractTable, simpleTable);
        boolean bl;
        this.table.setAutoResizeMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.addMouseWheelListener(this);
        this.table.getRowHeader().addMouseWheelListener(this);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(21);
        this.centerColumnBar = jScrollPane.getVerticalScrollBar();
        this.columnBar = this.getVerticalScrollBar();
        boolean bl2 = bl = !(abstractTable instanceof ObservationTable);
        if (bl) {
            this.centerColumnBar.addAdjustmentListener(adjustmentEvent -> {
                this.columnBar.setValue(adjustmentEvent.getValue());
                abstractTable.updateUI();
            });
        } else {
            this.centerColumnBar.addAdjustmentListener(adjustmentEvent -> this.columnBar.setValue(adjustmentEvent.getValue()));
        }
        this.columnBar.addAdjustmentListener(adjustmentEvent -> {
            this.centerColumnBar.setValue(adjustmentEvent.getValue());
            if (this.table != null && this.globalrowheader != null) {
                this.globalrowheader.scrollRectToVisible(this.table.getMainTable().getVisibleRect());
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.setSize(dimension.width, 0);
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.setSize(dimension.width + this.cellWidth, 0);
        return dimension;
    }

    @Override
    public boolean isFixedColumn() {
        return true;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.table.getMainTable().getParent().dispatchEvent(mouseWheelEvent);
    }

    @Override
    public void setColumnHeaderView(Component component) {
    }

    @Override
    protected AbstractFixedTable.AbstractFixedModel createFixedModel() {
        return new FixedColumnModel();
    }

    @Override
    protected AbstractFixedTable.AbstractInnerTable createInnerTable(SimpleTable simpleTable) {
        return new ColumnTable(simpleTable);
    }

    protected class FixedColumnModel
    extends AbstractFixedTable.AbstractFixedModel {
        protected FixedColumnModel() {
        }

        @Override
        public int getColumnCount() {
            if (FixedColumnTable.this.tableModel != null) {
                return FixedColumnTable.this.tableModel.getRowDescriptionCount();
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public int getRowCount() {
            if (FixedColumnTable.this.tableModel != null) {
                return FixedColumnTable.this.tableModel.getRowCount();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (FixedColumnTable.this.tableModel != null) {
                return FixedColumnTable.this.tableModel.getColumnDescriptionSorted(n, n2);
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (FixedColumnTable.this.tableModel != null) {
                FixedColumnTable.this.tableModel.setColumnDescriptionSorted(n, n2, (String)object);
            }
        }
    }

    public class ColumnTable
    extends AbstractFixedTable.AbstractInnerTable
    implements ComponentListener {
        public ColumnTable(SimpleTable simpleTable) {
            super(simpleTable);
            this.setSelectionModel(simpleTable.getSelectionModel());
            this.addRowHeader(simpleTable);
            final AbstractSimpleTable abstractSimpleTable = simpleTable.getAbstractTable();
            this.rowHeader.addMouseListener(new MouseAdapter(this){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        abstractSimpleTable.mousePressed(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        abstractSimpleTable.mouseReleased(mouseEvent);
                    }
                }
            });
        }

        @Override
        public void fireTableChanged() {
            super.fireTableChanged();
            if (this.getColumnCount() > 0) {
                this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
                this.autoSize();
            }
        }

        @Override
        public void setModel(SimpleTableModel simpleTableModel, AbstractTableModel abstractTableModel) {
            super.setModel(simpleTableModel, abstractTableModel);
            this.rowHeaderListeners.setHeaderModel(simpleTableModel);
        }
    }
}

