/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.fixed;

import javax.swing.AbstractListModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.DataTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.fixed.AbstractFixedTable;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableScrollTable;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableTableModel;
import se.prediktera.map.simpletableeditor.sortable.SortButtonRenderer;

public class FixedCornerTable
extends AbstractFixedTable {
    private final JScrollBar rowBar;
    private final boolean hasData;

    public FixedCornerTable(AbstractTable abstractTable, DataTable dataTable, JScrollPane jScrollPane, boolean bl) {
        super(abstractTable, dataTable);
        this.hasData = bl;
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.table.setAutoResizeMode(0);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        JScrollBar jScrollBar = dataTable.getFixedTable(0).getHorizontalScrollBar();
        this.rowBar = this.getHorizontalScrollBar();
        jScrollBar.addAdjustmentListener(adjustmentEvent -> this.rowBar.setValue(adjustmentEvent.getValue()));
    }

    @Override
    public boolean isFixedColumn() {
        return true;
    }

    @Override
    protected AbstractFixedTable.AbstractFixedModel createFixedModel() {
        return new FixedCornerModel();
    }

    @Override
    protected AbstractFixedTable.AbstractInnerTable createInnerTable(SimpleTable simpleTable) {
        if (simpleTable instanceof DataTable) {
            return new CornerTable((DataTable)simpleTable);
        }
        return null;
    }

    protected class FixedCornerModel
    extends AbstractFixedTable.AbstractFixedModel {
        protected FixedCornerModel() {
        }

        @Override
        public int getColumnCount() {
            if (FixedCornerTable.this.tableModel != null) {
                return FixedCornerTable.this.tableModel.getRowDescriptionCount();
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            if (FixedCornerTable.this.hasData || FixedCornerTable.this.tableModel == null) {
                return "ID " + (n + 1);
            }
            return String.valueOf(FixedCornerTable.this.tableModel.getRowDescriptionTitle(n));
        }

        @Override
        public int getRowCount() {
            if (FixedCornerTable.this.hasData && FixedCornerTable.this.tableModel != null) {
                return FixedCornerTable.this.tableModel.getColumnDescriptionCount();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0 && FixedCornerTable.this.tableModel != null) {
                return FixedCornerTable.this.tableModel.getRowDescriptionTitle(n2);
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n == 0 && FixedCornerTable.this.tableModel != null) {
                FixedCornerTable.this.tableModel.setRowDescriptionTitle(n2, (String)object);
            }
        }
    }

    public class CornerTable
    extends AbstractFixedTable.AbstractInnerTable {
        private SimpleTable rowTable;
        private SimpleTable columnTable;

        public CornerTable(DataTable dataTable) {
            super(dataTable);
            this.columnTable = dataTable.getFixedTable(0).getTable();
            this.rowTable = dataTable.getFixedTable(1).getTable();
            this.setColumnModel(this.columnTable.getColumnModel());
            this.getTableHeader().setTable(this.columnTable);
            this.getTableHeader().setColumnModel(this.columnTable.getColumnModel());
            this.addColHeader(this.columnTable);
            AbstractListModel abstractListModel = new AbstractListModel(){

                @Override
                public Object getElementAt(int n) {
                    return "";
                }

                @Override
                public int getSize() {
                    if (FixedCornerTable.this.tableModel == null) {
                        return 0;
                    }
                    return FixedCornerTable.this.tableModel.getRowCount();
                }
            };
            this.addRowHeader(abstractListModel, null);
        }

        @Override
        public void addColListener() {
            JTableHeader jTableHeader = this.getTableHeader();
            this.headerRenderer = new SortButtonRenderer();
            this.headerListener = new ReferenceHeaderListener(jTableHeader, (SortButtonRenderer)this.headerRenderer);
            jTableHeader.addMouseListener(this.headerListener);
        }

        @Override
        protected void cleanUpChild() {
            super.cleanUpChild();
            this.rowTable = null;
            this.columnTable = null;
        }

        class ReferenceHeaderListener
        extends ExtendSortableScrollTable.HeaderListener {
            public ReferenceHeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer) {
                super(CornerTable.this, jTableHeader, sortButtonRenderer);
            }

            @Override
            public void sort(boolean bl, int n, boolean bl2, ExtendSortableScrollTable extendSortableScrollTable) {
                this.sortCol = n;
                this.isAscent = bl2;
                ExtendSortableScrollTable.HeaderListener headerListener2 = CornerTable.this.rowTable.getHeaderListener();
                headerListener2.set(bl, n, bl2, CornerTable.this);
                this.selectColumn(n);
                ExtendSortableTableModel extendSortableTableModel = headerListener2.getHeaderModel();
                extendSortableTableModel.sortByColumn(bl, n, bl2, CornerTable.this.columnTable.getModel());
                extendSortableTableModel.fireTableDataChanged();
                this.renderer.setPressedColumn(-1);
                this.header.repaint();
                CornerTable.this.columnTable.repaint();
            }
        }
    }
}

