/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.fixed;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.fixed.AbstractFixedTable;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;

public class FixedRowTable
extends AbstractFixedTable {
    private final JScrollBar centerRowBar;
    private final JScrollBar rowBar;
    private final boolean hasData;

    public FixedRowTable(AbstractTable abstractTable, SimpleTable simpleTable, JScrollPane jScrollPane, boolean bl) {
        super(abstractTable, simpleTable);
        this.hasData = bl;
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(22);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AbstractFixedTable.AbstractInnerTable abstractInnerTable = (AbstractFixedTable.AbstractInnerTable)mouseEvent.getSource();
                ListSelectionModel listSelectionModel = abstractInnerTable.getColumnModel().getSelectionModel();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    ExtendScrollTable.HeaderListeners headerListeners = FixedRowTable.this.table.getHeaderListeners(false);
                    if (headerListeners != null) {
                        headerListeners.selectInterval(n, false, false);
                    }
                }
            }
        });
        this.centerRowBar = jScrollPane.getHorizontalScrollBar();
        this.rowBar = this.getHorizontalScrollBar();
        this.centerRowBar.addAdjustmentListener(adjustmentEvent -> this.rowBar.setValue(adjustmentEvent.getValue()));
        this.rowBar.addAdjustmentListener(adjustmentEvent -> this.centerRowBar.setValue(adjustmentEvent.getValue()));
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.setSize(0, dimension.height);
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.setSize(this.getWidth(), dimension.height);
        return dimension;
    }

    @Override
    public boolean isFixedColumn() {
        return false;
    }

    @Override
    protected AbstractFixedTable.AbstractFixedModel createFixedModel() {
        return new FixedRowModel();
    }

    @Override
    protected AbstractFixedTable.AbstractInnerTable createInnerTable(SimpleTable simpleTable) {
        return new RowTable(simpleTable);
    }

    protected class FixedRowModel
    extends AbstractFixedTable.AbstractFixedModel {
        protected FixedRowModel() {
        }

        @Override
        public int getColumnCount() {
            if (FixedRowTable.this.tableModel != null) {
                return FixedRowTable.this.tableModel.getColumnCount();
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return String.valueOf(n + 1);
        }

        @Override
        public int getRowCount() {
            if (FixedRowTable.this.hasData && FixedRowTable.this.tableModel != null) {
                return FixedRowTable.this.tableModel.getColumnDescriptionCount();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (FixedRowTable.this.tableModel != null) {
                return FixedRowTable.this.tableModel.getRowDescription(n, n2);
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (FixedRowTable.this.tableModel != null) {
                FixedRowTable.this.tableModel.setRowDescription(n, n2, (String)object);
            }
        }
    }

    class RowTable
    extends AbstractFixedTable.AbstractInnerTable {
        public RowTable(SimpleTable simpleTable) {
            super(simpleTable);
            this.setColumnModel(simpleTable.getColumnModel());
            this.getTableHeader().setTable(simpleTable);
            this.getTableHeader().setColumnModel(simpleTable.getColumnModel());
            this.addColHeader(simpleTable);
        }

        @Override
        public void fireTableChanged() {
            super.fireTableChanged();
        }

        @Override
        public void setModel(SimpleTableModel simpleTableModel, AbstractTableModel abstractTableModel) {
            super.setModel(simpleTableModel, abstractTableModel);
            this.colHeaderListeners.setHeaderModel(simpleTableModel);
        }
    }
}

