/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.data.SimpleTableModel;

public class ImageTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final SimpleTableModel tableModel;
    private final ResourceNode resourceNode;
    private int row;

    public ImageTableCellRenderer(SimpleTableModel simpleTableModel, ResourceNode resourceNode) {
        this.tableModel = simpleTableModel;
        this.resourceNode = resourceNode;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.row = this.tableModel.getDataRow(n);
        if (object != null) {
            this.setToolTipText(object.toString());
        }
        this.setText("");
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.resourceNode != null && this.row < this.resourceNode.getTreeNodeCount()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = this.getWidth();
            int n2 = this.getHeight();
            ImageResource imageResource = (ImageResource)this.resourceNode.getTreeNodeAt(this.row);
            imageResource.draw((Graphics)graphics2D, n, n2);
        }
    }
}

