/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.intervall;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.data.AbstractDataTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.intervall.IntervallTableCellRenderer;
import se.prediktera.map.data.intervall.IntervallTableListener;

public abstract class AbstractIntervalTable
extends AbstractDataTable {
    private SimpleTableModel simpleTableModel;

    public AbstractIntervalTable(DataInit dataInit) {
        super(dataInit);
        this.init();
    }

    public AbstractIntervalTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init();
    }

    public void beginUpdate(int n) {
    }

    public abstract void cellSelectionFinished(int var1);

    public void endUpdate(int n) {
    }

    public boolean isCellIncluded(int n, int n2) {
        return this.isCellIncludedSorted(this.simpleTableModel.getSortedRow(n, n2), n2);
    }

    public void setCellIncluded(int n, int n2, boolean bl, boolean bl2) {
        this.setCellIncludedSorted(this.simpleTableModel.getSortedRow(n, n2), n2, bl, bl2);
    }

    public boolean showBar(int n) {
        return true;
    }

    public void swapCellIncluded(int n, int n2) {
        this.setCellIncludedSorted(n, n2, !this.isCellIncludedSorted(n = this.simpleTableModel.getSortedRow(n, n2), n2), true);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.simpleTableModel != null) {
            this.simpleTableModel.cleanUp();
            this.simpleTableModel = null;
        }
    }

    protected abstract boolean isCellIncludedSorted(int var1, int var2);

    protected abstract void setCellIncludedSorted(int var1, int var2, boolean var3, boolean var4);

    private void init() {
        SimpleTable simpleTable = this.getSimpleTable();
        this.simpleTableModel = simpleTable.getSimpleTableModel();
        simpleTable.setCanPaste(true);
        IntervallTableListener intervallTableListener = new IntervallTableListener(this);
        simpleTable.addMouseListener(intervallTableListener);
        simpleTable.addMouseMotionListener(intervallTableListener);
        simpleTable.setDefaultRenderer(String.class, new IntervallTableCellRenderer(this));
    }
}

