/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.intervall;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.intervall.AbstractIntervalTable;
import se.prediktera.map.data.intervall.IntervallTable;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableScrollTable;

public class IntervallTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final int insets = 5;
    private static final Color intervalColor = new Color(140, 255, 140, 100);
    private static final Color disabledColor = new Color(25, 25, 25, 100);
    private static final BasicStroke doubleStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
    private Color intervalColor2 = null;
    protected boolean firstRow;
    protected boolean lastRow;
    protected boolean uinc;
    protected boolean inc;
    protected boolean linc;
    protected AbstractIntervalTable intervalTable;
    protected boolean paintBars = true;
    protected boolean isIncluded = true;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(2);
        Case case_ = new Case(10, 10);
        MVmatrix mVmatrix = new MVmatrix(10, 10);
        case_.setOriginalMatrix(mVmatrix);
        Random random = new Random(0L);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                double d = random.nextDouble();
                if (j == 0) {
                    System.out.println(d);
                }
                mVmatrix.setValue(i, j, d);
            }
        }
        DataInit dataInit = new DataInit(mVmatrix);
        IntervallTable intervallTable = new IntervallTable(dataInit);
        SimpleTable simpleTable = intervallTable.getSimpleTable();
        simpleTable.setDefaultRenderer(String.class, new IntervallTableCellRenderer(intervallTable));
        jFrame.getContentPane().add(intervallTable);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public IntervallTableCellRenderer(AbstractIntervalTable abstractIntervalTable) {
        this.intervalTable = abstractIntervalTable;
        this.setOpaque(true);
    }

    public IntervallTableCellRenderer(AbstractIntervalTable abstractIntervalTable, Color color) {
        this(abstractIntervalTable);
        this.intervalColor2 = color;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null) {
            this.setText(object.toString());
        }
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.inc = this.intervalTable.isCellIncluded(n, n2);
        this.firstRow = n <= 0;
        this.uinc = this.firstRow ? false : this.intervalTable.isCellIncluded(n - 1, n2);
        this.lastRow = n >= jTable.getRowCount() - 1;
        this.linc = this.lastRow ? false : this.intervalTable.isCellIncluded(n + 1, n2);
        int n3 = -1;
        if (jTable instanceof ExtendSortableScrollTable) {
            n3 = ((ExtendSortableScrollTable)jTable).getCurrentColumnIndex();
        }
        if (n3 == n2) {
            boolean bl3 = n == 0;
            boolean bl4 = n == jTable.getRowCount() - 1;
            this.setBorder(EvinceBorderFactory.createMarkerBorder(bl3, bl4));
        } else {
            this.setBorder(null);
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.paintBars) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth() - 5;
        int n2 = n - 5;
        int n3 = n2 / 2 + 5;
        int n4 = this.getHeight();
        Stroke stroke = graphics2D.getStroke();
        if (this.inc) {
            graphics2D.setColor(this.isIncluded ? intervalColor : disabledColor);
        } else if (this.intervalColor2 != null) {
            graphics2D.setColor(this.isIncluded ? this.intervalColor2 : disabledColor);
            this.inc = true;
            this.uinc = !this.firstRow;
            boolean bl = this.linc = !this.lastRow;
        }
        if (this.inc) {
            graphics2D.fillRect(5, 0, n2, n4);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(5, 0, 5, n4);
            graphics2D.drawLine(n, 0, n, n4);
            graphics2D.setColor(Color.lightGray);
            graphics2D.drawLine(n + 1, 0, n + 1, n4);
            graphics2D.setStroke(doubleStroke);
            if (!this.uinc) {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(6, 0, n - 1, 0);
                graphics2D.drawLine(n3 - 3, 1, n3, 3);
                graphics2D.drawLine(n3, 3, n3 + 3, 1);
            }
            if (!this.linc) {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(n3 - 3, n4 - 1, n3, n4 - 4);
                graphics2D.drawLine(n3, n4 - 4, n3 + 3, n4 - 1);
                graphics2D.drawLine(6, n4 - 1, n - 1, n4 - 1);
            }
        }
        graphics2D.setStroke(stroke);
    }
}

