/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.intervall;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.intervall.AbstractIntervalTable;

public class IntervallTableListener
implements MouseListener,
MouseMotionListener {
    private static final int LIMIT = 3;
    private final AbstractIntervalTable intervallTable;
    private final SimpleTable table;
    private Point lastPoint = null;
    private boolean legalDrag = false;
    private boolean selectionChange = false;
    private final boolean defaultTableState;

    public IntervallTableListener(AbstractIntervalTable abstractIntervalTable) {
        this.intervallTable = abstractIntervalTable;
        this.table = abstractIntervalTable.getSimpleTable();
        this.defaultTableState = this.table.isEnabled();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            int n2 = this.table.columnAtPoint(point);
            this.intervallTable.swapCellIncluded(n, n2);
            this.intervallTable.repaint();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.legalDrag && SwingUtilities.isLeftMouseButton(mouseEvent) && this.lastPoint != null && mouseEvent.getPoint() != null) {
            int n = this.table.rowAtPoint(this.lastPoint);
            int n2 = this.table.columnAtPoint(this.lastPoint);
            int n3 = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0 || n3 >= 0) {
                if (n < 0) {
                    n = this.lastPoint.getY() < (double)mouseEvent.getY() ? 0 : this.table.getRowCount() - 1;
                }
                if (n3 < 0) {
                    n3 = this.lastPoint.getY() < (double)mouseEvent.getY() ? this.table.getRowCount() : -1;
                }
                this.intervallTable.beginUpdate(n2);
                if (n < n3) {
                    for (int i = n; i < n3; ++i) {
                        this.intervallTable.setCellIncluded(i, n2, this.selectionChange, false);
                    }
                } else if (n3 < n) {
                    for (int i = n3 + 1; i <= n; ++i) {
                        this.intervallTable.setCellIncluded(i, n2, !this.selectionChange, false);
                    }
                }
                this.intervallTable.endUpdate(n2);
                this.intervallTable.repaint();
                this.lastPoint.setLocation(this.lastPoint.getX(), mouseEvent.getPoint().getY());
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.legalDrag) {
            this.table.setEnabled(this.defaultTableState);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.legalDrag) {
            this.table.setEnabled(this.defaultTableState);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.columnAtPoint(point);
        if (n < 0 || n2 < 0) {
            return;
        }
        if (!this.intervallTable.showBar(n2)) {
            this.intervallTable.setCursor(Cursor.getDefaultCursor());
            return;
        }
        boolean bl = this.intervallTable.isCellIncluded(n, n2);
        boolean bl2 = false;
        bl2 = n <= 0 ? !bl : this.intervallTable.isCellIncluded(n - 1, n2);
        boolean bl3 = false;
        bl3 = n >= this.table.getRowCount() - 1 ? !bl : this.intervallTable.isCellIncluded(n + 1, n2);
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (bl != bl2 && Math.abs(rectangle.getY() - point.getY()) < 3.0) {
            this.intervallTable.setCursor(Cursor.getPredefinedCursor(8));
            this.selectionChange = !bl;
            this.legalDrag = true;
        } else if (bl != bl3 && Math.abs(rectangle.getY() + rectangle.getHeight() - point.getY()) < 3.0) {
            this.intervallTable.setCursor(Cursor.getPredefinedCursor(8));
            this.selectionChange = bl;
            this.legalDrag = true;
        } else {
            this.intervallTable.setCursor(Cursor.getPredefinedCursor(0));
            this.legalDrag = false;
        }
        if (this.legalDrag) {
            this.table.setEnabled(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastPoint = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.legalDrag && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.table.columnAtPoint(mouseEvent.getPoint());
            this.intervallTable.cellSelectionFinished(n);
        }
        this.legalDrag = false;
        this.table.setEnabled(this.defaultTableState);
    }
}

